/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.dao.dbImpl.DbTaskDAO;
import kd.bos.schedule.server.ScheduleService;
import kd.pmc.pmts.business.helper.TaskScheduleDetailHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class PmtsTaskHelper {
    private static final Log log = LogFactory.getLog(PmtsTaskHelper.class);

    private static ObjectFactory getObjectFactory() {
        return ScheduleService.getInstance().getObjectFactory();
    }

    public static void hasError(PmtsTaskRunTimeInfo rInfo, String errorMsg) {
        String taskid = rInfo.getTaskid();
        rInfo.setStop(true);
        TaskScheduleDetailHelper.addStep(rInfo, errorMsg);
        DbTaskDAO taskDao = (DbTaskDAO)PmtsTaskHelper.getObjectFactory().getTaskDao();
        taskDao.updateProgress(taskid, 100, errorMsg, null);
        taskDao.updateStatus(taskid, "FAILED");
        ErrorCode ec = new ErrorCode("TASK_FALIDED", errorMsg);
        throw new KDException(ec, new Object[0]);
    }

    public static void hasComplete(PmtsTaskRunTimeInfo rInfo) {
        String taskId = rInfo.getTaskid();
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u7b97\u5b8c\u6bd5", (String)"PmtsTaskHelper_0", (String)"mmc-pmts-business", (Object[])new Object[0]);
        TaskScheduleDetailHelper.addStep(rInfo, msg);
        DbTaskDAO taskDao = (DbTaskDAO)PmtsTaskHelper.getObjectFactory().getTaskDao();
        taskDao.updateProgress(taskId, 100, msg, null);
        taskDao.updateStatus(taskId, "COMPLETED");
    }

    public static void hasRunning(PmtsTaskRunTimeInfo rInfo, String msg) {
        String taskId = rInfo.getTaskid();
        TaskScheduleDetailHelper.addStep(rInfo, msg);
        DbTaskDAO taskDao = (DbTaskDAO)PmtsTaskHelper.getObjectFactory().getTaskDao();
        taskDao.updateProgress(taskId, 0, msg, null);
        taskDao.updateRuntime(taskId, System.currentTimeMillis());
    }

    public static void hasBeginning(PmtsTaskRunTimeInfo rInfo) {
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u7b97\u5f00\u59cb", (String)"PmtsTaskHelper_1", (String)"mmc-pmts-business", (Object[])new Object[0]);
        String taskId = rInfo.getTaskid();
        TaskScheduleDetailHelper.addStep(rInfo, msg);
        DbTaskDAO taskDao = (DbTaskDAO)PmtsTaskHelper.getObjectFactory().getTaskDao();
        taskDao.updateStatus(taskId, "BEGIN");
        taskDao.updateProgress(taskId, 0, ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u7b97\u5f00\u59cb", (String)"PmtsTaskHelper_1", (String)"mmc-pmts-business", (Object[])new Object[0]), null);
    }
}

