/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReleaseHelper {
    private static final Log log = LogFactory.getLog(ReleaseHelper.class);
    public static final String PMTS_LICORG_CODERULE = "pmts_licorg_coderule";

    public static DynamicObject queryLicOrgCordRule(String licOrgNo, Object pk, Integer version) {
        String ver = String.valueOf(version);
        QFilter qFilter = new QFilter("licensegroup", "=", pk);
        qFilter.and("version", "=", (Object)String.valueOf(version));
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((String)PMTS_LICORG_CODERULE, (String)"splitsign,value", (QFilter[])qFilter.toArray());
        if (rule == null) {
            rule = ReleaseHelper.createCodeRule(licOrgNo, pk, ver);
        }
        return rule;
    }

    public static String getCodeNumber(DynamicObject licOrg, Integer version) {
        Object licOrgPk;
        if (licOrg == null) {
            return (version == null ? "" : version) + "0000001";
        }
        String licOrgNo = licOrg.getString("number");
        DynamicObject rule = ReleaseHelper.queryLicOrgCordRule(licOrgNo, licOrgPk = licOrg.getPkValue(), version);
        String[] nos = ReleaseHelper.createNumber(rule, licOrgNo, version, 1);
        return nos.length == 0 ? null : nos[0];
    }

    public static DynamicObject createCodeRule(String licOrgNo, Object licOrgPk, String version) {
        DynamicObject rule = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)PMTS_LICORG_CODERULE));
        rule.set("billno", (Object)licOrgNo);
        rule.set("version", (Object)version);
        rule.set("licensegroup", licOrgPk);
        rule.set("value", (Object)0L);
        rule.set("splitsign", (Object)"");
        return rule;
    }

    public static String createCodeNumber(String licOrgNo, Object licOrgPk, Integer version) {
        String[] nos = ReleaseHelper.createCodeNumbers(licOrgNo, licOrgPk, version, 1);
        return nos == null || nos.length == 0 ? null : nos[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] createCodeNumbers(String licOrgNo, Object licOrgPk, Integer version, int size) {
        DLock lock = DLock.create((String)("mmc/pmts/releasecode/" + licOrgNo + version));
        try {
            if (lock.tryLock(300000L)) {
                DynamicObject rule = ReleaseHelper.queryLicOrgCordRule(licOrgNo, licOrgPk, version);
                String[] nos = ReleaseHelper.createNumber(rule, licOrgNo, version, size);
                rule.set("value", (Object)(rule.getLong("value") + (long)size));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rule});
                String[] stringArray = nos;
                return stringArray;
            }
            log.error("\u653e\u884c\u5355\u751f\u6210\uff0c\u7f16\u7801\u83b7\u53d6\u9501\u5931\u8d25\u3002");
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    public static String[] createNumber(DynamicObject rule, String licOrgNo, Integer version, int size) {
        long value = rule.getLong("value");
        String fmt = "%07d";
        String slpt = rule.getString("splitsign");
        String[] nos = new String[size];
        String ver = version == null ? "" : version + "";
        for (int i = 0; i < size; ++i) {
            String no = String.format(fmt, ++value);
            nos[i] = String.format("%1$s%2$s%3$s%4$s%5$s", licOrgNo, slpt, ver, slpt, no);
        }
        return nos;
    }

    public static Object queryModelManufacturer(Object modelPk) {
        QFilter qFilter = new QFilter("modelonef7", "=", modelPk);
        qFilter.or("modelmpdonef7", "=", modelPk);
        qFilter.or("modeltwof7", "=", modelPk);
        qFilter.or("modeltrdf7", "=", modelPk);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"mpdm_mrtype", (String)"manufacturer", (QFilter[])qFilter.toArray(), (String)"manufacturer", (int)1);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return ((DynamicObject)collection.get(0)).get(0);
    }

    public static Object queryEngineManufacturer(Object enginePk) {
        QFilter qFilter = new QFilter("modelonef7", "=", enginePk);
        qFilter.or("modeltwof7", "=", enginePk);
        qFilter.or("modeltrdf7", "=", enginePk);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"mpdm_enginetype", (String)"manufacturer", (QFilter[])qFilter.toArray(), (String)"manufacturer", (int)1);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return ((DynamicObject)collection.get(0)).get(0);
    }
}

