/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class TaskScheduleDetailHelper {
    private static final Log log = LogFactory.getLog(TaskScheduleDetailHelper.class);
    private static final DynamicObjectType dyType = TaskScheduleDetailHelper.getEntryType();
    private static final ORM orm = ORM.create();
    private static final DBRoute PMC_ROUTE = DBRoute.of((String)"pmc");
    private static final RequestContext ctx = RequestContext.get();

    public static void addStep(PmtsTaskRunTimeInfo rInfo, String msg) {
        long dtlId = TaskScheduleDetailHelper.getDetailid(rInfo);
        int seq = TaskScheduleDetailHelper.getSeq(rInfo);
        String strSql = "INSERT INTO T_PMTS_TASKSCDETAIL_STE (FID,FENTRYID,FSTEP,FSEQ) VALUES (?, ?, ?,?) ";
        Object[] params = new SqlParameter[4];
        long entryId = orm.genLongId((IDataEntityType)dyType);
        params[0] = new SqlParameter(":FID", 12, (Object)dtlId);
        params[1] = new SqlParameter(":FENTRYID", 12, (Object)entryId);
        params[2] = new SqlParameter(":STEP", 12, (Object)msg);
        params[3] = new SqlParameter(":FSEQ", 4, (Object)seq);
        try (TXHandle handle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)PMC_ROUTE, (String)strSql, (Object[])params);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                handle.markRollback();
                throw new KDException(BosErrorCode.sQL, new Object[]{e});
            }
        }
    }

    public static long getDetailid(PmtsTaskRunTimeInfo rInfo) {
        QFilter pjqf = new QFilter("project", "=", (Object)rInfo.getProjectid());
        QFilter clqf = new QFilter("calclog", "=", (Object)rInfo.getCallogid());
        DynamicObject obj = QueryServiceHelper.queryOne((String)"pmts_taskschedule_detail", (String)"id", (QFilter[])new QFilter[]{pjqf, clqf});
        if (Objects.isNull(obj)) {
            return 0L;
        }
        return obj.getLong("id");
    }

    private static DynamicObjectType getEntryType() {
        BasedataEntityType mType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)"pmts_taskschedule_detail");
        BasedataEntityType entryType = new BasedataEntityType();
        for (IDataEntityProperty type : mType.getProperties()) {
            if (!type.getName().equals("entryentity")) continue;
            EntryProp stepProp = (EntryProp)type;
            entryType = stepProp.getDynamicCollectionItemPropertyType();
        }
        return entryType;
    }

    private static int getSeq(PmtsTaskRunTimeInfo rInfo) {
        QFilter pjqf = new QFilter("project", "=", (Object)rInfo.getProjectid());
        QFilter clqf = new QFilter("calclog", "=", (Object)rInfo.getCallogid());
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(pjqf);
        filters.add(clqf);
        String selectfields = "entryentity.id as entryid";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TASK_SCHEDULE_GETSEQ", (String)"pmts_taskschedule_detail", (String)selectfields, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);){
            if (ds.isEmpty()) {
                int n = 0;
                return n;
            }
            int n = ds.count("entryid", true);
            return n;
        }
    }
}

