/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.helper.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkBenchConfigHelper {
    private static final String BOS_FORMMETA = "bos_formmeta";

    public static List<String> getEntityObjs(DynamicObject entityRowObj) {
        ArrayList<String> entityObjs = new ArrayList<String>(2);
        List<String> ENTITY_KEYS = Arrays.asList("upupgroupentity", "upgroupentity", "groupentity", "entity");
        for (String entityKey : ENTITY_KEYS) {
            Optional<DynamicObject> optionalEntity = Optional.ofNullable(entityRowObj.getDynamicObject(entityKey));
            optionalEntity.ifPresent(entity -> {
                String pkValue = (String)entity.getPkValue();
                if (pkValue != null) {
                    entityObjs.add(pkValue);
                }
            });
        }
        return entityObjs;
    }

    public static Map<String, Map<String, String>> getCurEntityRelationMap(DynamicObject entityRowObj) {
        DynamicObjectCollection entityRelations = entityRowObj.getDynamicObjectCollection("entityrelation");
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(4);
        for (DynamicObject entityRow : entityRelations) {
            DynamicObject entity = entityRow.getDynamicObject("rentity");
            if (entity == null) continue;
            Map relationMap = result.computeIfAbsent(entity.getString("number"), t -> new LinkedHashMap(2));
            String rentityFlag = entityRow.getString("rentityflag");
            String rupLevelEntity = entityRow.getDynamicObject("ruplevelentity").getString("number");
            relationMap.put(rupLevelEntity, rentityFlag);
        }
        return result;
    }

    public static DynamicObject getOrigFormId(String formId) {
        QFilter f = new QFilter("number", "=", (Object)formId);
        QFilter[] filters = new QFilter[]{f};
        DynamicObject formData = BusinessDataServiceHelper.loadSingle((String)BOS_FORMMETA, (String)"id, number,name,basedatafield, masterid", (QFilter[])filters);
        return formData;
    }

    public static Map<String, String> getOrigFormId(Set<String> formIds) {
        QFilter f = new QFilter("number", "in", formIds);
        QFilter[] filters = new QFilter[]{f};
        DynamicObjectCollection formDatas = QueryServiceHelper.query((String)BOS_FORMMETA, (String)"id, number,name,basedatafield, masterid", (QFilter[])filters);
        return formDatas.stream().collect(Collectors.toMap(formData -> formData.getString("number"), formData -> formData.getString("id"), (existing, replacement) -> existing, HashMap::new));
    }
}

