/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.day;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmts.business.helper.PmtsProjectCalendarHelper;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.task.taskschedule.model.AbstractPmtsTask;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskPostInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskPreviousInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class PmtsTask
extends AbstractPmtsTask {
    private static final Log log = LogFactory.getLog(PmtsTask.class);

    public PmtsTask(String taskNumber, BigDecimal plantime, PmtsTaskRunTimeInfo ctx) {
        super(taskNumber, plantime, ctx);
    }

    @Override
    public void calEarlyTime() {
        try {
            if (!this.isCalEST) {
                HashMap est = new HashMap();
                HashMap needest = new HashMap();
                Map tempest = new HashMap();
                Map tempneedest = new HashMap();
                boolean isTmp = false;
                if (this.getPreviousTasks().isEmpty()) {
                    this.calFirstEST();
                } else {
                    for (int i = 0; i < this.getPreviousInfoTasks().size(); ++i) {
                        PmtsTaskPreviousInfo previousInfoTask = this.getPreviousInfoTasks().get(i);
                        String logicKey = previousInfoTask.getLogic();
                        List<Object> ls = new ArrayList(8);
                        if (logicKey.equals("1")) {
                            ls = this.calEstByFS(previousInfoTask);
                        } else if (logicKey.equals("2")) {
                            ls = this.calEstByFF(previousInfoTask);
                        } else if (logicKey.equals("3")) {
                            ls = this.calEstBySS(previousInfoTask);
                        } else if (logicKey.equals("4")) {
                            ls = this.calEstBySF(previousInfoTask);
                        }
                        if (ls.isEmpty()) {
                            PmtsTaskHelper.hasError(this.ctx, ResManager.loadKDString((String)"\u8ba1\u7b97\u51fa\u9519", (String)"PmtsTask_0", (String)"mmc-pmts-business", (Object[])new Object[0]));
                        }
                        tempest = (Map)ls.get(0);
                        tempneedest = (Map)ls.get(1);
                        long tempdate = this.getWkDate(tempest);
                        long tempneeddate = this.getWkDate(tempneedest);
                        if (i == 0) {
                            est = tempest;
                            needest = tempneedest;
                        }
                        long estdate = this.getWkDate(est);
                        long needestdate = this.getWkDate(needest);
                        if (tempdate > estdate) {
                            est = tempest;
                        }
                        if (tempneeddate > needestdate) {
                            needest = tempneedest;
                        }
                        isTmp = previousInfoTask.getPrevtask().isCalEFT();
                    }
                    if (isTmp) {
                        this.earlyStartTime = this.getWstDate(est);
                        this.earlyNeedSTime = this.logictype.equals("2") && this.status.equals("2") ? this.getWstDate(this.getUrNextDate(this.getDateMap(this.getProjectdate()), this.calid)) : this.getWstDate(needest);
                        this.isCalEST = true;
                    }
                }
            }
            if (!this.isCalEFT && this.isCalEST) {
                Long xsdate;
                Map todayMap;
                System.out.println(this.getTaskNumber());
                if (this.getDut().compareTo(BigDecimal.ZERO) == 0) {
                    this.earlyFinishTime = this.getEarlyStartTime();
                } else {
                    todayMap = this.getDateMap(this.getEarlyStartTime());
                    todayMap = this.getScNextDate(this.getDut().subtract(BigDecimal.ONE), todayMap, this.calid);
                    if (todayMap.containsKey("xs")) {
                        xsdate = (Long)todayMap.get("xs");
                        this.earlyFinishTime = xsdate + this.getWstDate(todayMap);
                    } else {
                        this.earlyFinishTime = this.getWftDate(todayMap);
                    }
                }
                if (this.getNeeddut().compareTo(BigDecimal.ZERO) == 0) {
                    this.earlyNeedFTime = this.getEarlyNeedSTime();
                } else {
                    todayMap = this.getDateMap(this.getEarlyNeedSTime());
                    todayMap = this.getScNextDate(this.getNeeddut().subtract(BigDecimal.ONE), todayMap, this.calid);
                    if (todayMap.containsKey("xs")) {
                        xsdate = (Long)todayMap.get("xs");
                        this.earlyNeedFTime = xsdate + this.getWstDate(todayMap);
                    } else {
                        this.earlyNeedFTime = this.getWftDate(todayMap);
                    }
                }
                this.isCalEFT = true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.isCalEST = true;
            this.isCalEFT = true;
            throw e;
        }
    }

    private void calFirstEST() {
        Map todayMap = this.getDateMap(this.getProjectdate());
        this.earlyNeedSTime = this.earlyStartTime = Long.parseLong(this.getUrNextDate(todayMap, this.calid).get("workstarttime").toString());
        this.isCalEST = true;
        this.iskk = true;
    }

    private List<Map> calEstBySF(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Map> mapList = new ArrayList<Map>(8);
        PmtsTask previousTask = (PmtsTask)previousInfoTask.getPrevtask();
        Map todayMap = null;
        Map needMap = null;
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            todayMap = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyStartTime());
            todayMap = this.getDateMap(this.getWkDate(todayMap));
            todayMap = this.getTimeAsc(this.getWkDate(todayMap));
            todayMap = this.getUrNextDate(todayMap, this.calid);
            needMap = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedSTime());
            needMap = this.getDateMap(this.getWkDate(needMap));
            needMap = this.getTimeAsc(this.getWkDate(needMap));
            needMap = this.getUrNextDate(needMap, this.calid);
        } else {
            todayMap = this.getDateMap(previousTask.getEarlyStartTime());
            needMap = this.getDateMap(previousTask.getEarlyNeedSTime());
        }
        mapList.add(this.getScPrevDate(this.getDut().subtract(BigDecimal.ONE), todayMap));
        mapList.add(this.getScPrevDate(this.needdut.subtract(BigDecimal.ONE), needMap));
        return mapList;
    }

    private List<Map> calEstBySS(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Map> mapList = new ArrayList<Map>(8);
        PmtsTask previousTask = (PmtsTask)previousInfoTask.getPrevtask();
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            Map tempest = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyStartTime());
            tempest = this.getDateMap(this.getWkDate(tempest));
            tempest = this.getTimeAsc(this.getWkDate(tempest));
            tempest = this.getUrNextDate(tempest, this.calid);
            Map tempneedest = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedSTime());
            tempneedest = this.getDateMap(this.getWkDate(tempneedest));
            tempneedest = this.getTimeAsc(this.getWkDate(tempneedest));
            tempneedest = this.getUrNextDate(tempneedest, this.calid);
            mapList.add(tempest);
            mapList.add(tempneedest);
        } else {
            Map tempest = this.getDateMap(previousTask.getEarlyStartTime());
            Map tempneedest = this.getDateMap(previousTask.getEarlyNeedSTime());
            mapList.add(tempest);
            mapList.add(tempneedest);
        }
        return mapList;
    }

    private List<Map> calEstByFF(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Map> mapList = new ArrayList<Map>(8);
        PmtsTask previousTask = (PmtsTask)previousInfoTask.getPrevtask();
        Map todayMap = null;
        Map needMap = null;
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            todayMap = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyFinishTime());
            todayMap = this.getDateMap(this.getWkDate(todayMap));
            todayMap = this.getUrNextDate(todayMap, this.calid);
            needMap = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedFTime());
            needMap = this.getDateMap(this.getWkDate(needMap));
            needMap = this.getUrNextDate(needMap, this.calid);
        } else {
            todayMap = this.getDateMap(previousTask.getEarlyFinishTime());
            needMap = this.getDateMap(previousTask.getEarlyNeedFTime());
        }
        mapList.add(this.getScPrevDate(this.getDut().subtract(BigDecimal.ONE), todayMap));
        mapList.add(this.getScPrevDate(this.getNeeddut().subtract(BigDecimal.ONE), needMap));
        return mapList;
    }

    private List<Map> calEstByFS(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Map> mapList = new ArrayList<Map>(8);
        PmtsTask previousTask = (PmtsTask)previousInfoTask.getPrevtask();
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            Map todayMap = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyFinishTime());
            todayMap = this.getDateMap(this.getWkDate(todayMap));
            todayMap = this.getTimeAsc(this.getWkDate(todayMap));
            mapList.add(this.getUrNextDate(todayMap, this.calid));
            Map needMap = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedFTime());
            needMap = this.getDateMap(this.getWkDate(needMap));
            needMap = this.getTimeAsc(this.getWkDate(needMap));
            mapList.add(this.getUrNextDate(needMap, this.calid));
        } else {
            mapList.add(this.getTimeAsc(this.getWkDate(this.getDateMap(previousTask.getEarlyFinishTime()))));
            mapList.add(this.getTimeAsc(this.getWkDate(this.getDateMap(previousTask.getEarlyNeedFTime()))));
        }
        return mapList;
    }

    @Override
    public void calculateLT() {
        if (!this.isCalLST()) {
            this.calLaterTime(this.getPostTaskInfos(), this);
        }
        if (!this.isCalLFT()) {
            this.calLaterTime(this.getPostTaskInfos(), this);
        }
    }

    @Override
    public void calLaterTime(List<PmtsTaskPostInfo> postTasks, AbstractPmtsTask abstask) {
        PmtsTask task = (PmtsTask)abstask;
        try {
            Map lft = null;
            Map needlft = null;
            Map templft = null;
            Map tempneedlft = null;
            boolean isTmp = false;
            if (this.nextTasks.isEmpty()) {
                if (task.isCalEST() && task.isCalEFT()) {
                    if (task.isusehopetime) {
                        Map pjdateMap = this.getDateMap(task.getProjectenddate(), task.getCalid());
                        task.lateFinishTime = this.getWftDate(pjdateMap);
                        task.lateNeedFTime = this.getWftDate(pjdateMap);
                        Map startMap = this.getScPrevDate(task.getDut().subtract(BigDecimal.ONE), pjdateMap, task.getCalid());
                        Map needStartMap = this.getScPrevDate(task.getNeeddut().subtract(BigDecimal.ONE), pjdateMap, task.getCalid());
                        task.lateStartTime = this.getWstDate(startMap);
                        task.lateNeedSTime = this.getWstDate(needStartMap);
                    } else if (task.getCrossgroup().equals("2")) {
                        Map startMap = this.getDateMap(task.lateFinishTime, task.getCalid());
                        Map needstartMap = this.getDateMap(task.lateNeedFTime, task.getCalid());
                        startMap = this.getScPrevDate(task.getDut().subtract(BigDecimal.ONE), startMap, task.getCalid());
                        needstartMap = this.getScPrevDate(task.getNeeddut().subtract(BigDecimal.ONE), needstartMap, task.getCalid());
                        task.lateStartTime = this.getWstDate(startMap);
                        task.lateNeedSTime = this.getWstDate(needstartMap);
                    } else {
                        task.lateFinishTime = task.getEarlyFinishTime();
                        task.lateNeedFTime = task.getEarlyNeedFTime();
                        task.lateStartTime = task.getEarlyStartTime();
                        task.lateNeedSTime = task.getEarlyNeedSTime();
                    }
                    task.isCalLFT = true;
                    task.isCalLST = true;
                    task.iskk = false;
                }
            } else {
                for (int i = 0; i < this.nextTasks.size(); ++i) {
                    Map needMap;
                    PmtsTaskPostInfo postInfo = postTasks.get(i);
                    PmtsTask nextTask = (PmtsTask)postInfo.getPosttask();
                    if (!nextTask.isCalLFT()) {
                        return;
                    }
                    if (!nextTask.isCalLST()) {
                        return;
                    }
                    if ("1".equals(postInfo.getLogic())) {
                        Map todayMap = null;
                        needMap = null;
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            todayMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateStartTime());
                            todayMap = this.getDateMap(this.getWkDate(todayMap));
                            todayMap = this.getTimeDesc(this.getWkDate(todayMap));
                            todayMap = this.getUrPrevDate(todayMap, task.getCalid());
                            needMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedSTime());
                            needMap = this.getDateMap(this.getWkDate(needMap));
                            needMap = this.getTimeDesc(this.getWkDate(needMap));
                            needMap = this.getUrPrevDate(needMap, task.getCalid());
                            templft = todayMap;
                            tempneedlft = needMap;
                        } else {
                            todayMap = this.getDateMap(nextTask.getLateStartTime());
                            needMap = this.getDateMap(nextTask.getLateNeedSTime());
                            templft = this.getTimeDesc(this.getWkDate(todayMap));
                            tempneedlft = this.getTimeDesc(this.getWkDate(needMap));
                        }
                    } else if ("2".equals(postInfo.getLogic())) {
                        Map todayMap = null;
                        needMap = null;
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            todayMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateFinishTime());
                            todayMap = this.getDateMap(this.getWkDate(todayMap));
                            todayMap = this.getUrPrevDate(todayMap, task.getCalid());
                            needMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedFTime());
                            needMap = this.getDateMap(this.getWkDate(needMap));
                            needMap = this.getUrPrevDate(needMap, task.getCalid());
                        } else {
                            todayMap = this.getDateMap(nextTask.getLateFinishTime());
                            needMap = this.getDateMap(nextTask.getLateNeedFTime());
                        }
                        templft = todayMap;
                        tempneedlft = needMap;
                    } else if ("3".equals(postInfo.getLogic())) {
                        Map todayMap = null;
                        needMap = null;
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            todayMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateStartTime());
                            todayMap = this.getDateMap(this.getWkDate(todayMap));
                            todayMap = this.getTimeDesc(this.getWkDate(todayMap));
                            todayMap = this.getUrPrevDate(todayMap, task.getCalid());
                            needMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedSTime());
                            needMap = this.getDateMap(this.getWkDate(needMap));
                            needMap = this.getTimeDesc(this.getWkDate(needMap));
                            needMap = this.getUrPrevDate(needMap, task.getCalid());
                        } else {
                            todayMap = this.getDateMap(nextTask.getLateStartTime());
                            needMap = this.getDateMap(nextTask.getLateNeedSTime());
                        }
                        templft = this.getScNextDate(task.getDut().subtract(BigDecimal.ONE), todayMap, task.getCalid());
                        tempneedlft = this.getScNextDate(task.getNeeddut().subtract(BigDecimal.ONE), needMap, task.getCalid());
                    } else if ("4".equals(postInfo.getLogic())) {
                        Map todayMap = null;
                        needMap = null;
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            todayMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateFinishTime());
                            todayMap = this.getDateMap(this.getWkDate(todayMap));
                            todayMap = this.getTimeDesc(this.getWkDate(todayMap));
                            todayMap = this.getUrPrevDate(todayMap, task.getCalid());
                            needMap = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedFTime());
                            needMap = this.getDateMap(this.getWkDate(needMap));
                            needMap = this.getTimeDesc(this.getWkDate(needMap));
                            needMap = this.getUrPrevDate(needMap, task.getCalid());
                        } else {
                            todayMap = this.getDateMap(nextTask.getLateFinishTime());
                            needMap = this.getDateMap(nextTask.getLateNeedFTime());
                        }
                        todayMap = this.getScNextDate(task.getDut().subtract(BigDecimal.ONE), todayMap, task.getCalid());
                        needMap = this.getScNextDate(task.getNeeddut().subtract(BigDecimal.ONE), needMap, task.getCalid());
                        templft = this.getTimeDesc(this.getWkDate(todayMap));
                        tempneedlft = this.getTimeDesc(this.getWkDate(needMap));
                    }
                    if (i == 0) {
                        lft = templft;
                        needlft = tempneedlft;
                    }
                    long tempdate = this.getWkDate(templft);
                    long tempneeddate = this.getWkDate(tempneedlft);
                    long lftdate = this.getWkDate(lft);
                    long needlftdate = this.getWkDate(needlft);
                    if (tempdate < lftdate) {
                        lft = templft;
                    }
                    if (tempneeddate < needlftdate) {
                        needlft = tempneedlft;
                    }
                    isTmp = nextTask.isCalLFT();
                }
                if (isTmp && task.isCalEST() && task.isCalEFT()) {
                    Long xsdate;
                    if (task.getDut().compareTo(BigDecimal.ZERO) == 0) {
                        task.lateStartTime = task.lateFinishTime = this.getWstDate(lft);
                    } else {
                        task.lateFinishTime = this.getWftDate(lft);
                        Map todayMap = this.getScPrevDate(task.getDut().subtract(BigDecimal.ONE), lft, task.getCalid());
                        if (todayMap.containsKey("xs")) {
                            xsdate = (Long)todayMap.get("xs");
                            task.lateStartTime = this.getWftDate(todayMap) - xsdate;
                        } else {
                            task.lateStartTime = this.getWstDate(todayMap);
                        }
                    }
                    if (task.getNeeddut().compareTo(BigDecimal.ZERO) == 0) {
                        task.lateNeedSTime = task.lateNeedFTime = this.getWstDate(needlft);
                    } else {
                        task.lateNeedFTime = this.getWftDate(needlft);
                        Map needMap = this.getScPrevDate(task.getNeeddut().subtract(BigDecimal.ONE), needlft, task.getCalid());
                        if (needMap.containsKey("xs")) {
                            xsdate = (Long)needMap.get("xs");
                            task.lateNeedSTime = this.getWftDate(needMap) - xsdate;
                        } else {
                            task.lateNeedSTime = this.getWstDate(needMap);
                        }
                    }
                    task.isCalLST = true;
                    task.isCalLFT = true;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            task.isCalLST = true;
            task.isCalLFT = true;
            throw e;
        }
    }

    private Map getTimeAsc(long finishTime) {
        Map todayMap = this.getDateMap(finishTime);
        todayMap = this.getScNextDate(BigDecimal.ONE, todayMap, this.calid);
        return todayMap;
    }

    private Map getTimeDesc(long finishTime) {
        Map todayMap = this.getDateMap(finishTime);
        todayMap = this.getScPrevDate(BigDecimal.ONE, todayMap);
        return todayMap;
    }

    private Map calculateDelayDesc(PmtsTaskPostInfo postInfo, PmtsTask task, long time) {
        Map<String, String> stratMap = new HashMap();
        stratMap.putAll(this.getDateMap(time, postInfo.getPosttask().getCalid()));
        if (postInfo.getDelaytype().equals("1")) {
            stratMap = this.getUrPrevDate(stratMap, task.getCalid());
            stratMap = this.getScPrevDate(postInfo.getDelayTime(), stratMap, task.getCalid());
        } else if (postInfo.getDelaytype().equals("2")) {
            stratMap = this.getScPrevDate(postInfo.getDelayTime(), stratMap, postInfo.getPosttask().getCalid());
        } else if (postInfo.getDelaytype().equals("3")) {
            Calendar c = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long delaytime = (long)(postInfo.getDelayTime().doubleValue() * 8.64E7);
            long newsttime = Long.parseLong(stratMap.get("workstarttime").toString()) - delaytime;
            long newwktime = Long.parseLong(stratMap.get("workdate").toString()) - delaytime;
            long newfttime = Long.parseLong(stratMap.get("workfinshtime").toString()) - delaytime;
            c.setTimeInMillis(newwktime);
            String newwkdate = sdf.format(c.getTime());
            stratMap.put("workstarttime", String.valueOf(newsttime));
            stratMap.put("workdate", String.valueOf(newwktime));
            stratMap.put("workdate1", newwkdate);
            stratMap.put("workfinshtime", String.valueOf(newfttime));
        } else if (postInfo.getDelaytype().equals("4")) {
            stratMap = this.getUrPrevDate(stratMap, task.getProjectcalenid());
            stratMap = this.getScPrevDate(postInfo.getDelayTime(), stratMap, task.getProjectcalenid());
        }
        return stratMap;
    }

    private Map calculateDelayAsc(PmtsTaskPreviousInfo previousInfoTask, long time) {
        HashMap finishMap = new HashMap();
        finishMap.putAll(this.getDateMap(time, previousInfoTask.getPrevtask().getCalid()));
        Map resultMap = new HashMap();
        switch (previousInfoTask.getDelaytype()) {
            case "1": {
                resultMap = this.calDateByPCalendar(previousInfoTask, finishMap);
                break;
            }
            case "2": {
                resultMap = this.calDateByNCalendar(previousInfoTask, finishMap);
                break;
            }
            case "3": {
                resultMap = this.calDateBy24Calendar(previousInfoTask, finishMap);
                break;
            }
            case "4": {
                resultMap = this.calDateByPJCalendar(previousInfoTask, finishMap);
                break;
            }
        }
        return resultMap;
    }

    private Map calDateByPJCalendar(PmtsTaskPreviousInfo previousInfoTask, Map finishMap) {
        finishMap = this.getUrNextDate(finishMap, this.getProjectcalenid());
        return this.getScNextDate(previousInfoTask.getDelayTime(), finishMap, this.getProjectcalenid());
    }

    private Map calDateBy24Calendar(PmtsTaskPreviousInfo previousInfoTask, Map finishMap) {
        Calendar c = Calendar.getInstance();
        HashMap<String, String> rsMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long delaytime = (long)(previousInfoTask.getDelayTime().doubleValue() * 8.64E7);
        long newsttime = Long.parseLong(finishMap.get("workstarttime").toString()) + delaytime;
        long newwktime = Long.parseLong(finishMap.get("workdate").toString()) + delaytime;
        long newfttime = Long.parseLong(finishMap.get("workfinshtime").toString()) + delaytime;
        c.setTimeInMillis(newwktime);
        String newwkdate = sdf.format(c.getTime());
        rsMap.put("workstarttime", String.valueOf(newsttime));
        rsMap.put("workdate", String.valueOf(newwktime));
        rsMap.put("workdate1", newwkdate);
        rsMap.put("workfinshtime", String.valueOf(newfttime));
        return rsMap;
    }

    private Map calDateByNCalendar(PmtsTaskPreviousInfo previousInfoTask, Map finishMap) {
        finishMap = this.getUrNextDate(finishMap, this.calid);
        return this.getScNextDate(previousInfoTask.getDelayTime(), finishMap, this.calid);
    }

    private Map calDateByPCalendar(PmtsTaskPreviousInfo previousInfoTask, Map finishMap) {
        return this.getScNextDate(previousInfoTask.getDelayTime(), finishMap, previousInfoTask.getPrevtask().getCalid());
    }

    private Map getDateMap(long datetime, long cId) {
        return PmtsProjectCalendarHelper.getCurrDateMap(datetime, cId, this.ctx);
    }

    private Map getDateMap(long datetime) {
        return this.getDateMap(datetime, this.calid);
    }

    private Map getScNextDate(BigDecimal totalcost, Map curMap, long cId) {
        return PmtsProjectCalendarHelper.getScheduleNextDate(totalcost, curMap, cId, this.ctx);
    }

    private Map getScPrevDate(BigDecimal totalcost, Map curMap) {
        return this.getScPrevDate(totalcost, curMap, this.calid);
    }

    private Map getScPrevDate(BigDecimal totalcost, Map curMap, long cId) {
        return PmtsProjectCalendarHelper.getSchedulePrevDate(totalcost, curMap, cId, this.ctx);
    }

    private Map getUrNextDate(Map curMap, long cId) {
        return PmtsProjectCalendarHelper.getUnRestNextDate(curMap, cId, this.ctx);
    }

    private Map getUrPrevDate(Map curMap, long cId) {
        return PmtsProjectCalendarHelper.getUnRestPrevDate(curMap, cId, this.ctx);
    }

    private long getWstDate(Map curMap) {
        return PmtsProjectCalendarHelper.getWorkStartDate(curMap);
    }

    private long getWftDate(Map curMap) {
        return PmtsProjectCalendarHelper.getWorkFinshDate(curMap);
    }

    private long getWkDate(Map curMap) {
        return PmtsProjectCalendarHelper.getWorkDate(curMap);
    }

    @Override
    public boolean isFreeTask(DynamicObject pmtstask) {
        if (this.getPreviousTasks().isEmpty() && this.getNextTasks().isEmpty()) {
            Map estartMap = PmtsProjectCalendarHelper.getCurrDateMap(this.getProjectdate(), this.getCalid(), this.ctx);
            estartMap = PmtsProjectCalendarHelper.getUnRestNextDate(estartMap, this.getCalid(), this.ctx);
            Calendar pesc = Calendar.getInstance();
            pesc.setTimeInMillis(PmtsProjectCalendarHelper.getWorkStartDate(estartMap));
            Calendar peec = Calendar.getInstance();
            if (this.getDut().compareTo(BigDecimal.ZERO) == 0) {
                peec = pesc;
            } else {
                Map eendMap = PmtsProjectCalendarHelper.getScheduleNextDate(this.getDut().subtract(BigDecimal.ONE), estartMap, this.getCalid(), this.ctx);
                if (eendMap.containsKey("xs")) {
                    Long xsdate = (Long)eendMap.get("xs");
                    peec.setTimeInMillis(xsdate + PmtsProjectCalendarHelper.getWorkStartDate(eendMap));
                } else {
                    peec.setTimeInMillis(PmtsProjectCalendarHelper.getWorkFinshDate(eendMap));
                }
            }
            Calendar npeec = Calendar.getInstance();
            if (this.getDut().compareTo(BigDecimal.ZERO) == 0) {
                npeec = pesc;
            } else {
                Map neendMap = PmtsProjectCalendarHelper.getScheduleNextDate(this.getNeeddut().subtract(BigDecimal.ONE), estartMap, this.getCalid(), this.ctx);
                if (neendMap.containsKey("xs")) {
                    Long xsdate = (Long)neendMap.get("xs");
                    npeec.setTimeInMillis(xsdate + PmtsProjectCalendarHelper.getWorkStartDate(neendMap));
                } else {
                    npeec.setTimeInMillis(PmtsProjectCalendarHelper.getWorkFinshDate(neendMap));
                }
            }
            Map lendMap = PmtsProjectCalendarHelper.getCurrDateMap(this.getProjectenddate(), this.getCalid(), this.ctx);
            lendMap = PmtsProjectCalendarHelper.getUnRestPrevDate(lendMap, this.getCalid(), this.ctx);
            Calendar plec = Calendar.getInstance();
            plec.setTimeInMillis(PmtsProjectCalendarHelper.getWorkFinshDate(lendMap));
            Calendar plsc = Calendar.getInstance();
            if (this.getDut().compareTo(BigDecimal.ZERO) == 0) {
                plsc = plec;
            } else {
                Map lstartMap = PmtsProjectCalendarHelper.getSchedulePrevDate(this.getDut().subtract(BigDecimal.ONE), lendMap, this.getCalid(), this.ctx);
                if (lstartMap.containsKey("xs")) {
                    Long xsdate = (Long)lstartMap.get("xs");
                    plsc.setTimeInMillis(PmtsProjectCalendarHelper.getWorkFinshDate(lstartMap) - xsdate);
                } else {
                    plsc.setTimeInMillis(PmtsProjectCalendarHelper.getWorkStartDate(lstartMap));
                }
            }
            Calendar nplsc = Calendar.getInstance();
            if (this.getNeeddut().compareTo(BigDecimal.ZERO) == 0) {
                nplsc = plec;
            } else {
                Map nlstartMap = PmtsProjectCalendarHelper.getSchedulePrevDate(this.getNeeddut().subtract(BigDecimal.ONE), lendMap, this.getCalid(), this.ctx);
                if (nlstartMap.containsKey("xs")) {
                    Long xsdate = (Long)nlstartMap.get("xs");
                    nplsc.setTimeInMillis(PmtsProjectCalendarHelper.getWorkFinshDate(nlstartMap) - xsdate);
                } else {
                    nplsc.setTimeInMillis(PmtsProjectCalendarHelper.getWorkStartDate(nlstartMap));
                }
            }
            this.earlyStartTime = pesc.getTimeInMillis();
            this.earlyFinishTime = peec.getTimeInMillis();
            this.lateStartTime = plsc.getTimeInMillis();
            this.lateFinishTime = plec.getTimeInMillis();
            this.earlyNeedSTime = pesc.getTimeInMillis();
            this.earlyNeedFTime = npeec.getTimeInMillis();
            this.lateNeedSTime = nplsc.getTimeInMillis();
            this.lateNeedFTime = plec.getTimeInMillis();
            pmtstask.set("firststartdate", (Object)pesc.getTime());
            pmtstask.set("firstenddate", (Object)peec.getTime());
            pmtstask.set("laststartdate", (Object)plsc.getTime());
            pmtstask.set("lastenddate", (Object)plec.getTime());
            pmtstask.set("nfirststartdate", (Object)pesc.getTime());
            pmtstask.set("nfirstenddate", (Object)npeec.getTime());
            pmtstask.set("nlaststartdate", (Object)nplsc.getTime());
            pmtstask.set("nlastenddate", (Object)plec.getTime());
            return true;
        }
        return false;
    }

    @Override
    public void convertTL() {
        if (!this.iscaldut) {
            DynamicObject unitobj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.tlunitid, (String)"pmpd_timeunit");
            String number = unitobj.getString("number");
            if (StringUtils.equals((CharSequence)number, (CharSequence)"40")) {
                this.dut = this.dut.divide(new BigDecimal(24), 2, RoundingMode.HALF_UP);
                this.needdut = this.needdut.divide(new BigDecimal(24), 2, RoundingMode.HALF_UP);
            }
            this.iscaldut = true;
        }
    }
}

