/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.hour;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmc.pmts.business.helper.PmtsProjectCalendarNewHelper;
import kd.pmc.pmts.business.task.taskschedule.model.AbstractPmtsTask;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskPostInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskPreviousInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class PmtsNewTask
extends AbstractPmtsTask {
    private static final Log log = LogFactory.getLog(PmtsNewTask.class);
    private long rate = 0L;
    private long ONEDAYMS = 0L;

    public PmtsNewTask(String taskNumber, BigDecimal plantime, PmtsTaskRunTimeInfo ctx) {
        super(taskNumber, plantime, ctx);
    }

    @Override
    public void calEarlyTime() {
        super.calEarlyTime();
        try {
            if (!this.isCalEST) {
                long est = 0L;
                long needest = 0L;
                long tempest = 0L;
                long tempneedest = 0L;
                boolean isTmp = false;
                if (this.getPreviousTasks().isEmpty()) {
                    this.calFirstEST();
                } else {
                    for (int i = 0; i < this.getPreviousInfoTasks().size(); ++i) {
                        PmtsTaskPreviousInfo previousInfoTask = this.getPreviousInfoTasks().get(i);
                        String logicKey = previousInfoTask.getLogic();
                        List<Object> ls = new ArrayList(8);
                        if (logicKey.equals("1")) {
                            ls = this.calEstByFS(previousInfoTask);
                        } else if (logicKey.equals("2")) {
                            ls = this.calEstByFF(previousInfoTask);
                        } else if (logicKey.equals("3")) {
                            ls = this.calEstBySS(previousInfoTask);
                        } else if (logicKey.equals("4")) {
                            ls = this.calEstBySF(previousInfoTask);
                        }
                        if (ls.isEmpty()) {
                            this.hasError(ResManager.loadKDString((String)"\u8ba1\u7b97\u51fa\u9519", (String)"PmtsNewTask_0", (String)"mmc-pmts-business", (Object[])new Object[0]));
                        }
                        tempest = (Long)ls.get(0);
                        tempneedest = (Long)ls.get(1);
                        if (i == 0) {
                            est = tempest;
                            needest = tempneedest;
                        }
                        if (tempest > est) {
                            est = tempest;
                        }
                        if (tempneedest > needest) {
                            needest = tempneedest;
                        }
                        isTmp = previousInfoTask.getPrevtask().isCalEFT();
                    }
                    if (isTmp) {
                        this.earlyStartTime = est;
                        this.earlyNeedSTime = this.logictype.equals("2") && this.status.equals("2") ? this.getUrNextDate(this.getProjectdate(), this.calid) : needest;
                        this.isCalEST = true;
                    }
                }
            }
            if (!this.isCalEFT && this.isCalEST) {
                if (this.dut.compareTo(BigDecimal.ZERO) == 0) {
                    this.earlyFinishTime = this.getEarlyStartTime();
                } else {
                    long today = this.getEarlyStartTime();
                    this.earlyFinishTime = today = this.getScNextDate(this.dut, today, this.calid).longValue();
                }
                if (this.needdut.compareTo(BigDecimal.ZERO) == 0) {
                    this.earlyNeedFTime = this.getEarlyNeedSTime();
                } else {
                    long need = this.getEarlyNeedSTime();
                    this.earlyNeedFTime = need = this.getScNextDate(this.needdut, need, this.calid).longValue();
                }
                this.isCalEFT = true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.isCalEST = true;
            this.isCalEFT = true;
            throw e;
        }
    }

    private void calFirstEST() {
        this.earlyNeedSTime = this.earlyStartTime = this.getUrNextDate(this.getProjectdate(), this.calid).longValue();
        this.isCalEST = true;
        this.iskk = true;
    }

    private List<Long> calEstBySF(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Long> mapList = new ArrayList<Long>(8);
        PmtsNewTask previousTask = (PmtsNewTask)previousInfoTask.getPrevtask();
        long today = 0L;
        long need = 0L;
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            today = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyStartTime());
            need = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedSTime());
        } else {
            today = previousTask.getEarlyStartTime();
            need = previousTask.getEarlyNeedSTime();
        }
        mapList.add(this.getScPrevDate(this.dut, today));
        mapList.add(this.getScPrevDate(this.needdut, need));
        return mapList;
    }

    private List<Long> calEstBySS(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Long> mapList = new ArrayList<Long>(8);
        PmtsNewTask previousTask = (PmtsNewTask)previousInfoTask.getPrevtask();
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            long tempest = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyStartTime());
            long tempneedest = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedSTime());
            mapList.add(tempest);
            mapList.add(tempneedest);
        } else {
            long tempest = previousTask.getEarlyStartTime();
            long tempneedest = previousTask.getEarlyNeedSTime();
            mapList.add(tempest);
            mapList.add(tempneedest);
        }
        return mapList;
    }

    private List<Long> calEstByFF(PmtsTaskPreviousInfo previousInfoTask) {
        ArrayList<Long> mapList = new ArrayList<Long>(8);
        PmtsNewTask previousTask = (PmtsNewTask)previousInfoTask.getPrevtask();
        long today = 0L;
        long need = 0L;
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            today = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyFinishTime());
            need = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedFTime());
        } else {
            today = previousTask.getEarlyFinishTime();
            need = previousTask.getEarlyNeedFTime();
        }
        mapList.add(this.getScPrevDate(this.dut, today));
        mapList.add(this.getScPrevDate(this.needdut, need));
        return mapList;
    }

    private List<Long> calEstByFS(PmtsTaskPreviousInfo previousInfoTask) {
        PmtsNewTask previousTask = (PmtsNewTask)previousInfoTask.getPrevtask();
        long pcalid = previousTask.getCalid();
        ArrayList<Long> mapList = new ArrayList<Long>(8);
        if (previousInfoTask.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
            long est = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyFinishTime());
            mapList.add(est);
            long nest = this.calculateDelayAsc(previousInfoTask, previousTask.getEarlyNeedFTime());
            mapList.add(nest);
        } else {
            long peft = this.getUrNextDate(previousTask.getEarlyFinishTime(), pcalid);
            long pneft = this.getUrNextDate(previousTask.getEarlyNeedFTime(), pcalid);
            mapList.add(peft);
            mapList.add(pneft);
        }
        return mapList;
    }

    @Override
    public void calculateLT() {
        if (!this.isCalLST()) {
            this.calLaterTime(this.getPostTaskInfos(), this);
        }
        if (!this.isCalLFT()) {
            this.calLaterTime(this.getPostTaskInfos(), this);
        }
    }

    @Override
    public void calLaterTime(List<PmtsTaskPostInfo> postTasks, AbstractPmtsTask abstask) {
        PmtsNewTask task = (PmtsNewTask)abstask;
        try {
            long lft = 0L;
            long needlft = 0L;
            long templft = 0L;
            long tempneedlft = 0L;
            boolean isTmp = false;
            if (this.nextTasks.isEmpty()) {
                if (task.isCalEST() && task.isCalEFT()) {
                    if (task.isusehopetime) {
                        long pjdate;
                        task.lateFinishTime = pjdate = this.getUrPrevDate(task.getProjectenddate(), task.getCalid()).longValue();
                        task.lateNeedFTime = pjdate;
                        long start = this.getScPrevDate(task.dut, pjdate, task.getCalid());
                        long needStart = this.getScPrevDate(task.needdut, pjdate, task.getCalid());
                        task.lateStartTime = start;
                        task.lateNeedSTime = needStart;
                    } else if (task.getCrossgroup().equals("2")) {
                        long start = task.lateFinishTime;
                        long needstart = task.lateNeedFTime;
                        start = this.getScPrevDate(task.dut, start, task.getCalid());
                        needstart = this.getScPrevDate(task.needdut, needstart, task.getCalid());
                        task.lateStartTime = start;
                        task.lateNeedSTime = needstart;
                    } else {
                        task.lateFinishTime = task.getEarlyFinishTime();
                        task.lateNeedFTime = task.getEarlyNeedFTime();
                        task.lateStartTime = task.getEarlyStartTime();
                        task.lateNeedSTime = task.getEarlyNeedSTime();
                    }
                    task.isCalLFT = true;
                    task.isCalLST = true;
                    task.iskk = false;
                }
            } else {
                for (int i = 0; i < this.nextTasks.size(); ++i) {
                    PmtsTaskPostInfo postInfo = postTasks.get(i);
                    PmtsNewTask nextTask = (PmtsNewTask)postInfo.getPosttask();
                    if (!nextTask.isCalLFT()) {
                        return;
                    }
                    if (!nextTask.isCalLST()) {
                        return;
                    }
                    long today = 0L;
                    long need = 0L;
                    if ("1".equals(postInfo.getLogic())) {
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            today = this.calculateDelayDesc(postInfo, task, nextTask.getLateStartTime());
                            need = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedSTime());
                            templft = today;
                            tempneedlft = need;
                        } else {
                            today = this.getUrPrevDate(nextTask.getLateStartTime(), task.getCalid());
                            need = this.getUrPrevDate(nextTask.getLateNeedSTime(), task.getCalid());
                            templft = today;
                            tempneedlft = need;
                        }
                    } else if ("2".equals(postInfo.getLogic())) {
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            today = this.calculateDelayDesc(postInfo, task, nextTask.getLateFinishTime());
                            need = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedFTime());
                        } else {
                            today = this.getUrPrevDate(nextTask.getLateFinishTime(), task.getCalid());
                            need = this.getUrPrevDate(nextTask.getLateNeedFTime(), task.getCalid());
                        }
                        templft = today;
                        tempneedlft = need;
                    } else if ("3".equals(postInfo.getLogic())) {
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            today = this.calculateDelayDesc(postInfo, task, nextTask.getLateStartTime());
                            need = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedSTime());
                        } else {
                            today = this.getUrPrevDate(nextTask.getLateStartTime(), task.getCalid());
                            need = this.getUrPrevDate(nextTask.getLateNeedSTime(), task.getCalid());
                        }
                        templft = this.getScNextDate(task.dut, today, task.getCalid());
                        tempneedlft = this.getScNextDate(task.needdut, need, task.getCalid());
                    } else if ("4".equals(postInfo.getLogic())) {
                        if (postInfo.getDelayTime().compareTo(BigDecimal.ZERO) != 0) {
                            today = this.calculateDelayDesc(postInfo, task, nextTask.getLateFinishTime());
                            need = this.calculateDelayDesc(postInfo, task, nextTask.getLateNeedFTime());
                        } else {
                            today = this.getUrPrevDate(nextTask.getLateFinishTime(), task.getCalid());
                            need = this.getUrPrevDate(nextTask.getLateNeedFTime(), task.getCalid());
                        }
                        today = this.getScNextDate(task.dut, today, task.getCalid());
                        need = this.getScNextDate(task.needdut, need, task.getCalid());
                        templft = today;
                        tempneedlft = need;
                    }
                    if (i == 0) {
                        lft = templft;
                        needlft = tempneedlft;
                    }
                    if (templft < lft) {
                        lft = templft;
                    }
                    if (tempneedlft < needlft) {
                        needlft = tempneedlft;
                    }
                    isTmp = nextTask.isCalLFT();
                }
                if (isTmp && task.isCalEST() && task.isCalEFT()) {
                    if (task.dut.compareTo(BigDecimal.ZERO) == 0) {
                        task.lateStartTime = task.lateFinishTime = lft;
                    } else {
                        long wst;
                        task.lateFinishTime = lft;
                        task.lateStartTime = wst = this.getScPrevDate(task.dut, lft, task.getCalid());
                    }
                    if (task.needdut.compareTo(BigDecimal.ZERO) == 0) {
                        task.lateNeedSTime = task.lateNeedFTime = needlft;
                    } else {
                        long nwst;
                        task.lateNeedFTime = needlft;
                        task.lateNeedSTime = nwst = this.getScPrevDate(task.needdut, needlft, task.getCalid());
                    }
                    task.isCalLST = true;
                    task.isCalLFT = true;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            task.isCalLST = true;
            task.isCalLFT = true;
            throw e;
        }
    }

    private Long calculateDelayDesc(PmtsTaskPostInfo postInfo, PmtsNewTask task, long time) {
        long lft = time;
        BigDecimal delaytime = postInfo.getDelayTime().multiply(new BigDecimal(8)).multiply(new BigDecimal(3600000));
        if (postInfo.getDelaytype().equals("1")) {
            lft = this.getScPrevDate(delaytime, lft, task.getCalid());
        } else if (postInfo.getDelaytype().equals("2")) {
            lft = this.getScPrevDate(delaytime, lft, postInfo.getPosttask().getCalid());
        } else if (postInfo.getDelaytype().equals("3")) {
            lft = time - delaytime.longValue();
        } else if (postInfo.getDelaytype().equals("4")) {
            lft = this.getScPrevDate(delaytime, lft, task.getProjectcalenid());
        }
        return this.getUrPrevDate(lft, task.getCalid());
    }

    private Long calculateDelayAsc(PmtsTaskPreviousInfo previousInfoTask, long time) {
        long est = 0L;
        switch (previousInfoTask.getDelaytype()) {
            case "1": {
                est = this.calDateByPCalendar(previousInfoTask, time);
                break;
            }
            case "2": {
                est = this.calDateByNCalendar(previousInfoTask, time);
                break;
            }
            case "3": {
                est = this.calDateBy24Calendar(previousInfoTask, time);
                break;
            }
            case "4": {
                est = this.calDateByPJCalendar(previousInfoTask, time);
                break;
            }
        }
        return this.getUrNextDate(est, this.calid);
    }

    private long calDateByPJCalendar(PmtsTaskPreviousInfo previousInfoTask, Long time) {
        time = this.getUrNextDate(time, this.getProjectcalenid());
        BigDecimal delaytime = previousInfoTask.getDelayTime().multiply(new BigDecimal(this.rate)).multiply(new BigDecimal(3600000));
        time = this.getScNextDate(delaytime, time, this.getProjectcalenid());
        return time;
    }

    private long calDateBy24Calendar(PmtsTaskPreviousInfo previousInfoTask, long time) {
        BigDecimal delaytime = previousInfoTask.getDelayTime().multiply(new BigDecimal(this.rate)).multiply(new BigDecimal(3600000));
        return time += delaytime.longValue();
    }

    private long calDateByNCalendar(PmtsTaskPreviousInfo previousInfoTask, Long time) {
        BigDecimal delaytime = previousInfoTask.getDelayTime().multiply(new BigDecimal(this.rate)).multiply(new BigDecimal(3600000));
        time = this.getScNextDate(delaytime, time, this.calid);
        return time;
    }

    private long calDateByPCalendar(PmtsTaskPreviousInfo previousInfoTask, Long time) {
        BigDecimal delaytime = previousInfoTask.getDelayTime().multiply(new BigDecimal(this.rate)).multiply(new BigDecimal(3600000));
        time = this.getScNextDate(delaytime, time, previousInfoTask.getPrevtask().getCalid());
        return time;
    }

    private Long getScNextDate(BigDecimal totalcost, long time, long cId) {
        return PmtsProjectCalendarNewHelper.getScheduleNextDate(totalcost, time, cId, this.ctx);
    }

    private long getScPrevDate(BigDecimal totalcost, long today, long cal) {
        return PmtsProjectCalendarNewHelper.getSchedulePrevDate(totalcost, today, cal, this.ctx);
    }

    private long getScPrevDate(BigDecimal cost, long today) {
        return PmtsProjectCalendarNewHelper.getSchedulePrevDate(cost, today, this.calid, this.ctx);
    }

    private Long getUrPrevDate(long date, long cId) {
        return PmtsProjectCalendarNewHelper.getSchedulePrevDate(BigDecimal.ONE, date, cId, this.ctx);
    }

    private Long getUrNextDate(long date, long cId) {
        return PmtsProjectCalendarNewHelper.getScheduleNextDate(BigDecimal.ONE, date, cId, this.ctx);
    }

    @Override
    public void convertTL() {
        if (!this.iscaldut) {
            DynamicObject unitobj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.tlunitid, (String)"pmpd_timeunit");
            if (Objects.nonNull(unitobj)) {
                String number = unitobj.getString("number");
                if (StringUtils.equals((CharSequence)number, (CharSequence)"30")) {
                    this.dut = this.dut.multiply(new BigDecimal(24)).multiply(new BigDecimal(3600000));
                    this.needdut = this.needdut.multiply(new BigDecimal(24)).multiply(new BigDecimal(3600000));
                }
            } else {
                this.dut = this.dut.multiply(new BigDecimal(24)).multiply(new BigDecimal(3600000));
                this.needdut = this.needdut.multiply(new BigDecimal(24)).multiply(new BigDecimal(3600000));
            }
            this.iscaldut = true;
            this.rate = this.getStandardHours();
        }
    }

    @Override
    public boolean isFreeTask(DynamicObject pmtstask) {
        if (this.getPreviousTasks().isEmpty() && this.getNextTasks().isEmpty()) {
            long nplec;
            long plec;
            long npesc;
            long pesc;
            this.earlyStartTime = pesc = this.getUrNextDate(this.getProjectdate(), this.getCalid()).longValue();
            long peec = 0L;
            peec = this.getDut().compareTo(BigDecimal.ZERO) == 0 ? pesc : this.getScNextDate(this.getDut(), pesc, this.getCalid());
            this.earlyFinishTime = peec;
            this.earlyNeedSTime = npesc = pesc;
            long npeec = 0L;
            npeec = this.getNeeddut().compareTo(BigDecimal.ZERO) == 0 ? npesc : this.getScNextDate(this.getNeeddut(), npesc, this.getCalid());
            this.earlyNeedFTime = npeec;
            this.lateFinishTime = plec = this.getUrPrevDate(this.getProjectenddate(), this.getCalid()).longValue();
            long plsc = 0L;
            plsc = this.getDut().compareTo(BigDecimal.ZERO) == 0 ? plec : this.getScPrevDate(this.getDut(), plec, this.getCalid());
            this.lateStartTime = plsc;
            this.lateNeedFTime = nplec = plec;
            long nplsc = 0L;
            nplsc = this.getNeeddut().compareTo(BigDecimal.ZERO) == 0 ? nplec : this.getScPrevDate(this.getNeeddut(), nplec, this.getCalid());
            this.lateNeedSTime = nplsc;
            pmtstask.set("firststartdate", (Object)pesc);
            pmtstask.set("firstenddate", (Object)peec);
            pmtstask.set("laststartdate", (Object)plsc);
            pmtstask.set("lastenddate", (Object)plec);
            pmtstask.set("nfirststartdate", (Object)npesc);
            pmtstask.set("nfirstenddate", (Object)npeec);
            pmtstask.set("nlaststartdate", (Object)nplsc);
            pmtstask.set("nlastenddate", (Object)nplec);
            return true;
        }
        return false;
    }
}

