/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.steps;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.task.taskschedule.model.AbstractPmtsTask;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskPostInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskPreviousInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;
import kd.pmc.pmts.business.task.taskschedule.schedule.day.PmtsTask;
import kd.pmc.pmts.business.task.taskschedule.schedule.hour.PmtsNewTask;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleExcutor;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleStep;

public class PmtsTaskAoeBuilder
extends PmtsTaskScheduleStep {
    private static final Log log = LogFactory.getLog(PmtsTaskAoeBuilder.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("pmts_workcalendar");
    private static final DistributeSessionlessCache HOUR_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("pmts_workcalendar_hour");
    private SimpleDateFormat sdfDetail = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar c = Calendar.getInstance();
    private boolean ISCALBYHOUR = false;
    private PmtsTaskScheduleExcutor ex;
    private PmtsTaskScheduleParamter param;
    private PmtsTaskRunTimeInfo ctx;
    private Map<String, Collection> keyMap;
    private DynamicObjectCollection allTasks;
    private DynamicObjectCollection topTasks;

    public PmtsTaskAoeBuilder(PmtsTaskScheduleExcutor ex, PmtsTaskScheduleParamter param, PmtsTaskRunTimeInfo ctx) {
        this.ex = ex;
        this.param = param;
        this.ctx = ctx;
        this.keyMap = this.buildKeyMap();
        this.allTasks = this.getAllTasks();
        this.topTasks = this.getTopTasks();
        this.ISCALBYHOUR = param.isCalbyhour();
    }

    @Override
    public Object execute() {
        if (!this.topTasks.isEmpty()) {
            try {
                this.buildTopCalNode();
                this.buildNormalNode();
                this.buildCalendarCache();
                this.buildOtherImfo();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                String errMsg = ResManager.loadKDString((String)"\u540e\u53f0\u8ba1\u7b97\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u3002", (String)"PmtsTaskAoeBuilder_1", (String)"mmc-pmts-business", (Object[])new Object[0]);
                PmtsTaskHelper.hasError(this.ctx, errMsg);
            }
        }
        return null;
    }

    private void buildOtherImfo() {
        LinkedList nodes = (LinkedList)this.keyMap.get("calNodes");
        Long dfCalId = Long.parseLong(String.valueOf(this.keyMap.get("calendarIds").iterator().next()));
        Long endTime = Long.parseLong(String.valueOf(this.keyMap.get("endTime").iterator().next()));
        for (AbstractPmtsTask node : nodes) {
            node.setProjectcalenid(dfCalId);
            node.setProjectdate(this.param.getDatatime());
            node.setProjectenddate(endTime);
            node.setLogictype(this.param.getLogictype());
            node.setIsusehopetime(this.param.isIsusehopetime());
            node.setCrossgroup(this.param.getCrossgroup());
            if (node.getCalid() == 0L) {
                node.setCalid(dfCalId);
            }
            this.param.setTl(nodes);
        }
    }

    private void buildNormalNode() {
        Collection topids = this.keyMap.get("topids");
        Collection totalids = this.keyMap.get("totalids");
        HashSet currids = new HashSet();
        LinkedList tl = (LinkedList)this.keyMap.get("calNodes");
        this.allTasks.forEach(task -> {
            if (topids.contains(task.get("previd"))) {
                if (totalids.contains(task.get("id"))) {
                    tl.forEach(ta -> {
                        if (ta.getTaskNumber().equals(task.getString("name"))) {
                            tl.forEach(tt -> {
                                if (tt.getTaskNumber().equals(task.getString("prevname"))) {
                                    ta.getPreviousTasks().add((AbstractPmtsTask)tt);
                                    tt.getNextTasks().add((AbstractPmtsTask)ta);
                                    PmtsTaskPreviousInfo pInfo = new PmtsTaskPreviousInfo();
                                    pInfo.setPrevtask((AbstractPmtsTask)tt);
                                    pInfo.setDelayTime(task.getBigDecimal("delaytime"));
                                    pInfo.setLogic(task.getString("logic"));
                                    pInfo.setDelaytype(this.param.getDelaytype());
                                    ta.getPreviousInfoTasks().add(pInfo);
                                    PmtsTaskPostInfo poInfo = new PmtsTaskPostInfo();
                                    poInfo.setPosttask((AbstractPmtsTask)ta);
                                    poInfo.setLogic(task.getString("logic"));
                                    poInfo.setDelayTime(task.getBigDecimal("delaytime"));
                                    poInfo.setDelaytype(this.param.getDelaytype());
                                    tt.getPostTaskInfos().add(poInfo);
                                }
                            });
                        }
                    });
                } else {
                    BigDecimal plantime = task.getBigDecimal("plantime").setScale(2, 4);
                    BigDecimal needtime = task.getBigDecimal("needtime").setScale(2, 4);
                    AbstractPmtsTask ts = null;
                    ts = this.param.isCalbyhour() ? new PmtsNewTask(task.getString("name"), plantime, this.ctx) : new PmtsTask(task.getString("name"), plantime, this.ctx);
                    ts.setPmtstaskid(task.getLong("id"));
                    ts.setCalid(task.getLong("tasckcalid"));
                    ts.setNeeddut(needtime);
                    ts.setTlunitid(task.getLong("projectunitid"));
                    ts.setStatus(task.getString("executestatus"));
                    if (task.getLong("tasckcalid") > 0L) {
                        this.keyMap.get("calendarIds").add(task.getLong("tasckcalid"));
                    }
                    for (int i = 0; i < tl.size(); ++i) {
                        AbstractPmtsTask ta2 = (AbstractPmtsTask)tl.get(i);
                        if (!ta2.getTaskNumber().equals(task.getString("prevname"))) continue;
                        ts.getPreviousTasks().add(ta2);
                        ta2.getNextTasks().add(ts);
                        PmtsTaskPreviousInfo pInfo = new PmtsTaskPreviousInfo();
                        pInfo.setPrevtask(ta2);
                        pInfo.setDelayTime(task.getBigDecimal("delaytime"));
                        pInfo.setLogic(task.getString("logic"));
                        pInfo.setDelaytype(this.param.getDelaytype());
                        ts.getPreviousInfoTasks().add(pInfo);
                        PmtsTaskPostInfo poInfo = new PmtsTaskPostInfo();
                        poInfo.setPosttask(ts);
                        poInfo.setLogic(task.getString("logic"));
                        poInfo.setDelayTime(task.getBigDecimal("delaytime"));
                        poInfo.setDelaytype(this.param.getDelaytype());
                        ta2.getPostTaskInfos().add(poInfo);
                    }
                    tl.add(ts);
                    currids.add(task.get("id"));
                    totalids.add(task.get("id"));
                }
            }
        });
        if (!currids.isEmpty()) {
            this.keyMap.put("topids", currids);
            this.buildNormalNode();
        }
    }

    private void buildCalendarCache() {
        HashSet calendarids = (HashSet)this.keyMap.get("calendarIds");
        Map calMap = BusinessDataServiceHelper.loadFromCache((String)"pmbd_calendar", (String)"number,expirstartdate,expirendate,modifytime", (QFilter[])new QFilter("id", "in", (Object)calendarids).toArray());
        for (Map.Entry<Object, DynamicObject> entry : calMap.entrySet()) {
            long caid = ((DynamicObject)entry.getValue()).getLong("id");
            if (StringUtils.isEmpty((CharSequence)this.getCalendar(caid))) {
                this.updateCache(entry);
                continue;
            }
            ArrayList calImf = null;
            calImf = !this.ISCALBYHOUR ? (ArrayList)SerializationUtils.fromJsonString((String)((String)this.getNomarlCache().get(String.valueOf(caid))), ArrayList.class) : (ArrayList)SerializationUtils.fromJsonString((String)((String)this.getHourCache().get(String.valueOf(caid))), ArrayList.class);
            Map cacheMap = (Map)calImf.get(0);
            try {
                Date cacheMdtime = this.sdfDetail.parse((String)cacheMap.get("modifytime"));
                Date mdtime = entry.getValue().getDate("modifytime");
                if (cacheMdtime.getTime() >= mdtime.getTime()) continue;
                this.updateCache(entry);
            }
            catch (ParseException e) {
                Iterator it = calendarids.iterator();
                while (it.hasNext()) {
                    if (!this.ISCALBYHOUR) {
                        this.getNomarlCache().remove(String.valueOf(it.next()));
                        continue;
                    }
                    this.getHourCache().remove(String.valueOf(it.next()));
                }
                log.error((Throwable)e);
            }
        }
    }

    private void updateCache(Map.Entry<Object, DynamicObject> cal) {
        try (AlgoContext context = Algo.newContext();){
            ArrayList calImf = new ArrayList(8);
            HashMap<String, Object> dayMap = new HashMap<String, Object>();
            dayMap.put("number", cal.getValue().getString("number"));
            dayMap.put("expirstartdate", this.sdf.format(cal.getValue().getDate("expirstartdate")));
            dayMap.put("expirendate", this.sdf.format(cal.getValue().getDate("expirendate")));
            dayMap.put("modifytime", this.sdfDetail.format(cal.getValue().getDate("modifytime")));
            QFilter pjidFt = new QFilter("pjcalendar", "=", cal.getValue().getPkValue());
            HashSet<String> types = new HashSet<String>();
            types.add("1");
            types.add("2");
            QFilter typeFt = new QFilter("datetype", "in", types);
            DataSet calexp = null;
            calexp = !this.ISCALBYHOUR ? QueryServiceHelper.queryDataSet((String)"pmbd_calendarexpr", (String)"pmbd_calendarexpr", (String)"workdate,worktimeentry.workstarttime as workstarttime,worktimeentry.workfinshtime as workfinshtime,datetype", (QFilter[])new QFilter[]{pjidFt}, (String)"workdate asc") : QueryServiceHelper.queryDataSet((String)"pmbd_calendarexpr", (String)"pmbd_calendarexpr", (String)"workdate,worktimeentry.workstarttime as workstarttime,worktimeentry.workfinshtime as workfinshtime,datetype", (QFilter[])new QFilter[]{pjidFt, typeFt}, (String)"workdate asc");
            if (calexp.isEmpty()) {
                PmtsTaskHelper.hasError(this.ctx, String.format(ResManager.loadKDString((String)"%s:\u65e5\u5386\u540e\u53f0\u8bb0\u5f55\u4e0d\u5b58\u5728", (String)"PmtsTaskAoeBuilder_0", (String)"mmc-pmts-business", (Object[])new Object[0]), cal.getValue().getString("number")));
            }
            DataSet copy = calexp.copy();
            if (!this.ISCALBYHOUR) {
                copy = copy.executeSql("select workdate,min(workstarttime) workstarttime,max(workfinshtime) workfinshtime,datetype group by workdate,datetype order by workdate asc");
            }
            Stack<Long> wkSt = new Stack<Long>();
            long diftime = 0L;
            Map detail = new HashMap();
            Map<Long, Long> detail_total = new HashMap();
            for (Row row : copy) {
                long wkt;
                List expLs = null;
                long wst = wkt = row.getDate("workdate").getTime();
                long wft = wkt;
                if (!row.get("workstarttime").equals(0)) {
                    wst = wkt + row.getLong("workstarttime") * 1000L;
                }
                if (!row.get("workfinshtime").equals(0)) {
                    wft = wkt + row.getLong("workfinshtime") * 1000L;
                }
                String type = row.getString("datetype");
                this.c.setTimeInMillis(wkt);
                expLs = detail.containsKey(wkt) ? (List)detail.get(wkt) : new ArrayList(8);
                HashMap<String, Object> hourMap = new HashMap<String, Object>();
                hourMap.put("workdate", wkt);
                hourMap.put("workdate1", String.valueOf(this.c.getTime()));
                hourMap.put("datetype", type);
                hourMap.put("workstarttime", wst);
                hourMap.put("workfinshtime", wft);
                long curdif = wft - wst;
                hourMap.put("diftime", curdif);
                expLs.add(hourMap);
                diftime = !wkSt.isEmpty() && wkSt.peek().equals(wkt) ? (diftime += curdif) : curdif;
                detail.put(wkt, expLs);
                detail_total.put(wkt, diftime);
                wkSt.push(wkt);
            }
            detail = PmtsTaskAoeBuilder.sortMapByKey(detail);
            detail_total = PmtsTaskAoeBuilder.sortMapByKey(detail_total);
            dayMap.put("detail", detail);
            dayMap.put("detail_total", detail_total);
            calImf.add(dayMap);
            this.setCacheValue(String.valueOf(cal.getValue().getPkValue()), SerializationUtils.toJsonString(calImf));
        }
    }

    private String getCalendar(Object calendarid) {
        if (!this.ISCALBYHOUR) {
            return (String)CACHE.get(String.valueOf(calendarid));
        }
        return (String)HOUR_CACHE.get(String.valueOf(calendarid));
    }

    private void setCacheValue(String id, String value) {
        if (!this.ISCALBYHOUR) {
            CACHE.put(id, (Object)value);
        } else {
            HOUR_CACHE.put(id, (Object)value);
        }
    }

    private DynamicObjectCollection getAllTasks() {
        String selectProps = "id,name,durationunit,timeunit,taskcalendar.id as tasckcalid,plantime,needtime,prepositiontaskentry.prepositiontask.id as previd,prepositiontaskentry.prepositiontask.name as prevname,prepositiontaskentry.taskrelation as logic,prepositiontaskentry.predelayed as delaytime,projectnum.pjcale.id as projectcalid,executestatus,projectnum.timeunit.id as projectunitid";
        List<QFilter> taskQF = this.getDefaultFilters();
        DynamicObjectCollection normaltask = QueryServiceHelper.query((String)"pmts_task", (String)selectProps, (QFilter[])taskQF.toArray(new QFilter[taskQF.size()]), (String)"number desc");
        return normaltask;
    }

    private DynamicObjectCollection getTopTasks() {
        String selectProps = "id,name,projectnum.planstartdate as projectdate,projectnum.planfinshdate as projectenddate,taskcalendar.id as tasckcalid,durationunit,timeunit,plantime,needtime,projectnum.pjcale.id as projectcalid,executestatus,projectnum.timeunit.id as  projectunitid";
        List<QFilter> topQF = this.getDefaultFilters();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        topQF.add(new QFilter("prepositiontaskentry.prepositiontask.id", "is null", null));
        DynamicObjectCollection toptasks = QueryServiceHelper.query((String)"pmts_task", (String)selectProps, (QFilter[])topQF.toArray(new QFilter[topQF.size()]), (String)"number desc");
        if (!toptasks.isEmpty()) {
            this.keyMap.get("calendarIds").add(((DynamicObject)toptasks.get(0)).getLong("projectcalid"));
            this.keyMap.get("endTime").add(((DynamicObject)toptasks.get(0)).getDate("projectenddate").getTime());
        }
        return toptasks;
    }

    private List<QFilter> getDefaultFilters() {
        ArrayList<QFilter> taskQF = new ArrayList<QFilter>(8);
        taskQF.add(new QFilter("projectnum", "=", (Object)this.param.getProjectid()));
        taskQF.add(new QFilter("version", "is null", null).or("version", "=", (Object)0));
        if (this.param.getPlanTypeid() > 0L) {
            taskQF.add(new QFilter("plantype", "=", (Object)this.param.getPlanTypeid()));
        }
        if (CollectionUtils.isNotEmpty(this.param.getWbsid())) {
            taskQF.add(new QFilter("wbs.id", "in", this.param.getWbsid()));
        }
        return taskQF;
    }

    private Map<String, Collection> buildKeyMap() {
        HashMap<String, Collection> map = new HashMap<String, Collection>();
        map.put("topids", new HashSet());
        map.put("totalids", new HashSet());
        map.put("calNodes", new LinkedList());
        map.put("calendarIds", new HashSet());
        map.put("endTime", new HashSet());
        return map;
    }

    private void buildTopCalNode() {
        for (DynamicObject task : this.topTasks) {
            BigDecimal plantime = task.getBigDecimal("plantime").setScale(2, 4);
            BigDecimal needtime = task.getBigDecimal("needtime").setScale(2, 4);
            AbstractPmtsTask ts = null;
            ts = !this.ISCALBYHOUR ? new PmtsTask(task.getString("name"), plantime, this.ctx) : new PmtsNewTask(task.getString("name"), plantime, this.ctx);
            ts.setStatus(task.getString("executestatus"));
            ts.setPmtstaskid(task.getLong("id"));
            ts.setNeeddut(needtime);
            ts.setTlunitid(task.getLong("projectunitid"));
            if (task.getLong("tasckcalid") > 0L) {
                ts.setCalid(task.getLong("tasckcalid"));
            }
            if (task.getLong("tasckcalid") > 0L) {
                this.keyMap.get("calendarIds").add(task.getLong("tasckcalid"));
            }
            this.keyMap.get("calNodes").add(ts);
            this.keyMap.get("topids").add(task.getLong("id"));
            this.keyMap.get("totalids").add(task.getLong("id"));
        }
    }

    public static Map sortMapByKey(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        TreeMap sortMap = new TreeMap(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long l2;
                if (o1 instanceof Long) {
                    long value = (Long)o1 - (Long)o2;
                    if (value > 0L) {
                        return 1;
                    }
                    if (value == 0L) {
                        return 0;
                    }
                    return -1;
                }
                String s1 = (String)o1;
                String s2 = (String)o2;
                long l1 = PmtsTaskAoeBuilder.getLongValue(s1.split("_")[0]);
                long value = l1 - (l2 = PmtsTaskAoeBuilder.getLongValue(s2.split("_")[0]));
                if (value > 0L) {
                    return 1;
                }
                if (value == 0L) {
                    return 0;
                }
                return -1;
            }
        });
        sortMap.putAll(map);
        return sortMap;
    }

    private static long getLongValue(String s) {
        return Long.parseLong(s);
    }

    private DistributeSessionlessCache getNomarlCache() {
        return CACHE;
    }

    private DistributeSessionlessCache getHourCache() {
        return HOUR_CACHE;
    }
}

