/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.steps;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.helper.TaskScheduleDetailHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleStep;

public class PmtsTaskChecker
extends PmtsTaskScheduleStep {
    private static final String STATICS = "statics";
    private static final String QTY = "qty";
    private PmtsTaskScheduleParamter param;
    private PmtsTaskRunTimeInfo ctx;
    private static final String BYNUMBER = "number desc";
    private static final Log log = LogFactory.getLog(PmtsTaskChecker.class);

    public PmtsTaskChecker(PmtsTaskScheduleParamter param, PmtsTaskRunTimeInfo ctx) {
        this.param = param;
        this.ctx = ctx;
    }

    @Override
    public Object execute() {
        QFilter topqf = new QFilter("prepositiontaskentry.prepositiontask.id", "is null", null);
        List<QFilter> topFilters = this.getDefaultFilters();
        topFilters.add(topqf);
        QFilter[] topqfs = topFilters.toArray(new QFilter[topFilters.size()]);
        QFilter bottomqf = new QFilter("postpositiontaskentry.postpositiontask.id", "is null", null);
        List<QFilter> botFilters = this.getDefaultFilters();
        botFilters.add(bottomqf);
        QFilter[] bottomqfs = botFilters.toArray(new QFilter[botFilters.size()]);
        List<QFilter> freefilters = this.getDefaultFilters();
        freefilters.add(topqf);
        freefilters.add(bottomqf);
        QFilter[] freefilter = freefilters.toArray(new QFilter[freefilters.size()]);
        List<QFilter> allFilters = this.getDefaultFilters();
        QFilter[] allqfs = allFilters.toArray(new QFilter[allFilters.size()]);
        String msg = "";
        msg = CollectionUtils.isNotEmpty(this.param.getWbsid()) ? ResManager.loadKDString((String)"\u68c0\u67e5WBS\u4efb\u52a1\u6e05\u5355", (String)"PmtsTaskChecker_21", (String)"mmc-pmts-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u76ee\u4efb\u52a1\u6e05\u5355", (String)"PmtsTaskChecker_0", (String)"mmc-pmts-business", (Object[])new Object[0]);
        PmtsTaskHelper.hasRunning(this.ctx, msg);
        DynamicObjectCollection alltasks = QueryServiceHelper.query((String)"pmts_task", (String)"id,name,scheduletype,plantime,projectnum.pjcale.id as projectcalid,executestatus,limitone,limitonedate,limittwo,limittwodate", (QFilter[])allqfs, (String)BYNUMBER);
        Set allids = alltasks.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        if (alltasks.isEmpty()) {
            msg = CollectionUtils.isNotEmpty(this.param.getWbsid()) ? ResManager.loadKDString((String)"\u8be5WBS\u4e0d\u5b58\u5728\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u5212\uff0c\u8fd0\u7b97\u7ed3\u675f", (String)"PmtsTaskChecker_20", (String)"mmc-pmts-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u65e0\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u5212\uff0c\u8fd0\u7b97\u5df2\u7ed3\u675f\u3002", (String)"PmtsTaskChecker_1", (String)"mmc-pmts-business", (Object[])new Object[0]);
            PmtsTaskHelper.hasError(this.ctx, msg);
            this.setStop(true);
            return 0;
        }
        msg = CollectionUtils.isNotEmpty(this.param.getWbsid()) ? ResManager.loadKDString((String)"\u68c0\u67e5WBS\u4efb\u52a1\u5f00\u53e3", (String)"PmtsTaskChecker_19", (String)"mmc-pmts-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u76ee\u4efb\u52a1\u5f00\u53e3", (String)"PmtsTaskChecker_2", (String)"mmc-pmts-business", (Object[])new Object[0]);
        PmtsTaskHelper.hasRunning(this.ctx, msg);
        DynamicObjectCollection freetasks = QueryServiceHelper.query((String)"pmts_task", (String)"id", (QFilter[])freefilter, (String)BYNUMBER);
        Set freeids = freetasks.stream().map(f -> f.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection kktasks = QueryServiceHelper.query((String)"pmts_task", (String)"id", (QFilter[])topqfs, (String)BYNUMBER);
        boolean isallkkfree = kktasks.stream().allMatch(k -> freeids.contains(k.getLong("id")));
        boolean isnotallfree = allids.stream().anyMatch(i -> !freeids.contains(i));
        if (isallkkfree && isnotallfree) {
            msg = ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u65e0\u5f00\u53e3\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u5173\u7cfb", (String)"PmtsTaskChecker_3", (String)"mmc-pmts-business", (Object[])new Object[0]);
            if (CollectionUtils.isNotEmpty(this.param.getWbsid())) {
                msg = ResManager.loadKDString((String)"\u8be5WBS\u65e0\u5f00\u53e3\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u5173\u7cfb", (String)"PmtsTaskChecker_18", (String)"mmc-pmts-business", (Object[])new Object[0]);
            }
            PmtsTaskHelper.hasError(this.ctx, msg);
            this.setStop(true);
            return 0;
        }
        DynamicObjectCollection tltasks = QueryServiceHelper.query((String)"pmts_task", (String)"id", (QFilter[])bottomqfs, (String)BYNUMBER);
        long defaultcalid = ((DynamicObject)alltasks.get(0)).getLong("projectcalid");
        PmtsTaskHelper.hasRunning(this.ctx, ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u76ee\u65e5\u5386", (String)"PmtsTaskChecker_4", (String)"mmc-pmts-business", (Object[])new Object[0]));
        if (defaultcalid == 0L) {
            PmtsTaskHelper.hasError(this.ctx, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u672a\u7ef4\u62a4\u9879\u76ee\u9ed8\u8ba4\u65e5\u5386\uff0c\u8fd0\u7b97\u7ed3\u675f", (String)"PmtsTaskChecker_5", (String)"mmc-pmts-business", (Object[])new Object[0]));
            this.setStop(true);
            return 0;
        }
        PmtsTaskHelper.hasRunning(this.ctx, ResManager.loadKDString((String)"\u68c0\u67e5\u7f51\u7edc\u56de\u8def", (String)"PmtsTaskChecker_6", (String)"mmc-pmts-business", (Object[])new Object[0]));
        HashSet<Long> topids = new HashSet<Long>();
        HashSet<Long> totalids = new HashSet<Long>();
        for (DynamicObject task : alltasks) {
            totalids.add(task.getLong("id"));
        }
        for (DynamicObject kktask : kktasks) {
            topids.add(kktask.getLong("id"));
        }
        try (AlgoContext context = Algo.newContext();){
            DataSet kkset = QueryServiceHelper.queryDataSet((String)"PMTS_TASK_KK", (String)"pmts_task", (String)"prepositiontaskentry.prepositiontask.id as parentid,projectnum.id as pjid,id,projectnum.name as pjname,name,plantime,needtime,wbs.id as wbsid", (QFilter[])topqfs, (String)BYNUMBER);
            kkset = kkset.select("parentid,id,concat(pjid,'_',id) as path,concat(pjname,'_',name) as pathname,plantime,needtime,wbsid");
            boolean hasCircle = this.checkCircle(totalids, topids, kkset);
            if (hasCircle) {
                Integer n = 0;
                return n;
            }
        }
        PmtsTaskHelper.hasRunning(this.ctx, ResManager.loadKDString((String)"\u6536\u96c6\u4efb\u52a1\u4fe1\u606f", (String)"PmtsTaskChecker_7", (String)"mmc-pmts-business", (Object[])new Object[0]));
        this.createStatistics(kktasks.size() + tltasks.size(), alltasks);
        return 0;
    }

    private void createStatistics(int i, DynamicObjectCollection alltasks) {
        long detailId = TaskScheduleDetailHelper.getDetailid(this.ctx);
        ORM orm = ORM.create();
        BasedataEntityType mType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)"pmts_taskschedule_detail");
        DynamicObject detailObj = BusinessDataServiceHelper.loadSingle((Object)detailId, (DynamicObjectType)mType);
        DynamicObjectType entryTP = null;
        for (IDataEntityProperty type : mType.getProperties()) {
            if (!type.getName().equals("entryentity_sta")) continue;
            EntryProp stepProp = (EntryProp)type;
            entryTP = stepProp.getDynamicCollectionItemPropertyType();
            break;
        }
        DynamicObjectCollection staEntrys = detailObj.getDynamicObjectCollection("entryentity_sta");
        DynamicObject staEntry = orm.newDynamicObject(entryTP);
        staEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u52a1\u603b\u6570", (String)"PmtsTaskChecker_8", (String)"mmc-pmts-business", (Object[])new Object[0]));
        staEntry.set(QTY, (Object)alltasks.size());
        staEntrys.add((Object)staEntry);
        int plantime = 0;
        int islcb = 0;
        int notStart = 0;
        int isStart = 0;
        int ispause = 0;
        int isEnd = 0;
        int hasLimt = 0;
        for (DynamicObject task : alltasks) {
            boolean hasLT;
            if (task.getBigDecimal("plantime").compareTo(BigDecimal.ZERO) == 0) {
                ++plantime;
            }
            if (task.getString("scheduletype").equals("3") || task.getString("scheduletype").equals("4")) {
                ++islcb;
            }
            if (task.getString("executestatus").equals("1")) {
                ++notStart;
            }
            if (task.getString("executestatus").equals("2")) {
                ++isStart;
            }
            if (task.getString("executestatus").equals("3")) {
                ++ispause;
            }
            if (task.getString("executestatus").equals("4")) {
                ++isEnd;
            }
            boolean hasLO = Objects.nonNull(task.get("limitone")) && Objects.nonNull(task.get("limitonedate"));
            boolean bl = hasLT = Objects.nonNull(task.get("limittwo")) && Objects.nonNull(task.get("limittwodate"));
            if (!hasLO && !hasLT) continue;
            ++hasLimt;
        }
        DynamicObject plEntry = orm.newDynamicObject(entryTP);
        plEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u5de5\u671f\u4e3a0\u7684\u4efb\u52a1", (String)"PmtsTaskChecker_9", (String)"mmc-pmts-business", (Object[])new Object[0]));
        plEntry.set(QTY, (Object)plantime);
        staEntrys.add((Object)plEntry);
        DynamicObject lcbEntry = orm.newDynamicObject(entryTP);
        lcbEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u4efb\u52a1", (String)"PmtsTaskChecker_10", (String)"mmc-pmts-business", (Object[])new Object[0]));
        lcbEntry.set(QTY, (Object)islcb);
        staEntrys.add((Object)lcbEntry);
        DynamicObject nsEntry = orm.newDynamicObject(entryTP);
        nsEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u672a\u5f00\u59cb\u4efb\u52a1", (String)"PmtsTaskChecker_11", (String)"mmc-pmts-business", (Object[])new Object[0]));
        nsEntry.set(QTY, (Object)notStart);
        staEntrys.add((Object)nsEntry);
        DynamicObject isEntry = orm.newDynamicObject(entryTP);
        isEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u7684\u4efb\u52a1", (String)"PmtsTaskChecker_12", (String)"mmc-pmts-business", (Object[])new Object[0]));
        isEntry.set(QTY, (Object)isStart);
        staEntrys.add((Object)isEntry);
        DynamicObject ipEntry = orm.newDynamicObject(entryTP);
        ipEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u6682\u505c\u7684\u4efb\u52a1", (String)"PmtsTaskChecker_13", (String)"mmc-pmts-business", (Object[])new Object[0]));
        ipEntry.set(QTY, (Object)ispause);
        staEntrys.add((Object)ipEntry);
        DynamicObject ieEntry = orm.newDynamicObject(entryTP);
        ieEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u5b8c\u5de5\u7684\u4efb\u52a1", (String)"PmtsTaskChecker_14", (String)"mmc-pmts-business", (Object[])new Object[0]));
        ieEntry.set(QTY, (Object)isEnd);
        staEntrys.add((Object)ieEntry);
        DynamicObject hlEntry = orm.newDynamicObject(entryTP);
        hlEntry.set(STATICS, (Object)ResManager.loadKDString((String)"\u6709\u9650\u5236\u6761\u4ef6\u7684\u4efb\u52a1", (String)"PmtsTaskChecker_15", (String)"mmc-pmts-business", (Object[])new Object[0]));
        hlEntry.set(QTY, (Object)hasLimt);
        staEntrys.add((Object)hlEntry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailObj});
    }

    private boolean checkCircle(Set totalids, Set topids, DataSet totalset) {
        try (AlgoContext context = Algo.newContext();){
            boolean hasCircle = false;
            QFilter normalqf = new QFilter("prepositiontaskentry.prepositiontask.id", "in", (Object)topids.toArray());
            DataSet taskset = QueryServiceHelper.queryDataSet((String)"PMTS_TASK_KK", (String)"pmts_task", (String)"prepositiontaskentry.prepositiontask.name as parentname,name,prepositiontaskentry.prepositiontask.id as parentid,plantime,needtime,id,wbs.id as wbsid", (QFilter[])normalqf.toArray(), (String)BYNUMBER);
            DataSet newset = taskset.copy();
            DataSet newtotalset = totalset.copy();
            if (taskset.isEmpty()) {
                boolean bl = hasCircle;
                return bl;
            }
            taskset = taskset.select("wbsid as cwbsid,parentid,id,id as cpath,name as cpathname,plantime as cplantime,needtime as cneedtime");
            taskset = taskset.leftJoin(totalset).on("parentid", "id").select(new String[]{"parentid", "cwbsid", "id", "cpath", "cpathname", "cplantime", "cneedtime"}, new String[]{"path", "pathname", "plantime", "needtime", "wbsid"}).finish();
            HashSet<Long> currids = new HashSet<Long>();
            for (Row row : taskset) {
                String path = row.getString("path");
                String pathname = row.getString("pathname");
                String cpath = row.getString("cpath");
                String cpathname = row.getString("cpathname");
                if (!(!CollectionUtils.isNotEmpty(this.param.getWbsid()) || this.param.getWbsid().contains(row.getLong("cwbsid")) && this.param.getWbsid().contains(row.getLong("wbsid")))) {
                    PmtsTaskHelper.hasError(this.ctx, ResManager.loadKDString((String)"\u5f53\u524dWBS\u8282\u70b9\u4e0b\u7684\u4efb\u52a1\u5173\u7cfb\u7ef4\u62a4\u4e86\u975e\u5f53\u524dWBS\u8282\u70b9\u4efb\u52a1\uff0c\u8ba1\u7b97\u5931\u8d25\u3002", (String)"PmtsTaskChecker_17", (String)"mmc-pmts-business", (Object[])new Object[0]));
                }
                double plantime = Double.parseDouble(row.getString("plantime"));
                double needtime = Double.parseDouble(row.getString("needtime"));
                double cplantime = Double.parseDouble(row.getString("cplantime"));
                double cneedtime = Double.parseDouble(row.getString("cneedtime"));
                HashMap<String, Object> patchMap = new HashMap<String, Object>();
                patchMap.put("path", path + "_" + cpath);
                patchMap.put("plantime", plantime + cplantime);
                patchMap.put("needtime", needtime + cneedtime);
                log.info(String.format("%s_%s", pathname, cpathname));
                this.ctx.getPaths().add(patchMap);
                String[] pathArr = path.split("_");
                for (int i = 0; i < pathArr.length; ++i) {
                    if (!pathArr[i].equals(cpath)) continue;
                    hasCircle = true;
                    StringBuilder msg = new StringBuilder();
                    msg.append(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u5f15\u7528\u8def\u5f84\u4e3a:%s", (String)"PmtsTaskChecker_16", (String)"mmc-pmts-business", (Object[])new Object[0]), String.format("%s_%s", pathname, cpathname)));
                    PmtsTaskHelper.hasError(this.ctx, msg.toString());
                    this.setStop(true);
                    boolean bl = hasCircle;
                    return bl;
                }
                currids.add(row.getLong("id"));
            }
            if (!currids.isEmpty()) {
                newset = newset.select("parentid,id,wbsid,id as cpath, name as cpathname,plantime as cplantime,needtime as cneedtime");
                DataSet s1 = newset.leftJoin(newtotalset).on("parentid", "id").select(new String[]{"parentid", "id", "cpath", "cpathname", "cplantime", "cneedtime"}, new String[]{"path", "pathname", "plantime", "needtime", "wbsid"}).finish().copy();
                DataSet s2 = s1.select(new String[]{"parentid", "wbsid", "id", "concat(path,'_',cpath) as path", "concat(pathname,'_',cpathname) as pathname", "cplantime+plantime as plantime", "cneedtime+needtime as needtime"}).copy();
                hasCircle = this.checkCircle(totalids, currids, s2);
            }
            boolean bl = hasCircle;
            return bl;
        }
    }

    private List<QFilter> getDefaultFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("projectnum", "=", (Object)this.param.getProjectid()));
        filters.add(new QFilter("version", "is null", null).or("version", "=", (Object)0));
        if (this.param.getPlanTypeid() > 0L) {
            filters.add(new QFilter("plantype.id", "=", (Object)this.param.getPlanTypeid()));
        }
        if (CollectionUtils.isNotEmpty(this.param.getWbsid())) {
            filters.add(new QFilter("wbs.id", "in", this.param.getWbsid()));
        }
        return filters;
    }
}

