/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.steps;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmc.pmts.business.helper.PmtsProjectCalendarHelper;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.task.taskschedule.model.AbstractPmtsTask;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class PmtsTaskDateCaculater {
    private static final Log log = LogFactory.getLog(PmtsTaskDateCaculater.class);
    private PmtsTaskRunTimeInfo ctx;
    private List<AbstractPmtsTask> tasks;
    private Set<AbstractPmtsTask> noPreviousTasks;
    private Set<AbstractPmtsTask> noNextTasks;

    public List<AbstractPmtsTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<AbstractPmtsTask> tasks) {
        this.tasks = tasks;
    }

    public Set<AbstractPmtsTask> getNoPreviousTasks() {
        return this.noPreviousTasks;
    }

    public void setNoPreviousTasks(Set<AbstractPmtsTask> noPreviousTasks) {
        this.noPreviousTasks = noPreviousTasks;
    }

    public Set<AbstractPmtsTask> getNoNextTasks() {
        return this.noNextTasks;
    }

    public void setNoNextTasks(Set<AbstractPmtsTask> noNextTasks) {
        this.noNextTasks = noNextTasks;
    }

    public PmtsTaskDateCaculater(List<AbstractPmtsTask> tasks, PmtsTaskRunTimeInfo ctx) {
        this.tasks = tasks;
        this.noNextTasks = new LinkedHashSet<AbstractPmtsTask>();
        this.noPreviousTasks = new LinkedHashSet<AbstractPmtsTask>();
        this.ctx = ctx;
    }

    public Set<AbstractPmtsTask> getNoPreviousTasks(List<AbstractPmtsTask> tasks) {
        if (tasks != null && tasks.size() > 0) {
            for (AbstractPmtsTask task : tasks) {
                if (task == null || task.getPreviousTasks().size() != 0) continue;
                this.noPreviousTasks.add(task);
            }
        }
        return this.noPreviousTasks;
    }

    public Set<AbstractPmtsTask> getNoNextTasks(List<AbstractPmtsTask> tasks) {
        if (tasks != null && tasks.size() > 0) {
            for (AbstractPmtsTask task : tasks) {
                if (task == null || task.getNextTasks().size() != 0) continue;
                this.noNextTasks.add(task);
            }
        }
        return this.noNextTasks;
    }

    private Set<AbstractPmtsTask> calculateNoPreviousEarlyTime(List<AbstractPmtsTask> tasks) {
        LinkedHashSet<AbstractPmtsTask> calTasks = new LinkedHashSet<AbstractPmtsTask>();
        if (tasks != null && tasks.size() > 0) {
            Set<AbstractPmtsTask> noPreviousTasks = this.getNoPreviousTasks(tasks);
            for (AbstractPmtsTask task : noPreviousTasks) {
                if (!task.isCalEST() && !task.isCalEFT()) {
                    task.calEarlyTime();
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public Set<AbstractPmtsTask> calculateEarlyTime(Set<AbstractPmtsTask> nextTasks) {
        LinkedHashSet<AbstractPmtsTask> calTasks = new LinkedHashSet<AbstractPmtsTask>();
        if (nextTasks != null && nextTasks.size() > 0) {
            for (AbstractPmtsTask task : nextTasks) {
                List<AbstractPmtsTask> befTask = task.getPreviousTasks();
                int count = 0;
                for (int i = 0; i < befTask.size(); ++i) {
                    AbstractPmtsTask bfTask = befTask.get(i);
                    if (!bfTask.isCalEST() || !bfTask.isCalEFT()) continue;
                    ++count;
                }
                if (count == befTask.size()) {
                    task.calEarlyTime();
                    calTasks.addAll(task.getNextTasks());
                    continue;
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public Set<AbstractPmtsTask> calNoNextTasksLateTime(List<AbstractPmtsTask> tasks) {
        LinkedHashSet<AbstractPmtsTask> calTasks = new LinkedHashSet<AbstractPmtsTask>();
        if (tasks != null && tasks.size() > 0) {
            for (AbstractPmtsTask task : this.getNoNextTasks(tasks)) {
                if (!task.isCalLST() && !task.isCalLFT()) {
                    task.calculateLT();
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public Set<AbstractPmtsTask> calculateLateTime(Set<AbstractPmtsTask> nextTasks) {
        LinkedHashSet<AbstractPmtsTask> calTasks = new LinkedHashSet<AbstractPmtsTask>();
        if (nextTasks != null && nextTasks.size() > 0) {
            for (AbstractPmtsTask task : nextTasks) {
                List<AbstractPmtsTask> nextTask = task.getNextTasks();
                int count = 0;
                for (int i = 0; i < nextTask.size(); ++i) {
                    AbstractPmtsTask ntTask = nextTask.get(i);
                    if (!ntTask.isCalLST() || !ntTask.isCalLFT()) continue;
                    ++count;
                }
                if (count == nextTask.size()) {
                    task.calculateLT();
                    calTasks.addAll(task.getPreviousTasks());
                    continue;
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }

    public void calculateTime() {
        try {
            Set<AbstractPmtsTask> tmpTasks;
            PmtsTaskHelper.hasRunning(this.ctx, ResManager.loadKDString((String)"\u5f00\u59cb\u6b63\u6392\u8ba1\u7b97\u6700\u65e9\u65e5\u671f", (String)"PmtsTaskDateCaculater_0", (String)"mmc-pmts-business", (Object[])new Object[0]));
            Set<AbstractPmtsTask> firstTimes = this.calculateNoPreviousEarlyTime(this.tasks);
            Set<AbstractPmtsTask> nextTimes = this.calculateEarlyTime(firstTimes);
            while ((nextTimes = this.calculateEarlyTime(tmpTasks = nextTimes)).size() > 0) {
            }
            long lstart = System.currentTimeMillis();
            firstTimes.clear();
            nextTimes.clear();
            tmpTasks.clear();
            PmtsTaskHelper.hasRunning(this.ctx, ResManager.loadKDString((String)"\u5f00\u59cb\u5012\u6392\u8ba1\u7b97\u6700\u665a\u65e5\u671f", (String)"PmtsTaskDateCaculater_1", (String)"mmc-pmts-business", (Object[])new Object[0]));
            firstTimes = this.tasks.get(0).getCrossgroup().equals("2") ? this.calSpecialLateTime(this.tasks) : this.calNoNextTasksLateTime(this.tasks);
            nextTimes = this.calculateLateTime(firstTimes);
            while ((nextTimes = this.calculateLateTime(tmpTasks = nextTimes)).size() > 0) {
            }
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Set<AbstractPmtsTask> calSpecialLateTime(List<AbstractPmtsTask> tasks) {
        LinkedHashSet<AbstractPmtsTask> calTasks = new LinkedHashSet<AbstractPmtsTask>();
        if (tasks != null && tasks.size() > 0) {
            Set<AbstractPmtsTask> detailtasks = this.getNoNextTasks(tasks);
            long maxsftime = 0L;
            long maxnfttime = 0L;
            int i = 0;
            for (AbstractPmtsTask task : detailtasks) {
                long temptime = task.getEarlyFinishTime();
                long tempneedtime = task.getEarlyNeedFTime();
                if (i == 0) {
                    maxsftime = temptime;
                    maxnfttime = tempneedtime;
                }
                if (temptime > maxsftime) {
                    maxsftime = temptime;
                }
                if (tempneedtime > maxnfttime) {
                    maxnfttime = tempneedtime;
                }
                ++i;
            }
            for (AbstractPmtsTask task : detailtasks) {
                if (!task.isCalLST() && !task.isCalLFT()) {
                    long lft = 0L;
                    if (this.ctx.isCalByhour()) {
                        lft = maxsftime;
                        task.setLateFinishTime(lft);
                    } else {
                        Map sfMap = PmtsProjectCalendarHelper.getCurrDateMap(maxsftime, task.getCalid(), this.ctx);
                        sfMap = PmtsProjectCalendarHelper.getUnRestPrevDate(sfMap, task.getCalid(), this.ctx);
                        task.setLateFinishTime(PmtsProjectCalendarHelper.getWorkFinshDate(sfMap));
                        Map nsfMap = PmtsProjectCalendarHelper.getCurrDateMap(maxnfttime, task.getCalid(), this.ctx);
                        nsfMap = PmtsProjectCalendarHelper.getUnRestPrevDate(nsfMap, task.getCalid(), this.ctx);
                        lft = PmtsProjectCalendarHelper.getWorkFinshDate(nsfMap);
                    }
                    task.setLateNeedFTime(lft);
                    task.calculateLT();
                }
                calTasks.add(task);
            }
        }
        return calTasks;
    }
}

