/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.helper.TaskScheduleDetailHelper;
import kd.pmc.pmts.business.task.taskschedule.model.AbstractPmtsTask;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleExcutor;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleStep;

public class PmtsTaskPlanUpdater
extends PmtsTaskScheduleStep {
    private static final Log log = LogFactory.getLog(PmtsTaskPlanUpdater.class);
    private static long ONEDAYMS = 86400000L;
    private List<List> maxLs = new ArrayList<List>(8);
    private List<List> secLs = new ArrayList<List>(8);
    private PmtsTaskScheduleExcutor ex;
    private PmtsTaskScheduleParamter param;
    private PmtsTaskRunTimeInfo ctx;

    public PmtsTaskPlanUpdater(PmtsTaskScheduleExcutor ex, PmtsTaskScheduleParamter param, PmtsTaskRunTimeInfo ctx) {
        this.ex = ex;
        this.param = param;
        this.ctx = ctx;
    }

    @Override
    public Object execute() {
        this.buildMaxPath();
        this.caculateStartTime();
        PmtsTaskHelper.hasComplete(this.ctx);
        this.param.setEndTime(System.currentTimeMillis());
        return null;
    }

    private void caculateStartTime() {
        List<AbstractPmtsTask> tasks = this.param.getTl();
        DynamicObject planParam = BusinessDataServiceHelper.loadSingle((Object)this.param.getPlanparam(), (String)"pmts_taskscheme");
        long lstart = System.currentTimeMillis();
        PmtsTaskHelper.hasRunning(this.ctx, ResManager.loadKDString((String)"\u5f00\u59cb\u66f4\u65b0\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u5212\u65f6\u95f4", (String)"PmtsTaskPlanUpdater_0", (String)"mmc-pmts-business", (Object[])new Object[0]));
        long detailId = TaskScheduleDetailHelper.getDetailid(this.ctx);
        BasedataEntityType mType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)"pmts_taskschedule_detail");
        DynamicObject detailObj = BusinessDataServiceHelper.loadSingle((Object)detailId, (DynamicObjectType)mType);
        DynamicObjectType entryTP = null;
        for (IDataEntityProperty type : mType.getProperties()) {
            if (!type.getName().equals("entryentity_result")) continue;
            EntryProp stepProp = (EntryProp)type;
            entryTP = stepProp.getDynamicCollectionItemPropertyType();
            break;
        }
        DynamicObjectCollection rsEntrys = detailObj.getDynamicObjectCollection("entryentity_result");
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(8);
        for (AbstractPmtsTask task : tasks) {
            DynamicObject pmtstask;
            if (task.isFreeTask(pmtstask = BusinessDataServiceHelper.loadSingle((Object)task.getPmtstaskid(), (String)"pmts_task", (String)"floattime,nfirststartdate,nlaststartdate,nfirstenddate,nlastenddate,ismaxpath,freefloattime,timeunit,plantime,needtime,planstartdate,planenddate,firststartdate,laststartdate,firstenddate,lastenddate,iscrux"))) {
                long evalue = task.getLateFinishTime() - task.getEarlyFinishTime();
                long lvalue = task.getLateStartTime() - task.getEarlyStartTime();
                if (planParam.getString("caltypegroup").equals("1")) {
                    this.updateFloteTime(pmtstask, lvalue);
                } else if (planParam.getString("caltypegroup").equals("2")) {
                    this.updateFloteTime(pmtstask, evalue);
                } else if (evalue > lvalue) {
                    this.updateFloteTime(pmtstask, lvalue);
                } else {
                    this.updateFloteTime(pmtstask, evalue);
                }
                if (planParam.getBoolean("isupdatetime") && planParam.getString("crossgroup").equals("1")) {
                    pmtstask.set("planstartdate", (Object)task.getEarlyStartTime());
                    pmtstask.set("planenddate", (Object)task.getEarlyFinishTime());
                } else if (planParam.getBoolean("isupdatetime") && planParam.getString("crossgroup").equals("2")) {
                    pmtstask.set("planstartdate", (Object)task.getLateStartTime());
                    pmtstask.set("planenddate", (Object)task.getLateFinishTime());
                }
                if (planParam.getBoolean("iscriticalpath")) {
                    pmtstask.set("ismaxpath", (Object)true);
                } else {
                    pmtstask.set("ismaxpath", (Object)false);
                    pmtstask.set("iscrux", (Object)false);
                }
                this.setTaskResultEntry(entryTP, pmtstask, rsEntrys);
            } else {
                this.updatePlanTime(pmtstask, task, planParam);
                this.updateNeedTime(pmtstask, task, planParam);
                this.setTaskResultEntry(entryTP, pmtstask, rsEntrys);
            }
            datas.add(pmtstask);
        }
        SaveServiceHelper.update((DynamicObject[])datas.toArray(new DynamicObject[datas.size()]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{detailObj});
        long lend = System.currentTimeMillis();
        PmtsTaskHelper.hasRunning(this.ctx, String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u8fdb\u5ea6\u8ba1\u5212\u65f6\u95f4\u5df2\u66f4\u65b0\uff0c\u8017\u65f6%s\u3002", (String)"PmtsTaskPlanUpdater_1", (String)"mmc-pmts-business", (Object[])new Object[0]), lend - lstart));
    }

    private void setTaskResultEntry(DynamicObjectType entryTP, DynamicObject pmtstask, DynamicObjectCollection rsEntrys) {
        DynamicObject resentry = this.newDynamicObject(entryTP);
        resentry.set("tasknumber", pmtstask.get("number"));
        resentry.set("taskname", pmtstask.get("name"));
        resentry.set("plantime", pmtstask.get("plantime"));
        resentry.set("estime", pmtstask.get("firststartdate"));
        resentry.set("eetime", pmtstask.get("firstenddate"));
        resentry.set("lstime", pmtstask.get("laststartdate"));
        resentry.set("letime", pmtstask.get("lastenddate"));
        resentry.set("needtime", pmtstask.get("needtime"));
        resentry.set("nestime", pmtstask.get("nfirststartdate"));
        resentry.set("neetime", pmtstask.get("nfirstenddate"));
        resentry.set("nlstime", pmtstask.get("nlaststartdate"));
        resentry.set("nletime", pmtstask.get("nlastenddate"));
        resentry.set("iscpath", pmtstask.get("ismaxpath"));
        resentry.set("issecpath", pmtstask.get("iscrux"));
        rsEntrys.add((Object)resentry);
    }

    private DynamicObject newDynamicObject(DynamicObjectType type) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(type);
    }

    private void updateNeedTime(DynamicObject pmtstask, AbstractPmtsTask task, DynamicObject planParam) {
        long nest = task.getEarlyNeedSTime();
        Calendar nescalendar = Calendar.getInstance();
        nescalendar.setTimeInMillis(nest);
        Date nfirststartdate = nescalendar.getTime();
        pmtstask.set("nfirststartdate", (Object)nescalendar.getTime());
        long nlst = task.getLateNeedSTime();
        Calendar nlscalendar = Calendar.getInstance();
        nlscalendar.setTimeInMillis(nlst);
        Date nlaststartdate = nlscalendar.getTime();
        pmtstask.set("nlaststartdate", (Object)nlaststartdate);
        long neft = task.getEarlyNeedFTime();
        Calendar neftcalendar = Calendar.getInstance();
        neftcalendar.setTimeInMillis(neft);
        Date nfirstenddate = neftcalendar.getTime();
        pmtstask.set("nfirstenddate", (Object)nfirstenddate);
        long nlft = task.getLateNeedFTime();
        Calendar nlftcalendar = Calendar.getInstance();
        nlftcalendar.setTimeInMillis(nlft);
        Date nlastenddate = nlftcalendar.getTime();
        pmtstask.set("nlastenddate", (Object)nlastenddate);
        long nevalue = nlft - neft;
        long nlvalue = nlst - nest;
        if (planParam.getString("caltypegroup").equals("1")) {
            this.updateNeedFloteTime(pmtstask, nlvalue);
        } else if (planParam.getString("caltypegroup").equals("2")) {
            this.updateNeedFloteTime(pmtstask, nevalue);
        } else if (nevalue > nlvalue) {
            this.updateNeedFloteTime(pmtstask, nlvalue);
        } else {
            this.updateNeedFloteTime(pmtstask, nevalue);
        }
    }

    private void updatePlanTime(DynamicObject pmtstask, AbstractPmtsTask task, DynamicObject planParam) {
        long est = task.getEarlyStartTime();
        long lst = task.getLateStartTime();
        long eft = task.getEarlyFinishTime();
        long lft = task.getLateFinishTime();
        Calendar estcalendar = Calendar.getInstance();
        estcalendar.setTimeInMillis(est);
        Date firststartdate = estcalendar.getTime();
        pmtstask.set("firststartdate", (Object)firststartdate);
        Calendar lstcalendar = Calendar.getInstance();
        lstcalendar.setTimeInMillis(lst);
        Date laststartdate = lstcalendar.getTime();
        pmtstask.set("laststartdate", (Object)laststartdate);
        Calendar eftcalendar = Calendar.getInstance();
        eftcalendar.setTimeInMillis(eft);
        Date firstenddate = eftcalendar.getTime();
        pmtstask.set("firstenddate", (Object)firstenddate);
        Calendar lftcalendar = Calendar.getInstance();
        lftcalendar.setTimeInMillis(lft);
        Date lastenddate = lftcalendar.getTime();
        pmtstask.set("lastenddate", (Object)lastenddate);
        long evalue = lft - eft;
        long lvalue = lst - est;
        if (planParam.getString("caltypegroup").equals("1")) {
            this.updateFloteTime(pmtstask, lvalue);
        } else if (planParam.getString("caltypegroup").equals("2")) {
            this.updateFloteTime(pmtstask, evalue);
        } else if (evalue > lvalue) {
            this.updateFloteTime(pmtstask, lvalue);
        } else {
            this.updateFloteTime(pmtstask, evalue);
        }
        if (planParam.getBoolean("isupdatetime") && planParam.getString("crossgroup").equals("1")) {
            pmtstask.set("planstartdate", (Object)firststartdate);
            pmtstask.set("planenddate", (Object)firstenddate);
        } else if (planParam.getBoolean("isupdatetime") && planParam.getString("crossgroup").equals("2")) {
            pmtstask.set("planstartdate", (Object)laststartdate);
            pmtstask.set("planenddate", (Object)lastenddate);
        }
        long difvalue = lst - est;
        if (planParam.getBoolean("iscriticalpath")) {
            if (task.isIskk()) {
                pmtstask.set("ismaxpath", (Object)true);
            } else {
                this.updateCPathByCrucialgroup(difvalue, pmtstask, planParam);
            }
        } else {
            this.updateCPathByCrucialgroup(difvalue, pmtstask, planParam);
        }
    }

    private void updateFloteTime(DynamicObject pmtstask, long value) {
        if (value == 0L) {
            pmtstask.set("ismaxpath", (Object)true);
        } else {
            pmtstask.set("ismaxpath", (Object)false);
        }
        switch (pmtstask.getString("timeunit")) {
            case "1": {
                pmtstask.set("freefloattime", (Object)(value / ONEDAYMS));
                break;
            }
            case "2": {
                pmtstask.set("freefloattime", (Object)(value / (7L * ONEDAYMS)));
                break;
            }
        }
    }

    private void updateNeedFloteTime(DynamicObject pmtstask, long value) {
        switch (pmtstask.getString("timeunit")) {
            case "1": {
                pmtstask.set("floattime", (Object)(value / ONEDAYMS));
                break;
            }
            case "2": {
                pmtstask.set("floattime", (Object)(value / (7L * ONEDAYMS)));
                break;
            }
        }
    }

    public void updateCPathByCrucialgroup(long difvalue, DynamicObject pmtstask, DynamicObject planParam) {
        String name = pmtstask.getString("id");
        if (planParam.getString("crucialgroup").equals("1")) {
            if (difvalue <= planParam.getLong("floattime") * ONEDAYMS) {
                pmtstask.set("ismaxpath", (Object)true);
            } else {
                pmtstask.set("ismaxpath", (Object)false);
            }
        } else {
            pmtstask.set("ismaxpath", (Object)false);
            pmtstask.set("iscrux", (Object)false);
            for (List maxPath : this.maxLs) {
                if (!maxPath.isEmpty() && maxPath.contains(name)) {
                    pmtstask.set("ismaxpath", (Object)true);
                    continue;
                }
                pmtstask.set("ismaxpath", (Object)false);
            }
            for (List secPath : this.secLs) {
                if (!secPath.isEmpty() && secPath.contains(name)) {
                    pmtstask.set("iscrux", (Object)true);
                    continue;
                }
                pmtstask.set("iscrux", (Object)false);
            }
        }
    }

    private void buildMaxPath() {
        String path;
        double p1;
        Map map;
        int i;
        Set<Map> paths = this.ctx.getPaths();
        if (paths.isEmpty()) {
            return;
        }
        List collect = paths.stream().collect(Collectors.toList());
        collect.sort((m1, m2) -> {
            double p1 = Double.parseDouble(m1.get("plantime").toString());
            double p2 = Double.parseDouble(m2.get("plantime").toString());
            return Double.compare(p2, p1);
        });
        HashSet<Map> removeMap = new HashSet<Map>(8);
        for (int i2 = 0; i2 < collect.size(); ++i2) {
            String ipath = (String)((Map)collect.get(i2)).get("path");
            for (int j = collect.size() - 1; j > i2; --j) {
                Map jMap = (Map)collect.get(j);
                String jpath = (String)jMap.get("path");
                if (!ipath.contains(jpath) || ipath.equals(jpath)) continue;
                removeMap.add(jMap);
            }
        }
        if (!removeMap.isEmpty()) {
            Iterator iterator = removeMap.iterator();
            while (iterator.hasNext()) {
                collect.remove(iterator.next());
            }
        }
        Map maxMap = (Map)collect.get(0);
        double maxTime = Double.parseDouble(maxMap.get("plantime").toString());
        double secTime = 0.0;
        for (i = 0; i < collect.size(); ++i) {
            map = (Map)collect.get(i);
            p1 = Double.parseDouble(((Map)collect.get(i)).get("plantime").toString());
            if (maxTime == p1) {
                path = (String)map.get("path");
                this.maxLs.add(Arrays.asList(path.split("_")));
            }
            if (!(p1 < maxTime)) continue;
            secTime = p1;
            break;
        }
        for (i = 0; i < collect.size(); ++i) {
            map = (Map)collect.get(i);
            p1 = Double.parseDouble(map.get("plantime").toString());
            if (secTime == p1) {
                path = (String)map.get("path");
                this.secLs.add(Arrays.asList(path.split("_")));
            }
            if (p1 < secTime) break;
        }
    }
}

