/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.business.task.taskschedule.schedule.steps;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskAoeBuilder;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskAoeCaculator;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskChecker;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskPlanUpdater;
import kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleStep;

public class PmtsTaskScheduleExcutor
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PmtsTaskScheduleExcutor.class);

    public void execute(RequestContext rqctx, Map<String, Object> params) throws KDException {
        if (params.containsKey("params")) {
            PmtsTaskScheduleParamter param = (PmtsTaskScheduleParamter)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)params.get("params")), PmtsTaskScheduleParamter.class);
            PmtsTaskRunTimeInfo ctx = this.getRunTimeInfo(param);
            PmtsTaskHelper.hasBeginning(ctx);
            this.updateProjectDate(ctx, param);
            ArrayList<PmtsTaskScheduleStep> steps = new ArrayList<PmtsTaskScheduleStep>(8);
            PmtsTaskChecker checker = new PmtsTaskChecker(param, ctx);
            steps.add(checker);
            PmtsTaskAoeBuilder aoebuilder = new PmtsTaskAoeBuilder(this, param, ctx);
            steps.add(aoebuilder);
            PmtsTaskAoeCaculator aorcaltor = new PmtsTaskAoeCaculator(this, param, ctx);
            steps.add(aorcaltor);
            PmtsTaskPlanUpdater tpupter = new PmtsTaskPlanUpdater(this, param, ctx);
            steps.add(tpupter);
            for (int i = 0; i < steps.size(); ++i) {
                PmtsTaskScheduleStep step = (PmtsTaskScheduleStep)steps.get(i);
                step.execute();
                if (!ctx.isStop()) continue;
                this.stop();
                break;
            }
        }
    }

    private void updateProjectDate(PmtsTaskRunTimeInfo ctx, PmtsTaskScheduleParamter param) {
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)ctx.getProjectid(), (String)"pmpd_project");
        projectObj.set("preschedate", (Object)new Date());
        projectObj.set("planstarttime", (Object)param.getDatatime());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{projectObj});
    }

    public String getTaskId() {
        return this.taskId;
    }

    private PmtsTaskRunTimeInfo getRunTimeInfo(PmtsTaskScheduleParamter param) {
        long projectid = param.getProjectid();
        long callogid = param.getCallogid();
        long orgid = param.getOrgid();
        PmtsTaskRunTimeInfo ctx = new PmtsTaskRunTimeInfo(this.getTaskId(), projectid, callogid, orgid);
        ctx.setCalByhour(param.isCalbyhour());
        return ctx;
    }
}

