/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ProductionWorkOrderBotpPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] dataEntitys = targetExtDataEntitySet.FindByEntityKey("pom_mftorder");
        HashMap<Long, Long> cache = new HashMap<Long, Long>();
        for (ExtendedDataEntity extendedDataEntity : dataEntitys) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long org = dataEntity.getLong("org_id");
            Long transactionTypeId = cache.computeIfAbsent(org, this::getTransactionTypeId);
            dataEntity.set("transactiontype_id", (Object)transactionTypeId);
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject dynamicObject : collection) {
                BigDecimal qty = dynamicObject.getBigDecimal("qty");
                long baseUnitId = dynamicObject.getLong("baseunit_id");
                long unitId = dynamicObject.getLong("unit_id");
                DynamicObject material = dynamicObject.getDynamicObject("material");
                if (material == null) continue;
                long masterId = material.getLong("masterid_id");
                BigDecimal baseQty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)baseUnitId, (Long)unitId, (Long)masterId, (StringBuilder)new StringBuilder());
                dynamicObject.set("baseqty", (Object)baseQty);
            }
        }
    }

    private long getTransactionTypeId(long orgId) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_transactproduct", (Long)orgId);
        QFilter qFilter = new QFilter("isfault", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("transactiontype", "=", (Object)738166303168232448L));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_transactproduct", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, qFilter});
        return dynamicObject == null ? 0L : dynamicObject.getLong(0);
    }
}

