/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.botp;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.pmc.pmts.helper.ProjectPurchesListPushHelper;

public class PurchesApplyOrderBotpPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] dataEntitys = targetExtDataEntitySet.FindByEntityKey("pm_purapplybill");
        HashSet billTypeIds = Sets.newHashSetWithExpectedSize((int)dataEntitys.length);
        HashMap<Long, Long> applyOrgId2CurrencyId = new HashMap<Long, Long>();
        for (ExtendedDataEntity entity : dataEntitys) {
            DynamicObject dataEntity = entity.getDataEntity();
            billTypeIds.add(dataEntity.getLong("billtype_id"));
            DynamicObject applyOrg = dataEntity.getDynamicObject("org");
            if (applyOrg == null) continue;
            Long currencyId = applyOrgId2CurrencyId.computeIfAbsent(applyOrg.getLong("id"), ProjectPurchesListPushHelper::getCurrency);
            dataEntity.set("currency_id", (Object)currencyId);
        }
        Map<Long, DynamicObject> bizTypeMap = ProjectPurchesListPushHelper.getDefaultBizType(billTypeIds);
        Map<Long, Long> lineTypeMap = ProjectPurchesListPushHelper.getDefaultLineType(bizTypeMap);
        for (ExtendedDataEntity entity : dataEntitys) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObject bizType = dataEntity.getDynamicObject("biztype");
            if (bizType == null) {
                long billTypeId = dataEntity.getLong("billtype_id");
                bizType = bizTypeMap.get(billTypeId);
            }
            if (bizType == null) continue;
            long bizTypeId = bizType.getLong("id");
            dataEntity.set("biztype_id", (Object)bizTypeId);
            Long lineTypeId = lineTypeMap.get(bizTypeId);
            if (lineTypeId == null) continue;
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject dynamicObject : collection) {
                dynamicObject.set("linetype_id", (Object)lineTypeId);
            }
        }
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
    }
}

