/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.helper;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class ProjectPurchesListPushHelper {
    public static Map<Long, DynamicObject> getDefaultBizType(Set<Long> billTypeIds) {
        int size = billTypeIds.size();
        LinkedHashMap billTypeId2BizTypeIds = Maps.newLinkedHashMapWithExpectedSize((int)size);
        HashSet allBizTypeId = new HashSet();
        for (Long billTypeId : billTypeIds) {
            DynamicObject typeParameter;
            Object entryentityObj;
            Object billTypeParameter = SystemParamServiceHelper.getBillTypeParameter((String)"pm_purapplybill", (String)"pm_billtypeparameter", (long)billTypeId);
            if (!(billTypeParameter instanceof DynamicObject) || !((entryentityObj = (typeParameter = (DynamicObject)billTypeParameter).get("entryentity")) instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection collection = (DynamicObjectCollection)entryentityObj;
            Set bizTypeIds = collection.stream().filter(dynamicObject -> dynamicObject.getBoolean("isdefault")).map(dynamicObject -> dynamicObject.get("biztypenumber.id")).collect(Collectors.toSet());
            billTypeId2BizTypeIds.put(billTypeId, bizTypeIds);
            allBizTypeId.addAll(bizTypeIds);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", allBizTypeId), new QFilter("enable", "=", (Object)"1")};
        Map enableBaseDatas = BusinessDataServiceHelper.loadFromCache((String)"bd_biztype", (QFilter[])filters);
        if (MapUtils.isEmpty((Map)enableBaseDatas)) {
            return Collections.emptyMap();
        }
        LinkedHashMap billTypeId2BizType = Maps.newLinkedHashMapWithExpectedSize((int)size);
        block1: for (Map.Entry entry : billTypeId2BizTypeIds.entrySet()) {
            Set bizTypeIds = (Set)entry.getValue();
            for (Object bizTypeId : bizTypeIds) {
                DynamicObject bizType = (DynamicObject)enableBaseDatas.get(bizTypeId);
                if (bizType == null) continue;
                billTypeId2BizType.put(entry.getKey(), bizType);
                continue block1;
            }
        }
        return billTypeId2BizType;
    }

    public static Map<Long, Long> getDefaultLineType(Map<Long, DynamicObject> bizTypeMap) {
        if (bizTypeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap bizTypeId2LineTypeId = Maps.newLinkedHashMapWithExpectedSize((int)bizTypeMap.size());
        for (DynamicObject bizType : bizTypeMap.values()) {
            DynamicObjectCollection collection = bizType.getDynamicObjectCollection("linetypeentry");
            Optional<DynamicObject> optional = collection.stream().filter(dynamicObject -> dynamicObject.getBoolean("isdefault")).findFirst();
            if (!optional.isPresent()) continue;
            long lingTypeId = optional.get().getLong("linetypeid.id");
            bizTypeId2LineTypeId.put(bizType.getLong("id"), lingTypeId);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", bizTypeId2LineTypeId.values()), new QFilter("enable", "=", (Object)"1")};
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (String)"id", (QFilter[])filters);
        Set enableIds = objectMap.keySet();
        bizTypeId2LineTypeId.entrySet().removeIf(entry -> !enableIds.contains(entry.getValue()));
        return bizTypeId2LineTypeId;
    }

    public static long getCurrency(long orgId) {
        Map map;
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return (Long)map.get("baseCurrencyID");
        }
        return 0L;
    }
}

