/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.util.DateUtil;

public class TaskReportSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TaskReportSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("actualpercent");
        e.getFieldKeys().add("actualenddate");
        e.getFieldKeys().add("actualstartdate");
        e.getFieldKeys().add("actualperiod");
        e.getFieldKeys().add("needperiod");
        e.getFieldKeys().add("periodprecent");
        e.getFieldKeys().add("actualhour");
        e.getFieldKeys().add("needhour");
        e.getFieldKeys().add("hourprecent");
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("reporttime");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryid");
        e.getFieldKeys().add("docname");
        e.getFieldKeys().add("docnumber");
        e.getFieldKeys().add("doctype");
        e.getFieldKeys().add("docplandate");
        e.getFieldKeys().add("donestatus");
        e.getFieldKeys().add("uploaddate");
        e.getFieldKeys().add("attachment");
        e.getFieldKeys().add("reporttype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject dyobj : e.getDataEntities()) {
            dyobj.set("reporttime", (Object)new Date());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dyo : e.getDataEntities()) {
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)dyo.getDynamicObject("task").getPkValue(), (String)"pmts_task");
            this.updateTaskStatus(dyo, task);
            this.updateTaskDocEntry(dyo, task);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreValidation", "true");
            option.setVariableValue("ignorewarn", "true");
            OperationResult result = SaveServiceHelper.saveOperate((String)"save", (String)"pmts_task", (DynamicObject[])new DynamicObject[]{task}, (OperateOption)option);
            if (!result.isSuccess()) {
                logger.error("\u6c47\u62a5\u5931\u8d25\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25");
                continue;
            }
            ArrayList<Long> versionTaskIds = new ArrayList<Long>(16);
            DynamicObjectCollection versionTasks = QueryServiceHelper.query((String)"pmts_task", (String)"id", (QFilter[])new QFilter("initid", "=", task.getPkValue()).toArray());
            for (DynamicObject versionTask : versionTasks) {
                versionTaskIds.add(versionTask.getLong("id"));
            }
            if (versionTaskIds.isEmpty()) continue;
            DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])versionTaskIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task"));
            this.updateVersionTasks(dyo, tasks);
        }
    }

    private void updateVersionTasks(DynamicObject dyobj, DynamicObject[] tasks) {
        for (DynamicObject taskobj : tasks) {
            this.updateTaskStatus(dyobj, taskobj);
            this.updateTaskDocEntry(dyobj, taskobj);
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
    }

    private void updateTaskStatus(DynamicObject dyobj, DynamicObject taskobj) {
        taskobj.set("actualenddate", dyobj.get("actualenddate"));
        taskobj.set("actualstartdate", dyobj.get("actualstartdate"));
        switch (dyobj.getString("reporttype")) {
            case "1": {
                taskobj.set("finishpercent", dyobj.get("actualpercent"));
                break;
            }
            case "2": {
                taskobj.set("actualtime", dyobj.get("actualperiod"));
                taskobj.set("needtime", dyobj.get("needperiod"));
                taskobj.set("finishpercent", dyobj.get("periodprecent"));
                break;
            }
            case "3": {
                taskobj.set("actualhours", dyobj.get("actualhour"));
                taskobj.set("needhours", dyobj.get("needhour"));
                taskobj.set("finishpercent", dyobj.get("hourprecent"));
                break;
            }
        }
        if (taskobj.getBigDecimal("finishpercent").compareTo(new BigDecimal(100)) >= 0) {
            taskobj.set("executestatus", (Object)"4");
        } else {
            taskobj.set("executestatus", (Object)"2");
            if (dyobj.getString("reporttype").equals("1")) {
                this.changeActualDate(taskobj);
            }
        }
    }

    private void changeActualDate(DynamicObject taskobj) {
        BigDecimal plantime = taskobj.getBigDecimal("plantime");
        BigDecimal finishpercent = taskobj.getBigDecimal("finishpercent");
        finishpercent = finishpercent.divide(new BigDecimal(100));
        if (plantime != null) {
            BigDecimal actualtime = plantime.multiply(finishpercent);
            Date actualStartDate = taskobj.getDate("actualstartdate");
            Double seconds = actualtime.doubleValue() * 24.0 * 60.0 * 60.0;
            Date actualEndDate = DateUtil.addSecond((Date)actualStartDate, (long)seconds.longValue());
            taskobj.set("actualdate", (Object)actualEndDate);
        }
    }

    private void dealAlterEntryAtt(DynamicObjectCollection entrys, ORM orm, DynamicObjectCollection taskdocs, DynamicObjectType type) {
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject entry : entrys) {
            String entryid = entry.getString("id");
            String docnumber = entry.getString("docnumber");
            String docname = entry.getString("docname");
            String doctype = entry.getString("doctype");
            String donestatus = entry.getString("donestatus");
            Date docplandate = entry.getDate("docplandate");
            DynamicObjectCollection rpattachments = entry.getDynamicObjectCollection("attachment");
            ArrayList pages = new ArrayList(8);
            rpattachments.forEach(pg -> pages.add(pg.getDynamicObject(1).getPkValue()));
            DynamicObject[] rpatts = BusinessDataServiceHelper.load((Object[])pages.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_attachment"));
            List<DynamicObject> rpattachment = Arrays.asList(rpatts);
            for (DynamicObject att : rpattachment) {
                HashMap<String, Object> attch = new HashMap<String, Object>();
                attch.put("name", att.getString("name"));
                attch.put("uid", UUID.randomUUID().toString());
                attch.put("url", att.get("url"));
                attch.put("size", att.get("size"));
                attch.put("lastModified", null);
                attch.put("status", "success");
                attachments.add(attch);
            }
            List<DynamicObject> dyos = this.saveAttachmentToTask(attachments, entryid);
            ArrayList ids = new ArrayList(8);
            dyos.forEach(dy -> ids.add(dy.getPkValue()));
            DynamicObject[] dyobjes = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_attachment"));
            TaskReportConsumer trc = new TaskReportConsumer(true, docnumber, entryid, type, dyobjes);
            trc.setOrm(orm);
            taskdocs.forEach((Consumer)trc);
            if (!trc.isIsnewline()) continue;
            DynamicObjectCollection docsatt = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : dyos) {
                DynamicObject aoj = this.getDynamicObject(type);
                aoj.set("fpkid", (Object)this.getLongId(type));
                aoj.set("fbasedataid", (Object)dynamicObject);
                aoj.set("fbasedataid_id", dynamicObject.getPkValue());
                docsatt.add((Object)aoj);
            }
            DynamicObject taskdoc = taskdocs.addNew();
            taskdoc.set("docnumber", (Object)docnumber);
            taskdoc.set("docname", (Object)docname);
            taskdoc.set("donestatus", (Object)donestatus);
            taskdoc.set("doctype", (Object)doctype);
            taskdoc.set("docplandate", (Object)docplandate);
            taskdoc.set("uploaddate", (Object)new Date());
            taskdoc.set("uploadperson", (Object)RequestContext.get().getCurrUserId());
            taskdoc.set("reportid", (Object)entryid);
            taskdoc.set("attachment", (Object)docsatt);
        }
    }

    private List<DynamicObject> saveAttachmentToTask(List<Map<String, Object>> attachments, String entryid) {
        return AttachmentFieldServiceHelper.saveAttachments(null, (String)entryid, attachments);
    }

    private void updateTaskDocEntry(DynamicObject dyo, DynamicObject task) {
        DynamicObjectCollection taskdocs = task.getDynamicObjectCollection("documententry");
        MainEntityType tp = MetadataServiceHelper.getDataEntityType((String)"pmts_task");
        AttachmentProp ap = (AttachmentProp)tp.getAllFields().get("attachment");
        DynamicObjectCollection entrys = dyo.getDynamicObjectCollection("entryentity");
        ORM orm = ORM.create();
        this.dealAlterEntryAtt(entrys, orm, taskdocs, ap._collectionItemPropertyType);
    }

    private DynamicObject getDynamicObject(DynamicObjectType type) {
        return ORM.create().newDynamicObject(type);
    }

    private long getLongId(DynamicObjectType type) {
        return ORM.create().genLongId((IDataEntityType)type);
    }

    public static class TaskReportConsumer
    implements Consumer<DynamicObject> {
        private boolean isnewline;
        private String docnumber;
        private String entryid;
        private DynamicObjectType type;
        private DynamicObject[] dyos;
        private ORM orm;

        public TaskReportConsumer(boolean isnewline, String docnumber, String entryid, DynamicObjectType type, DynamicObject[] dyobjes) {
            this.isnewline = isnewline;
            this.docnumber = docnumber;
            this.entryid = entryid;
            this.type = type;
            this.dyos = dyobjes;
        }

        @Override
        public void accept(DynamicObject doc) {
            ArrayList ids = new ArrayList(8);
            if (doc.getString("docnumber").equalsIgnoreCase(this.docnumber)) {
                DynamicObjectCollection docatt = doc.getDynamicObjectCollection("attachment");
                if (docatt == null || docatt.isEmpty()) {
                    return;
                }
                ArrayList pages = new ArrayList(4);
                ArrayList localids = new ArrayList(4);
                docatt.forEach(pg -> {
                    if (Objects.nonNull(pg.get(1))) {
                        pages.add(pg.getDynamicObject(1).getPkValue());
                    }
                    if (Objects.nonNull(pg.get(0)) && Objects.isNull(pg.get(1))) {
                        localids.add(pg.getLong(0));
                    }
                });
                DynamicObject[] tsatts = BusinessDataServiceHelper.load((Object[])pages.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_attachment"));
                Arrays.asList(tsatts).forEach(att -> {
                    String pageid;
                    String string = pageid = att.get("pageid") == null ? "" : att.getString("pageid");
                    if (pageid.equalsIgnoreCase(this.entryid)) {
                        ids.add(att.getPkValue());
                    }
                });
                DeleteServiceHelper.delete((IDataEntityType)this.type, (Object[])localids.toArray());
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_attachment"), (Object[])ids.toArray());
                if (this.dyos == null) {
                    docatt.removeIf(rmatt -> Objects.nonNull(rmatt.get(0)) && Objects.isNull(rmatt.get(1)));
                    docatt.sort((do1, do2) -> do1.getDynamicObject(1).getDate("modifytime").compareTo(do2.getDynamicObject(1).getDate("modifytime")));
                    doc.set("uploadperson", ((DynamicObject)docatt.get(0)).getDynamicObject(1).get("creator"));
                    doc.set("uploaddate", ((DynamicObject)docatt.get(0)).getDynamicObject(1).get("modifytime"));
                    return;
                }
                for (DynamicObject dynamicObject : this.dyos) {
                    DynamicObject aoj = docatt.addNew();
                    aoj.set("fpkid", (Object)this.genLongId(this.type));
                    aoj.set("fbasedataid", (Object)dynamicObject);
                    aoj.set("fbasedataid_id", dynamicObject.getPkValue());
                }
                doc.set("uploaddate", (Object)new Date());
                doc.set("uploadperson", (Object)RequestContext.get().getCurrUserId());
                this.setIsnewline(false);
            }
        }

        public boolean isIsnewline() {
            return this.isnewline;
        }

        public void setIsnewline(boolean isnewline) {
            this.isnewline = isnewline;
        }

        public ORM getOrm() {
            return this.orm;
        }

        public void setOrm(ORM orm) {
            this.orm = orm;
        }

        public long genLongId(DynamicObjectType type) {
            return this.orm.genLongId((IDataEntityType)type);
        }
    }
}

