/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.util.DateUtil;
import kd.pmc.pmts.opplugin.TaskReportSubmitOp;

public class TaskReportUnSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TaskReportUnSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("actualpercent");
        e.getFieldKeys().add("actualenddate");
        e.getFieldKeys().add("actualstartdate");
        e.getFieldKeys().add("actualperiod");
        e.getFieldKeys().add("needperiod");
        e.getFieldKeys().add("periodprecent");
        e.getFieldKeys().add("actualhour");
        e.getFieldKeys().add("needhour");
        e.getFieldKeys().add("hourprecent");
        e.getFieldKeys().add("task");
        e.getFieldKeys().add("reporttime");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryid");
        e.getFieldKeys().add("docname");
        e.getFieldKeys().add("docnumber");
        e.getFieldKeys().add("doctype");
        e.getFieldKeys().add("docplandate");
        e.getFieldKeys().add("donestatus");
        e.getFieldKeys().add("uploaddate");
        e.getFieldKeys().add("reporttype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dyo : e.getDataEntities()) {
            DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)dyo.getDynamicObject("task").getPkValue(), (String)"pmts_task");
            QFilter statusfilter = new QFilter("billstatus", "=", (Object)"B");
            QFilter taskfilter = new QFilter("task", "=", dyo.getDynamicObject("task").getPkValue());
            QFilter datefilter = new QFilter("reporttime", "<", dyo.get("reporttime"));
            String selectfileds = "reporttype,actualpercent,actualenddate,actualperiod,needperiod,periodprecent,actualhour,needhour,hourprecent";
            QFilter[] filters = new QFilter[]{statusfilter, taskfilter, datefilter};
            String orders = "REPORTTIME DESC";
            DynamicObject[] prevtaskrp = BusinessDataServiceHelper.load((String)"pmts_taskreportbill", (String)selectfileds, (QFilter[])filters, (String)orders);
            if (prevtaskrp.length > 0) {
                DynamicObject dyobj = prevtaskrp[0];
                task.set("actualenddate", dyobj.get("actualenddate"));
                switch (dyobj.getString("reporttype")) {
                    case "1": {
                        task.set("finishpercent", dyobj.get("actualpercent"));
                        break;
                    }
                    case "2": {
                        task.set("actualtime", dyobj.get("actualperiod"));
                        task.set("needtime", dyobj.get("needperiod"));
                        task.set("finishpercent", dyobj.get("periodprecent"));
                        break;
                    }
                    case "3": {
                        task.set("actualhours", dyobj.get("actualhour"));
                        task.set("needhours", dyobj.get("needhour"));
                        task.set("finishpercent", dyobj.get("hourprecent"));
                        break;
                    }
                }
                if (task.getBigDecimal("finishpercent").compareTo(new BigDecimal(100)) >= 0) {
                    task.set("executestatus", (Object)"4");
                } else {
                    task.set("executestatus", (Object)"2");
                    if (dyobj.getString("reporttype").equals("1")) {
                        this.changeActualDate(task);
                    }
                }
            }
            this.updateTaskDocEntry(dyo, task);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignoreValidation", "true");
            option.setVariableValue("ignorewarn", "true");
            OperationResult result = SaveServiceHelper.saveOperate((String)"save", (String)"pmts_task", (DynamicObject[])new DynamicObject[]{task}, (OperateOption)option);
            if (!result.isSuccess()) {
                logger.error("\u6c47\u62a5\u5931\u8d25\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25");
            }
            this.deleteReportRows(task);
        }
    }

    private void changeActualDate(DynamicObject taskobj) {
        BigDecimal plantime = taskobj.getBigDecimal("plantime");
        BigDecimal finishpercent = taskobj.getBigDecimal("finishpercent");
        finishpercent = finishpercent.divide(new BigDecimal(100));
        if (plantime != null) {
            BigDecimal actualtime = plantime.multiply(finishpercent);
            Date actualStartDate = taskobj.getDate("actualstartdate");
            Double seconds = actualtime.doubleValue() * 24.0 * 60.0 * 60.0;
            Date actualEndDate = DateUtil.addSecond((Date)actualStartDate, (long)seconds.longValue());
            taskobj.set("actualdate", (Object)actualEndDate);
        }
    }

    private void deleteReportRows(DynamicObject task) {
        DynamicObject currtask = BusinessDataServiceHelper.loadSingle((Object)task.getPkValue(), (String)"pmts_task", (String)"documententry,documententry.attachment,documententry.reportid");
        DynamicObjectCollection currentrys = currtask.getDynamicObjectCollection("documententry");
        ArrayList<Object> ids = new ArrayList<Object>(8);
        for (DynamicObject curentry : currentrys) {
            if (curentry.getLong("reportid") <= 0L) continue;
            boolean isneeddel = true;
            DynamicObjectCollection atts = curentry.getDynamicObjectCollection("attachment");
            for (DynamicObject at : atts) {
                if (!Objects.nonNull(at.get("fbasedataid"))) continue;
                isneeddel = false;
                break;
            }
            if (!isneeddel) continue;
            ids.add(curentry.getPkValue());
        }
        DeleteServiceHelper.delete((IDataEntityType)task.getDynamicObjectCollection("documententry").getDynamicObjectType(), (Object[])ids.toArray());
    }

    private void updateTaskDocEntry(DynamicObject dyo, DynamicObject task) {
        DynamicObjectCollection taskdocs = task.getDynamicObjectCollection("documententry");
        MainEntityType tp = MetadataServiceHelper.getDataEntityType((String)"pmts_task");
        AttachmentProp ap = (AttachmentProp)tp.getAllFields().get("attachment");
        DynamicObjectCollection entrys = dyo.getDynamicObjectCollection("entryentity");
        ORM orm = ORM.create();
        this.dealAlterEntryAtt(entrys, orm, taskdocs, ap._collectionItemPropertyType);
    }

    private void dealAlterEntryAtt(DynamicObjectCollection entrys, ORM orm, DynamicObjectCollection taskdocs, DynamicObjectType type) {
        for (DynamicObject entry : entrys) {
            String entryid = entry.getString("id");
            String docnumber = entry.getString("docnumber");
            TaskReportSubmitOp.TaskReportConsumer trc = new TaskReportSubmitOp.TaskReportConsumer(true, docnumber, entryid, type, null);
            trc.setOrm(orm);
            taskdocs.forEach((Consumer)trc);
            taskdocs.removeIf(doc -> doc.getLong("reportid") > 0L && doc.getDynamicObjectCollection("attachment").isEmpty());
        }
    }
}

