/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin.release;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmts.business.helper.ReleaseHelper;

public class ReleaseCodeRuleOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        if (this.validateEntityType() && this.validateOperateMeta()) {
            List<Object> pks = Stream.of(objs).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            Map<Object, Integer> oldVersions = this.queryVersion(pks);
            for (DynamicObject obj : objs) {
                Integer oldVersion = oldVersions.get(obj.getPkValue());
                Integer version = obj.getInt("version");
                if (oldVersion != null && version.intValue() == oldVersion.intValue()) continue;
                DynamicObject licensegroup = obj.getDynamicObject("licensegroup");
                String licOrgNo = licensegroup == null ? "" : licensegroup.getString("number");
                Object licOrgPk = licensegroup == null ? Long.valueOf(0L) : licensegroup.getPkValue();
                String billNo = ReleaseHelper.createCodeNumber((String)licOrgNo, (Object)licOrgPk, (Integer)version);
                obj.set("billno", (Object)billNo);
            }
        }
    }

    private boolean validateEntityType() {
        return this.billEntityType instanceof BillEntityType;
    }

    private boolean validateOperateMeta() {
        String operateType = (String)this.operateMeta.get("type");
        return "save".equals(operateType) || "submit".equals(operateType);
    }

    public Map<Object, Integer> queryVersion(List<Object> pks) {
        QFilter filter = new QFilter("id", "in", pks);
        DynamicObjectCollection obj = QueryServiceHelper.query((String)this.billEntityType.getName(), (String)"id,version", (QFilter[])new QFilter[]{filter});
        return obj.stream().collect(Collectors.toMap(i -> i.get(0), i -> i.getInt(1)));
    }
}

