/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.opplugin.workbench;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.servicehelper.botp.ConvertServiceHelper;

public class MaterialRequestListAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("materialplan");
        e.getFieldKeys().add("materialplan.materialattr");
        e.getFieldKeys().add("requiretypeid");
        e.getFieldKeys().add("requiretypeid.directgenerate");
        e.getFieldKeys().add("requiretypeid.reveridentif");
        e.getFieldKeys().add("requiretypeid.specialidentif");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities;
        for (DynamicObject entity : entities = e.getDataEntities()) {
            String materialattr;
            Boolean directGenrate = entity.getBoolean("requiretypeid.directgenerate");
            if (!directGenrate.booleanValue()) continue;
            HashMap<String, String> typeToOperationCode = new HashMap<String, String>(){
                {
                    this.put("10030", "pom_mftorder");
                    this.put("10040", "pm_purapplybill");
                    this.put("10050", "om_mftorder");
                }
            };
            DynamicObject materialPlan = entity.getDynamicObject("materialplan");
            if (materialPlan == null || !StringUtils.isNotBlank((CharSequence)(materialattr = materialPlan.getString("materialattr"))) || !typeToOperationCode.containsKey(materialattr)) continue;
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("pmts_materialreqlist");
            pushArgs.setTargetEntityNumber(typeToOperationCode.getOrDefault(materialattr, ""));
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>(1);
            ListSelectedRow listSelectedRow = new ListSelectedRow(entity.getPkValue());
            list.add(listSelectedRow);
            pushArgs.setSelectedRows(list);
            ConvertOperationResult result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            if (result.isSuccess()) continue;
            this.operationResult.setShowMessage(true);
            this.operationResult.addErrorInfo(MaterialRequestListAuditOp.buildMultiErrorInfo(entity, String.format(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u624b\u5de5\u5173\u8054\u751f\u6210\u3002", (String)"MaterialRequestListAuditOp_0", (String)"mmc-pmts-opplugin", (Object[])new Object[0]), result.getMessage())));
        }
    }

    public static OperateErrorInfo buildMultiErrorInfo(DynamicObject extendedDataEntity, String errorMsg) {
        ValidationErrorInfo errorInfo = new ValidationErrorInfo();
        errorInfo.setPkValue(extendedDataEntity.getPkValue());
        errorInfo.setErrorCode(extendedDataEntity.getDataEntityType().getName());
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setMessage(String.format("%1$s\uff1a  %2$s", extendedDataEntity.getString("billno"), errorMsg));
        return errorInfo;
    }
}

