/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.validator.release;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;

public class EquipmentEnsureReleaseValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        ArrayList allProjectpKs = new ArrayList(4);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection projects = obj.getDynamicObjectCollection("projects");
            List projectIds = projects.stream().map(i -> i.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (projectIds.isEmpty()) {
                return;
            }
            allProjectpKs.addAll(projectIds);
        }
        Map proStatus = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"ProjectReleasableService", (String)"queryAllOrderOfProjectState", (Object[])new Object[]{allProjectpKs});
        if (CollectionUtils.isEmpty((Map)proStatus)) {
            return;
        }
        this.addErrorMsg(entities, proStatus);
    }

    public void addErrorMsg(ExtendedDataEntity[] entities, Map<Long, Boolean> proStatus) {
        for (ExtendedDataEntity entity : entities) {
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection projects = obj.getDynamicObjectCollection("projects");
            Boolean flag = Boolean.TRUE;
            for (DynamicObject project : projects) {
                if (!flag.booleanValue()) break;
                Long projectId = project.getLong("fbasedataid_id");
                Boolean state = proStatus.get(projectId);
                if (state == null) continue;
                flag = state;
            }
            if (flag.booleanValue()) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u653e\u884c\u5931\u8d25\uff0c\u68c0\u4fee\u5de5\u5355\u5fc5\u987b\u4e3a\u5b8c\u5de5\u3001\u4fdd\u7559\u3001\u53d6\u6d88\u6216\u4f5c\u5e9f\u3002", (String)"EquipmentEnsureReleaseValidator_0", (String)"mmc-pmts-opplugin", (Object[])new Object[0]));
        }
    }
}

