/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.validator.release;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class EquipmentReleaseValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        ORM orm = ORM.create();
        for (ExtendedDataEntity entity : entities) {
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection projects = obj.getDynamicObjectCollection("projects");
            List<Long> projectIds = projects.stream().map(i -> i.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (projectIds.isEmpty()) {
                return;
            }
            int count = this.countMroswsProject(orm, projectIds, "pom_mrosws", "project");
            if (count > 0) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u201c\u8865\u5145\u5de5\u4f5c\u5355\u201d\u3002", (String)"EquipmentReleaseValidator_0", (String)"mmc-pmts-opplugin", (Object[])new Object[0]));
            }
            if ((count = this.countMroswsProject(orm, projectIds, "pom_mronrc", "treeentryentity.project")) <= 0) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u7684\u201c\u975e\u4f8b\u884c\u5de5\u5361\u201d\u3002", (String)"EquipmentReleaseValidator_1", (String)"mmc-pmts-opplugin", (Object[])new Object[0]));
        }
    }

    protected int countMroswsProject(ORM orm, List<Long> projectPk, String entityNum, String field) {
        QFilter qFilter = new QFilter(field, "in", projectPk);
        if ("pom_mrosws".equals(entityNum)) {
            QFilter statusFilter = new QFilter("billentry.entrystatus", "=", (Object)"A");
            statusFilter.or("billentry.entrystatus", "=", (Object)"B");
            qFilter.and(statusFilter);
        } else {
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"A");
            statusFilter.or("billstatus", "=", (Object)"B");
            qFilter.and(statusFilter);
            qFilter.and("entitytype", "=", (Object)"pom_mronrc");
        }
        return orm.count("countMroswsProject", entityNum, qFilter.toArray());
    }
}

