/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pmts.mservice;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.ORM;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pmts.mservice.api.ITaskScheduleService;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;

public class TaskScheduleServiceImpl
implements ITaskScheduleService {
    private static Log logger = LogFactory.getLog(TaskScheduleServiceImpl.class);

    public Object runTaskSchedule(long orgId, long scmId, long projectid, Set<Long> wbsId, long plantype, String pageid) {
        ArrayList<DynamicObject> detailobjs = new ArrayList<DynamicObject>(8);
        DynamicObject tslObj = BusinessDataServiceHelper.newDynamicObject((String)"pmts_taskschedule_log");
        MainEntityType mEntity = MetadataServiceHelper.getDataEntityType((String)"pmts_taskschedule_log");
        EntryProp type = (EntryProp)mEntity.getProperties().get((Object)"entryentity");
        DynamicObjectType entrytype = type.getDynamicCollectionItemPropertyType();
        Long id = this.genLongId("pmts_taskschedule_log");
        tslObj.set("id", (Object)id);
        String number = CodeRuleServiceHelper.getNumber((String)"pmts_taskschedule_log", (DynamicObject)tslObj, (String)String.valueOf(orgId));
        tslObj.set("number", (Object)number);
        tslObj.set("scheme", (Object)scmId);
        tslObj.set("org", (Object)orgId);
        tslObj.set("datatime", (Object)new Date());
        tslObj.set("excutor", (Object)RequestContext.get().getCurrUserId());
        tslObj.set("calstatus", (Object)"1");
        tslObj.set("starttime", (Object)new Date());
        tslObj.set("status", (Object)"A");
        tslObj.set("enable", (Object)"1");
        DynamicObjectCollection tslEntrys = tslObj.getDynamicObjectCollection("entryentity");
        DynamicObject tslEntry = this.newDynamicObject(entrytype);
        tslEntry.set("project", (Object)projectid);
        PmtsTaskScheduleParamter pmtsParam = new PmtsTaskScheduleParamter();
        DynamicObject taskSecheme = BusinessDataServiceHelper.loadSingle((Object)scmId, (String)"pmts_taskscheme");
        DynamicObject detailObj = this.newDynamicObject("pmts_taskschedule_detail");
        long detailid = this.genLongId("pmts_taskschedule_detail");
        detailObj.set("id", (Object)detailid);
        detailObj.set("project", (Object)projectid);
        detailObj.set("org", (Object)orgId);
        pmtsParam.setDatatime(new Date().getTime());
        pmtsParam.setPlanparam(taskSecheme.getLong("id"));
        if (Objects.nonNull(taskSecheme.get("caltype")) && StringUtils.equals((CharSequence)taskSecheme.getString("caltype"), (CharSequence)"2")) {
            pmtsParam.setCalbyhour(true);
        }
        pmtsParam.setProjectid(projectid);
        pmtsParam.setOrgid(orgId);
        pmtsParam.setDelaytype(taskSecheme.getString("calendargroup"));
        pmtsParam.setLogictype(taskSecheme.getString("logicgroup"));
        pmtsParam.setIsusehopetime(taskSecheme.getBoolean("isexpectdate"));
        pmtsParam.setCrossgroup(taskSecheme.getString("crossgroup"));
        pmtsParam.setStartTime(System.currentTimeMillis());
        pmtsParam.setCallogid(id.longValue());
        pmtsParam.setPlanTypeid(plantype);
        pmtsParam.setWbsid(wbsId);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("pmts");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName("PmtsTask Schedule");
        String objid = UUID.randomUUID().toString();
        jobInfo.setId(objid);
        jobInfo.setRunByLang(Lang.get());
        String taskId = String.valueOf(this.genDBLongId("T_SCH_TASK"));
        jobInfo.setTaskId(taskId);
        jobInfo.setTaskClassname("kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleExcutor");
        HashMap<String, PmtsTaskScheduleParamter> params = new HashMap<String, PmtsTaskScheduleParamter>();
        params.put("params", pmtsParam);
        jobInfo.setParams(params);
        StringBuilder numBd = new StringBuilder();
        DecimalFormat df = new DecimalFormat("00");
        numBd.append(number).append("_").append(df.format(1L));
        detailObj.set("number", (Object)numBd.toString());
        detailObj.set("calclog", (Object)id);
        detailObj.set("taskid", (Object)taskId);
        detailObj.set("status", (Object)"A");
        detailObj.set("enable", (Object)"1");
        detailobjs.add(detailObj);
        tslEntry.set("detail", detailObj.getPkValue());
        tslEntry.set("taskid", (Object)taskId);
        tslEntrys.add((Object)tslEntry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tslObj});
        SaveServiceHelper.save((DynamicObject[])detailobjs.toArray(new DynamicObject[detailobjs.size()]));
        if (StringUtils.isBlank((CharSequence)pageid)) {
            JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
            String o = jobDispatcherProxy.dispatch(jobInfo);
            return o;
        }
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        logger.info("----------pggeid" + pageid);
        IFormView view = SessionManager.getCurrent().getView(pageid);
        logger.info("----------\u7236\u754c\u9762" + view.getEntityId());
        jobFormInfo.setParentPageId(pageid);
        FormViewPluginProxy service = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        IFormPlugin workTaskList = service.getPlugIns().stream().filter(p -> p.getPluginName().contains("WorkTaskList")).findFirst().get();
        if (Objects.isNull(workTaskList)) {
            logger.info("---------\u63d2\u4ef6\u4e3a\u7a7a" + view.getEntityId());
        }
        CloseCallBack closeCallBack = new CloseCallBack(workTaskList, "taskcloseback");
        jobFormInfo.setCaption("TASKSCHEDULE");
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.pmc.pmts.formplugin.base.TaskScheduleClickPlugin");
        TaskScheduleServiceImpl.dispatch(jobFormInfo, view, id);
        return null;
    }

    private DynamicObject newDynamicObject(DynamicObjectType type) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(type);
    }

    private DynamicObject newDynamicObject(String types) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(types);
    }

    private long genLongId(String type) {
        ORM orm = ORM.create();
        return orm.genLongId(type);
    }

    private long genDBLongId(String type) {
        return DB.genLongId((String)type);
    }

    public static void dispatch(JobFormInfo jobFormInfo, IFormView view, Long id) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmts_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        logger.info("----------ServiceAppId" + view.getFormShowParameter().getServiceAppId());
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        showParameter.getCustomParams().put("tasklogid", id);
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        logger.info("----------jobInfoStr" + jobInfoStr);
        showParameter.getCustomParams().put("pmts_clientjobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }
}

