/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.UnitEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class ProjectDeliverablesBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeSets = e.getChangeSet();
        ChangeData changeSet = changeSets[0];
        DynamicObject dataEntity = changeSet.getDataEntity();
        Object newValueObj = changeSet.getNewValue();
        Object oldValueObj = changeSet.getOldValue();
        switch (name) {
            case "deliverytype": {
                if (null == oldValueObj || null == newValueObj || StringUtils.equals((CharSequence)newValueObj.toString(), (CharSequence)oldValueObj.toString())) break;
                String newValue = newValueObj.toString();
                if (StringUtils.equals((CharSequence)"B", (CharSequence)newValue)) {
                    dataEntity.set("productname", null);
                    dataEntity.set("producttype", null);
                    dataEntity.set("materialno", null);
                    dataEntity.set("unit", null);
                    dataEntity.set("qty", null);
                } else {
                    dataEntity.set("filename", null);
                    dataEntity.set("filecontent", null);
                }
                this.getView().updateView();
                break;
            }
            case "attachment": {
                BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", changeSet.getRowIndex());
                if (Objects.nonNull(newValueObj)) {
                    DynamicObjectCollection attach = (DynamicObjectCollection)newValueObj;
                    BigDecimal atsize = new BigDecimal(attach.size());
                    if (atsize.compareTo(qty) > 0) {
                        this.getModel().setValue("qty", (Object)attach.size(), changeSet.getRowIndex());
                        this.getModel().setValue("finishmark", (Object)"1", changeSet.getRowIndex());
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u6587\u4ef6\u6570\u5927\u4e8e\u5f53\u524d\u5206\u5f55\u6570\u91cf\uff0c\u9ed8\u8ba4\u53d6\u9644\u4ef6\u6587\u4ef6\u6570\u4e3a\u5f53\u524d\u5206\u5f55\u6570\u91cf\u3002", (String)"ProjectDeliverablesBillPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    if (atsize.compareTo(qty) == 0) {
                        this.getModel().setValue("finishmark", (Object)"1", changeSet.getRowIndex());
                        break;
                    }
                    this.getModel().setValue("finishmark", (Object)"0", changeSet.getRowIndex());
                    break;
                }
                this.getModel().setValue("finishmark", (Object)"0", changeSet.getRowIndex());
                break;
            }
            case "qty": {
                Object att = this.getModel().getValue("attachment", changeSet.getRowIndex());
                if (Objects.nonNull(att)) {
                    BigDecimal newqty = (BigDecimal)newValueObj;
                    DynamicObjectCollection attach = (DynamicObjectCollection)att;
                    BigDecimal atsize = new BigDecimal(attach.size());
                    if (atsize.compareTo(newqty) > 0) {
                        this.getModel().setValue("qty", (Object)attach.size(), changeSet.getRowIndex());
                        this.getModel().setValue("finishmark", (Object)"1", changeSet.getRowIndex());
                        break;
                    }
                    if (atsize.compareTo(newqty) == 0) {
                        this.getModel().setValue("finishmark", (Object)"1", changeSet.getRowIndex());
                        break;
                    }
                    this.getModel().setValue("finishmark", (Object)"0", changeSet.getRowIndex());
                    break;
                }
                this.getModel().setValue("finishmark", (Object)"0", changeSet.getRowIndex());
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        UnitEdit unitEdit = (UnitEdit)this.getControl("unit");
        unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        IDataEntityProperty property = paramBeforeF7SelectEvent.getProperty();
        String name = property.getName();
        ListShowParameter showParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"unit", (CharSequence)name)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            DynamicObject materialno = entryRowEntity.getDynamicObject("materialno");
            if (null == materialno) {
                return;
            }
            DynamicObject baseunit = materialno.getDynamicObject("baseunit");
            Object baseUnitPk = baseunit.getPkValue();
            ArrayList<Long> pkList = new ArrayList<Long>();
            pkList.add(Long.parseLong(baseUnitPk.toString()));
            DynamicObjectCollection entryentitys = materialno.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                DynamicObject measureunitid = entryentity.getDynamicObject("measureunitid");
                pkList.add(Long.parseLong(measureunitid.getPkValue().toString()));
            }
            QFilter qfilter = new QFilter("id", "in", pkList);
            showParameter.getListFilterParameter().setFilter(qfilter);
        }
    }
}

