/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.pmc.pmrp.enums.ScaleScopeEnum;
import kd.pmc.pmrp.util.CommonUtils;
import kd.pmc.pmrp.util.PMCUtils;
import kd.pmc.pmrp.util.RiskParaSetUtils;
import kd.pmc.pmrp.util.RiskScopeDefinitionUtils;

public class RiskParaSetEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void beforeBindData(EventObject e) {
        TextEdit crossScopeEdit = (TextEdit)this.getControl("crossscope");
        String crossScopeContent = ResManager.loadKDString((String)"\u683c\u5f0f\u4e3a\u6574\u6570\u503c\u8303\u56f4\uff0c\u5982\uff1a0~5\u3002", (String)"RiskParaSetEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);
        crossScopeEdit.addTips(RiskParaSetUtils.getTips(null, (String)crossScopeContent));
        TextEdit verticalAxisScopeEdit = (TextEdit)this.getControl("verticalaxisscope");
        String verticalAxisScopeContent = ResManager.loadKDString((String)"\u683c\u5f0f\u4e3a\u6574\u6570\u503c\u8303\u56f4\uff0c\u5982\uff1a0~5\u3002", (String)"RiskParaSetEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);
        verticalAxisScopeEdit.addTips(RiskParaSetUtils.getTips(null, (String)verticalAxisScopeContent));
        this.updateColorFieldGrid("entryentity2", "riskgradecolor", "riskgradecolorval");
        this.updateColorFieldGrid("entryentity2", "riskshowcolor", "riskshowcolorval");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("riskgradecolorval");
        fields.add("riskshowcolorval");
        fields.add("riskscopedefinition");
        this.addClickListeners(fields.toArray(new String[fields.size()]));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "riskgradecolorval": {
                this.openColorForm(key);
                break;
            }
            case "riskshowcolorval": {
                this.openColorForm(key);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "riskscopedefinition": {
                this.riskScopeDefinitionOp();
            }
        }
    }

    private void riskScopeDefinitionOp() {
        Long id = (Long)this.getModel().getValue("id");
        Long riskScopeId = RiskScopeDefinitionUtils.getRiskScopeToRiskParaSetId((Long)id);
        RiskParaSetUtils.showForm((Long)id, (Long)riskScopeId, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (("riskgradecolorval".equals(actionId) || "riskshowcolorval".equals(actionId)) && returnData != null) {
            this.callBackFieldColorProp(actionId, String.valueOf(returnData));
        }
    }

    private void callBackFieldColorProp(String actionId, String fieldId) {
        if (!StringUtils.isBlank((CharSequence)fieldId)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity2");
            this.getModel().setValue(actionId, (Object)fieldId, row);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"crossscope")) {
            this.crossScopeChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"verticalaxisscope")) {
            this.verticalAxisScopeChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"crosspara")) {
            this.crossParaChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"verticalaxispara")) {
            this.verticalAxisParaChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"crossaverage")) {
            this.crossAverageChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"verticalaxisaverage")) {
            this.verticalAxisAverageChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskgradecolorval")) {
            this.riskgradeColorValChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskshowcolorval")) {
            this.updateColorFieldGrid("entryentity2", "riskshowcolor", "riskshowcolorval");
        }
    }

    private void riskgradeColorValChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        this.updateColorFieldGrid("entryentity2", "riskgradecolor", "riskgradecolorval");
    }

    private void openColorForm(String key) {
        String entity = "entryentity2";
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entity);
        String fieldName = PMCUtils.getDataModelStringData((IDataModel)this.getModel(), (String)key, (int)rowIndex);
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("color", fieldName);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        FormShowParameter formShowParameter = CommonUtils.assembleShowFormParam((String)"pmrp_color_select", customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        formShowParameter.setShowTitle(false);
        formShowParameter.setShowClose(false);
        this.getView().showForm(formShowParameter);
    }

    private void crossParaChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String crossPara = (String)newObject;
        if ("A".equals(crossPara)) {
            if (!"B".equals(this.getModel().getValue("verticalaxispara"))) {
                this.getModel().setValue("verticalaxispara", (Object)"B");
            }
        } else if ("B".equals(crossPara) && !"A".equals(this.getModel().getValue("verticalaxispara"))) {
            this.getModel().setValue("verticalaxispara", (Object)"A");
        }
        this.crossScopeChange(null, this.getModel().getValue("crossscope"), null, 0);
        this.verticalAxisScopeChange(null, this.getModel().getValue("verticalaxisscope"), null, 0);
    }

    private void verticalAxisParaChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String verticalAxisPara = (String)newObject;
        if ("A".equals(verticalAxisPara)) {
            if (!"B".equals(this.getModel().getValue("crosspara"))) {
                this.getModel().setValue("crosspara", (Object)"B");
            }
        } else if ("B".equals(verticalAxisPara) && !"A".equals(this.getModel().getValue("crosspara"))) {
            this.getModel().setValue("crosspara", (Object)"A");
        }
    }

    private void verticalAxisAverageChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String crossPara = (String)this.getModel().getValue("crosspara");
        String entry = "entryentity";
        String updateVal = "probabilityval";
        if ("A".equals(crossPara)) {
            entry = "entryentity1";
            updateVal = "degreeval";
        }
        if (newObject == null) {
            this.deleteEntryAllRow(entry);
            return;
        }
        if (Integer.parseInt(newObject.toString()) <= 0) {
            this.getModel().setValue("verticalaxisaverage", null);
            return;
        }
        String verticalAxisScope = (String)this.getModel().getValue("verticalaxisscope");
        if (verticalAxisScope == null || verticalAxisScope.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7eb5\u8f74\u523b\u5ea6\u503c\u8303\u56f4\uff0c\u518d\u586b\u5199\u7eb5\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u3002", (String)"RiskParaSetEditPlugin_10", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("verticalaxisaverage", null);
            return;
        }
        Integer crossAverage = (Integer)newObject;
        Integer verticalAxisScopeVal = RiskParaSetUtils.getCrossScopeVal((String)verticalAxisScope);
        if (verticalAxisScopeVal == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u7eb5\u8f74\u523b\u5ea6\u503c\uff0c\u5e76\u586b\u5199\u7eb5\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u3002", (String)"RiskParaSetEditPlugin_11", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("crossaverage", null);
            return;
        }
        if (verticalAxisScopeVal % crossAverage != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u7eb5\u8f74\u523b\u5ea6\u5e73\u5747\u503c\uff0c\u786e\u4fdd\u80fd\u88ab\u7eb5\u8f74\u523b\u5ea6\u503c\u8303\u56f4\u6574\u9664\u3002", (String)"RiskParaSetEditPlugin_12", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("verticalaxisaverage", null);
            return;
        }
        if (verticalAxisScopeVal / crossAverage > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7eb5\u8f74\u523b\u5ea6\u503c\u8303\u56f4\u9664\u4ee5\u7eb5\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u4e0d\u80fd\u5927\u4e8e50\u3002", (String)"RiskParaSetEditPlugin_17", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("verticalaxisaverage", null);
            return;
        }
        this.createNewEntryRow(verticalAxisScopeVal, crossAverage, entry, updateVal);
    }

    private void crossAverageChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String crossPara = (String)this.getModel().getValue("crosspara");
        String entry = "entryentity";
        String updateVal = "probabilityval";
        if ("B".equals(crossPara)) {
            entry = "entryentity1";
            updateVal = "degreeval";
        }
        if (newObject == null) {
            this.deleteEntryAllRow(entry);
            return;
        }
        if (Integer.parseInt(newObject.toString()) <= 0) {
            this.getModel().setValue("crossaverage", null);
            return;
        }
        String crossScope = (String)this.getModel().getValue("crossscope");
        if (crossScope == null || crossScope.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6a2a\u8f74\u523b\u5ea6\u503c\u8303\u56f4\uff0c\u518d\u586b\u5199\u6a2a\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u3002", (String)"RiskParaSetEditPlugin_13", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("crossaverage", null);
            return;
        }
        Integer crossAverage = (Integer)newObject;
        Integer crossScopeVal = RiskParaSetUtils.getCrossScopeVal((String)crossScope);
        if (crossScopeVal == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6a2a\u8f74\u523b\u5ea6\u503c\uff0c\u518d\u586b\u5199\u6a2a\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u3002", (String)"RiskParaSetEditPlugin_5", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("crossaverage", null);
            return;
        }
        if (crossScopeVal % crossAverage != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u6a2a\u8f74\u523b\u5ea6\u5e73\u5747\u503c\uff0c\u786e\u4fdd\u80fd\u88ab\u6a2a\u8f74\u523b\u5ea6\u503c\u8303\u56f4\u6574\u9664\u3002", (String)"RiskParaSetEditPlugin_14", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("crossaverage", null);
            return;
        }
        if (crossScopeVal / crossAverage > 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6a2a\u8f74\u523b\u5ea6\u503c\u8303\u56f4\u9664\u4ee5\u6a2a\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u4e0d\u80fd\u5927\u4e8e50\u3002", (String)"RiskParaSetEditPlugin_16", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("crossaverage", null);
            return;
        }
        this.createNewEntryRow(crossScopeVal, crossAverage, entry, updateVal);
    }

    private void createNewEntryRow(Integer crossScopeVal, Integer crossAverage, String entryEntity, String val) {
        this.deleteEntryAllRow(entryEntity);
        int size = crossScopeVal / crossAverage;
        this.getModel().batchCreateNewEntryRow(entryEntity, size);
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue(val, (Object)(i * crossAverage + crossAverage), i);
        }
    }

    private void deleteEntryAllRow(String entryEntity) {
        int size = this.getModel().getEntryRowCount(entryEntity);
        if (size == 0) {
            return;
        }
        int[] line = new int[size];
        for (int i = 0; i < size; ++i) {
            line[i] = i;
        }
        this.getModel().deleteEntryRows(entryEntity, line);
    }

    private void verticalAxisScopeChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String verticalAxisScope = (String)newObject;
        int status = this.scaleScope("verticalaxisscope", verticalAxisScope);
        if (status == ScaleScopeEnum.SCALESCOPE_EXPRESSION.getStatus()) {
            Integer verticalAxisAverage = (Integer)this.getModel().getValue("verticalaxisaverage");
            if (verticalAxisAverage != null && verticalAxisAverage != 0) {
                Integer crossScopeVal = RiskParaSetUtils.getCrossScopeVal((String)verticalAxisScope);
                if (crossScopeVal == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6b63\u786e\u7684\u7eb5\u8f74\u523b\u5ea6\u503c\uff0c\u5e76\u586b\u5199\u7eb5\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u3002", (String)"RiskParaSetEditPlugin_11", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("crossaverage", null);
                    return;
                }
                if (crossScopeVal % verticalAxisAverage == 0) {
                    this.verticalAxisAverageChange(null, verticalAxisAverage, null, 0);
                } else {
                    this.getModel().setValue("verticalaxisaverage", null);
                }
            }
        } else {
            if (status == ScaleScopeEnum.SCALESCOPE_INT_EXPRESSION.getStatus()) {
                return;
            }
            this.getModel().setValue("verticalaxisaverage", null);
        }
    }

    private void crossScopeChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        String crossScope = (String)newObject;
        int status = this.scaleScope("crossscope", crossScope);
        if (status == ScaleScopeEnum.SCALESCOPE_EXPRESSION.getStatus()) {
            Integer crossAverage = (Integer)this.getModel().getValue("crossaverage");
            if (crossAverage != null && crossAverage != 0) {
                Integer crossScopeVal = RiskParaSetUtils.getCrossScopeVal((String)crossScope);
                if (crossScopeVal == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6a2a\u8f74\u523b\u5ea6\u503c\uff0c\u518d\u586b\u5199\u6a2a\u8f74\u5e73\u5747\u523b\u5ea6\u503c\u3002", (String)"RiskParaSetEditPlugin_5", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("crossaverage", null);
                    return;
                }
                if (crossScopeVal % crossAverage == 0) {
                    this.crossAverageChange(null, crossAverage, null, 0);
                } else {
                    this.getModel().setValue("crossaverage", null);
                }
            }
        } else {
            if (status == ScaleScopeEnum.SCALESCOPE_INT_EXPRESSION.getStatus()) {
                return;
            }
            this.getModel().setValue("crossaverage", null);
        }
    }

    private int scaleScope(String propertyName, String scopeVal) {
        if (scopeVal == null || scopeVal.isEmpty()) {
            return ScaleScopeEnum.NO_SCALESCOPE__EXPRESSION.getStatus();
        }
        boolean int_flag = Pattern.compile(ScaleScopeEnum.SCALESCOPE_INT_EXPRESSION.getValue()).matcher(scopeVal).find();
        if (int_flag) {
            StringBuilder crossScopeNew = new StringBuilder("0-");
            crossScopeNew.append(scopeVal);
            this.getModel().setValue(propertyName, (Object)crossScopeNew);
            return ScaleScopeEnum.SCALESCOPE_INT_EXPRESSION.getStatus();
        }
        boolean scope_flag = Pattern.compile(ScaleScopeEnum.SCALESCOPE_EXPRESSION.getValue()).matcher(scopeVal).find();
        if (!scope_flag) {
            this.getModel().setValue(propertyName, null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u6574\u6570\u6216\u8005\u6b63\u6574\u6570\u8303\u56f4\uff0c\u4f8b\u5982\uff1a5\u6216\u80050-5\u3002", (String)"RiskParaSetEditPlugin_15", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return ScaleScopeEnum.NO_SCALESCOPE__EXPRESSION.getStatus();
        }
        return ScaleScopeEnum.SCALESCOPE_EXPRESSION.getStatus();
    }

    public void updateColorFieldGrid(String entryKey, String colorField, String colorValField) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)fv.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        DynamicObjectCollection colls = dm.getEntryEntity(entryKey);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>(colls.size());
        String defForceColor = "#ffffff";
        String defBackColor = "#ffffff";
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject rowObj = (DynamicObject)colls.get(i);
            Object colorVal = rowObj.get(colorValField);
            CellStyle cell = this.getCellStyle(i, colorField);
            if (colorVal instanceof String && !StringUtils.equals((CharSequence)String.valueOf(colorVal), (CharSequence)"")) {
                cell.setBackColor((String)colorVal);
                cell.setForeColor((String)colorVal);
            } else {
                cell.setBackColor(defForceColor);
                cell.setForeColor(defBackColor);
            }
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
        }
    }

    private CellStyle getCellStyle(int rowIndex, String fieldKey) {
        CellStyle cell = new CellStyle();
        cell.setFieldKey(fieldKey);
        cell.setRow(rowIndex);
        return cell;
    }
}

