/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.formplugin.base;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.pmc.pmrp.enums.RiskStatusTypeEnum;
import kd.pmc.pmrp.util.RiskStatusUtils;

public class RiskStatusListPlugin
extends AbstractListPlugin {
    private final String COPY_ERROR_MSG = ResManager.loadKDString((String)"\u72b6\u6001\u7c7b\u578b\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u6761\uff0c\u4e0d\u53ef\u590d\u5236\u3002", (String)"RiskStatusListPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        switch (operateKey) {
            case "copy": {
                this.copy(selectedRows, evt);
                break;
            }
        }
    }

    private void copy(ListSelectedRowCollection selectedRows, BeforeItemClickEvent evt) {
        this.errorOp(selectedRows, evt, this.COPY_ERROR_MSG);
    }

    private void errorOp(ListSelectedRowCollection selectedRows, BeforeItemClickEvent evt, String errorStr) {
        Set<Long> ids = this.getIds(selectedRows);
        if (ids.size() == 1) {
            StringBuilder errorSb = new StringBuilder();
            String type = RiskStatusUtils.queryType((Long)ids.iterator().next());
            if (RiskStatusTypeEnum.ADD.getValue().equals(type)) {
                errorSb.append(RiskStatusTypeEnum.ADD.getName());
                errorSb.append(errorStr);
            } else if (RiskStatusTypeEnum.CLOSE.getValue().equals(type)) {
                errorSb.append(RiskStatusTypeEnum.CLOSE.getName());
                errorSb.append(errorStr);
            }
            if (errorSb.length() > 0) {
                this.showTipNotification(errorSb.toString(), evt);
            }
        }
    }

    private Set<Long> getIds(ListSelectedRowCollection selectedRows) {
        HashSet<Long> ids = new HashSet<Long>(16);
        for (ListSelectedRow listSelectedRow : selectedRows) {
            ids.add(Long.parseLong(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        return ids;
    }

    private void showTipNotification(String error, BeforeItemClickEvent evt) {
        this.getView().showTipNotification(ResManager.loadKDString((String)error, (String)"RiskStatusListPlugin_1", (String)"RiskStatusListPlugin_1", (Object[])new Object[0]), Integer.valueOf(3000));
        evt.setCancel(true);
    }
}

