/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.formplugin.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.pmc.pmrp.enums.RiskAxisEnum;
import kd.pmc.pmrp.util.RiskRegisterUtils;
import kd.pmc.pmrp.util.RiskScopeDefinitionUtils;

public class RiskMatrixDiagramReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
    }

    public void registerListener(EventObject e) {
        BasedataEdit pmtsTask;
        super.registerListener(e);
        BasedataEdit riskParaSet = (BasedataEdit)this.getControl("riskparaset");
        if (riskParaSet != null) {
            riskParaSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((pmtsTask = (BasedataEdit)this.getControl("pmtstask")) != null) {
            pmtsTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList qfilters = new ArrayList();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"pmtstask")) {
            FormShowParameter f = evt.getFormShowParameter();
            f.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u52a1", (String)"RiskMatrixDiagramReportPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            evt.setFormShowParameter(f);
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    private void sendHtml(Map<String, Object> data, String key) {
        CustomControl custCtl = (CustomControl)this.getView().getControl(key);
        custCtl.setData(data);
    }

    public void customEvent(CustomEventArgs e) {
        String eName;
        super.customEvent(e);
        String ctlkey = e.getKey();
        String eArgs = e.getEventArgs();
        switch (eName = e.getEventName()) {
            case "clear": {
                this.sendHtml(null, ctlkey);
                break;
            }
            case "routeChange": {
                this.routeChange(eArgs);
                this.sendHtml(null, ctlkey);
            }
        }
    }

    private void routeChange(String data) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId("pmrp_riskregister");
        lsp.setFormId("bos_list");
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qfilter = this.getQFilter();
        DynamicObject riskParaSet = (DynamicObject)this.getModel().getValue("riskparaset");
        if (qfilter == null) {
            qfilter = new QFilter("riskparaset", "=", (Object)riskParaSet.getLong("id"));
        } else {
            qfilter.and(new QFilter("riskparaset", "=", (Object)riskParaSet.getLong("id")));
        }
        listFilterParameter.setFilter(qfilter);
        lsp.setListFilterParameter(listFilterParameter);
        Map reResult = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        List xList = (List)reResult.get("x");
        List yList = (List)reResult.get("y");
        if (RiskAxisEnum.DEGREE.getValue().equals(riskParaSet.getString("crosspara"))) {
            qfilter.and(new QFilter("riskimpactdegree", "<=", (Object)Long.parseLong((String)xList.get(1))));
            qfilter.and(new QFilter("riskimpactdegree", ">", (Object)Long.parseLong((String)xList.get(0))));
            qfilter.and(new QFilter("riskprobability", "<=", (Object)Long.parseLong((String)yList.get(1))));
            qfilter.and(new QFilter("riskprobability", ">", (Object)Long.parseLong((String)yList.get(0))));
        } else {
            qfilter.and(new QFilter("riskprobability", "<=", (Object)Long.parseLong((String)xList.get(1))));
            qfilter.and(new QFilter("riskprobability", ">", (Object)Long.parseLong((String)xList.get(0))));
            qfilter.and(new QFilter("riskimpactdegree", "<=", (Object)Long.parseLong((String)yList.get(1))));
            qfilter.and(new QFilter("riskimpactdegree", ">", (Object)Long.parseLong((String)yList.get(0))));
        }
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        QFilter riskStatusFilter = new QFilter("riskstatus.type", "!=", (Object)"100");
        qfilter.and(statusFilter).and(riskStatusFilter);
        lsp.setCaption(ResManager.loadKDString((String)"\u98ce\u9669\u660e\u7ec6", (String)"RiskMatrixDiagramReportPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        lsp.setCustomParam("openSource", (Object)"riskmatrixdiagram");
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.queryRisk("query");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refresh")) {
            this.queryRisk(operateKey);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"reset")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportlistap"});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dynObj = (DynamicObject)this.getModel().getValue("riskparaset");
        if (dynObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u98ce\u9669\u77e9\u9635\u65b9\u6848\u540e\u8fdb\u884c\u67e5\u8be2\u3002", (String)"RiskMatrixDiagramReportPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            return false;
        }
        boolean bool = RiskScopeDefinitionUtils.existsRiskScopeToParaSet((Long)dynObj.getLong("id"));
        if (!bool) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u98ce\u9669\u77e9\u9635\u65b9\u6848\u7684\u77e9\u9635\u56fe\u8303\u56f4\u540e\u8fdb\u884c\u67e5\u8be2\u3002", (String)"RiskMatrixDiagramReportPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            return false;
        }
        return true;
    }

    private void queryRisk(String btn) {
        DynamicObject dynObj = (DynamicObject)this.getModel().getValue("riskparaset");
        if (dynObj == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap3"});
        QFilter idFilter = this.getQFilter();
        Map<String, Object> data = new HashMap<String, Object>();
        DynamicObjectCollection dynColl = dynObj.getDynamicObjectCollection("entryentity2");
        if (dynColl != null && !dynColl.isEmpty()) {
            Map reResult = RiskScopeDefinitionUtils.getRiskMatrixDiagramForRiskParaSet((DynamicObject)dynObj);
            String riskmatrixdiagramdata = RiskScopeDefinitionUtils.getRiskScopeToRiskParaSet((Long)dynObj.getLong("id"));
            reResult = RiskScopeDefinitionUtils.htmlAddBg((Map)reResult, (String)riskmatrixdiagramdata);
            reResult = RiskScopeDefinitionUtils.setEditable((Map)reResult, (boolean)false);
            Map dataMap = (Map)reResult.get("data");
            Map xAxisMap = (Map)dataMap.get("xAxis");
            Map yAxisMap = (Map)dataMap.get("yAxis");
            String[] xAxisValue = (String[])xAxisMap.get("value");
            String[] yAxisValue = (String[])yAxisMap.get("value");
            String desc = (String)xAxisMap.get("desc");
            List bglist = (List)dataMap.get("bg");
            Map map = RiskRegisterUtils.getAxisMap((String[])xAxisValue, (String[])yAxisValue);
            List riskList = RiskRegisterUtils.getRiskRegisterToParaSetId((Long)dynObj.getLong("id"), (String)desc, (List)bglist, (Map)map, (QFilter)idFilter);
            dataMap.put("points", riskList);
            Map borderStyle = RiskRegisterUtils.getBorderStyle();
            dataMap.put("borderStyle", borderStyle);
            data = reResult;
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
        if (!data.isEmpty()) {
            this.sendHtml(data, "riskmatrixdiagram");
        }
    }

    private QFilter getQFilter() {
        DynamicObject org;
        DynamicObject ops;
        DynamicObject projectType;
        DynamicObject customer;
        DynamicObject projectManager;
        DynamicObject pmtsTask;
        DynamicObject wbs;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        QFilter qf = null;
        if (project != null) {
            qf = new QFilter("project", "=", (Object)project.getLong("id"));
        }
        if ((wbs = (DynamicObject)this.getModel().getValue("wbs")) != null) {
            this.getQfilter(qf, "wbs", wbs.getLong("id"));
        }
        if ((pmtsTask = (DynamicObject)this.getModel().getValue("pmtstask")) != null) {
            this.getQfilter(qf, "pmtstask", pmtsTask.getLong("id"));
        }
        if ((projectManager = (DynamicObject)this.getModel().getValue("projectmanager")) != null) {
            this.getQfilter(qf, "project.pjmanager.id", projectManager.getLong("id"));
        }
        if ((customer = (DynamicObject)this.getModel().getValue("customer")) != null) {
            this.getQfilter(qf, "project.customer.id", customer.getLong("id"));
        }
        if ((projectType = (DynamicObject)this.getModel().getValue("projecttype")) != null) {
            this.getQfilter(qf, "project.pjtype.id", projectType.getLong("id"));
        }
        if ((ops = (DynamicObject)this.getModel().getValue("ops")) != null) {
            this.getQfilter(qf, "ops", ops.getLong("id"));
        }
        if ((org = (DynamicObject)this.getModel().getValue("org")) != null) {
            this.getQfilter(qf, "org", org.getLong("id"));
        }
        return qf;
    }

    private void getQfilter(QFilter qf, String key, Long value) {
        if (qf != null) {
            qf.and(new QFilter(key, "=", (Object)value));
        } else {
            qf = new QFilter(key, "=", (Object)value);
        }
    }
}

