/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.formplugin.tpl.question;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmrp.enums.IssueStatusEnum;
import kd.pmc.pmrp.util.CommonUtils;
import kd.pmc.pmrp.util.MyQuestionUtils;

public class MyQuestionListPlugin
extends AbstractListPlugin {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operateKey = evt.getOperationKey();
        BillList control = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        if ("handle".equals(operateKey)) {
            this.handle(selectedRows, evt);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList rowData = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = rowData.getCurrentSelectedRowInfo();
        Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
        String billNo = currentSelectedRowInfo.getBillNo();
        switch (fieldName) {
            case "billno": {
                args.setCancel(true);
                String pageId = this.getView().getPageId();
                HashMap<String, Object> customParams = new HashMap<String, Object>(2);
                customParams.put("question_id", primaryKeyValue);
                customParams.put("question_billno", billNo);
                FormShowParameter formShowParameter = CommonUtils.assembleShowFormParam((String)"pmrp_questiondetails", customParams, null, (ShowType)ShowType.MainNewTabPage);
                formShowParameter.setPageId(pageId + billNo);
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private void handle(ListSelectedRowCollection selectedRows, BeforeItemClickEvent evt) {
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u95ee\u9898\u5355\u636e\u3002", (String)"MyQuestionListPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u95ee\u9898\u8fdb\u884c\u5904\u7406\u3002", (String)"MyQuestionListPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        Long hmResPoId = MyQuestionUtils.getHmResPoForUserId((Long)RequestContext.get().getCurrUserId());
        QFilter idsFilter = new QFilter("id", "=", selectedRows.getPrimaryKeyValues()[0]);
        QFilter creatorOrHandlerFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).or(new QFilter("handler", "=", (Object)hmResPoId));
        boolean bool = QueryServiceHelper.exists((String)"pmrp_myquestion", (QFilter[])new QFilter[]{idsFilter, creatorOrHandlerFilter});
        if (!bool) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u5904\u7406\u6b64\u95ee\u9898\u5355\u636e\u3002", (String)"MyQuestionListPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        QFilter issueStatusFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.CLOSE.getNumber().toString());
        if (QueryServiceHelper.exists((String)"pmrp_myquestion", (QFilter[])new QFilter[]{idsFilter, issueStatusFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\uff0c\u6b64\u95ee\u9898\u5355\u636e\u6ca1\u6709\u8981\u5904\u7406\u7684\u72b6\u6001\u3002", (String)"MyQuestionListPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            evt.setCancel(true);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("pmrp_myquestion_id", selectedRows.getPrimaryKeyValues()[0]);
        CommonUtils.showLogForm((String)"pmrp_questionhandle", (OperationStatus)OperationStatus.EDIT, (long)0L, (ShowType)ShowType.Modal, (IFormPlugin)this, (String)"pmrp_questionhandle", customParams, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String key = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (returnData != null && StringUtils.equalsIgnoreCase((CharSequence)"pmrp_questionhandle", (CharSequence)key)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u95ee\u9898\u5904\u7406\u6210\u529f\u3002", (String)"MyQuestionListPlugin_4", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

