/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.formplugin.tpl.risk;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmrp.util.RiskParaSetUtils;
import kd.pmc.pmrp.util.RiskRegisterUtils;

public class RiskRegisterEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit riskParaSet;
        BasedataEdit influencewbs;
        BasedataEdit riskpersonliable;
        BasedataEdit enterprisehmrespo;
        super.registerListener(e);
        BasedataEdit teamadministrators = (BasedataEdit)this.getControl("wbs");
        if (teamadministrators != null) {
            teamadministrators.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((enterprisehmrespo = (BasedataEdit)this.getControl("pmtstask")) != null) {
            enterprisehmrespo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((riskpersonliable = (BasedataEdit)this.getControl("riskpersonliable")) != null) {
            riskpersonliable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((influencewbs = (BasedataEdit)this.getControl("influencewbs")) != null) {
            influencewbs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((riskParaSet = (BasedataEdit)this.getControl("riskparaset")) != null) {
            riskParaSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"wbs") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"influencewbs")) {
            this.beforeWbsSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"pmtstask")) {
            this.beforePmtsTaskSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"riskpersonliable")) {
            this.beforeRiskPersonLiableSelect(evt, qfilters);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"riskparaset")) {
            // empty if block
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    private void beforeRiskParaSetSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject dy = (DynamicObject)this.getModel().getValue("org");
        if (dy != null) {
            QFilter qFilterToOrg = new QFilter("createorg", "=", (Object)dy.getLong("id"));
            qfilters.add(qFilterToOrg);
        }
    }

    private void beforeRiskPersonLiableSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u53f7\uff0c\u518d\u9009\u62e9\u98ce\u9669\u8d1f\u8d23\u4eba\u3002", (String)"RiskRegisterEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long projectId = project.getLong("id");
        Set users = RiskRegisterUtils.getUserForProjectTeam((Long)projectId);
        QFilter qFilter = new QFilter("id", "in", (Object)users);
        qfilters.add(qFilter);
    }

    private void beforePmtsTaskSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject wbs;
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            QFilter qFilter = new QFilter("projectnum.id", "=", (Object)project.getLong("id"));
            qfilters.add(qFilter);
        }
        if ((wbs = (DynamicObject)this.getModel().getValue("wbs")) != null) {
            QFilter qFilter = new QFilter("wbs.id", "=", (Object)wbs.getLong("id"));
            QFilter filter = new QFilter("projectnum.id", "!=", (Object)0L);
            qfilters.add(filter.and(qFilter));
        }
        FormShowParameter f = evt.getFormShowParameter();
        f.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u4efb\u52a1", (String)"RiskRegisterEditPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        evt.setFormShowParameter(f);
    }

    private void beforeWbsSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            QFilter qFilter = new QFilter("projectnum.id", "=", (Object)project.getLong("id"));
            qfilters.add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"pmtstask")) {
            this.pmtsTaskChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"wbs")) {
            this.wbsChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"project")) {
            this.projectChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskimpactdegree")) {
            this.riskImpactDegreeChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskprobability")) {
            this.riskProbabilityChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskbudget")) {
            this.riskBudgetChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"eodatestart")) {
            this.eodateStartChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"eodateend")) {
            this.eodateEndChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"currency")) {
            this.currencyChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskparaset")) {
            this.riskParaSetChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDefaultRiskParaSet();
        this.getModel().setDataChanged(false);
    }

    private void initDefaultRiskParaSet() {
        DynamicObject dyn = (DynamicObject)this.getModel().getValue("org");
        DynamicObject riskParaSethdyn = (DynamicObject)this.getModel().getValue("riskparaset");
        if (dyn == null || riskParaSethdyn != null) {
            return;
        }
        Long org = dyn.getLong("id");
        Long defaultRiskParaSet = RiskParaSetUtils.getDefaultRiskParaSet((Long)org);
        if (defaultRiskParaSet != null) {
            this.getModel().setValue("riskparaset", (Object)defaultRiskParaSet);
        }
    }

    private void riskParaSetChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        this.getModel().setValue("riskimpactdegree", null);
        this.getModel().setValue("riskprobability", null);
    }

    private void currencyChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject == null) {
            this.getModel().setValue("riskbudget", null);
        }
    }

    private void eodateEndChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject != null) {
            Date eodateend = (Date)newObject;
            Date eodatestart = (Date)this.getModel().getValue("eodatestart");
            if (eodatestart == null) {
                this.getModel().setValue("eodateend", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9884\u8ba1\u5f00\u59cb\u65f6\u95f4\u3002", (String)"RiskRegisterEditPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                return;
            }
            if (eodateend.compareTo(eodatestart) < 0) {
                this.getModel().setValue("eodateend", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u8981\u65e9\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"RiskRegisterEditPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void eodateStartChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        Date eodateend;
        if (newObject == null && (eodateend = (Date)this.getModel().getValue("eodateend")) != null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u9700\u8981\u65e9\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"RiskRegisterEditPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("eodateend", null);
        }
    }

    private void riskBudgetChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        DynamicObject currency;
        BigDecimal riskBudget = (BigDecimal)newObject;
        if (riskBudget != null && riskBudget.compareTo(BigDecimal.ZERO) != 0 && (currency = (DynamicObject)this.getModel().getValue("currency")) == null) {
            this.getModel().setValue("riskbudget", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b\uff0c\u518d\u586b\u5199\u98ce\u9669\u9884\u7b97\u3002", (String)"RiskRegisterEditPlugin_4", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        }
    }

    private void riskImpactDegreeChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        BigDecimal newvalue = (BigDecimal)newObject;
        if (newvalue == null || newvalue.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("riskvalue", null);
            return;
        }
        DynamicObject riskParaSet = (DynamicObject)this.getModel().getValue("riskparaset");
        if (riskParaSet == null) {
            this.getModel().setValue("riskimpactdegree", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u98ce\u9669\u53c2\u6570\u65b9\u6848\uff0c\u5e76\u586b\u5199\u98ce\u9669\u5f71\u54cd\u7a0b\u5ea6\u3002", (String)"RiskRegisterEditPlugin_5", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        String crossPara = riskParaSet.getString("crosspara");
        Integer maxVal = 0;
        maxVal = "B".equals(crossPara) ? RiskParaSetUtils.getCrossScopeVal((String)riskParaSet.getString("crossscope")) : RiskParaSetUtils.getCrossScopeVal((String)riskParaSet.getString("verticalaxisscope"));
        if (maxVal == 0) {
            this.getModel().setValue("riskimpactdegree", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u98ce\u9669\u53c2\u6570\u65b9\u6848\u3002", (String)"RiskRegisterEditPlugin_6", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        if (newvalue.compareTo(BigDecimal.valueOf(maxVal.intValue())) > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"\u98ce\u9669\u53c2\u6570\u65b9\u6848\u4e2d\u6700\u5927\u5f71\u54cd\u7a0b\u5ea6\u4e3a\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u6b64\u6570\u503c\u8303\u56f4", (String)"RiskRegisterEditPlugin_8", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), maxVal));
            this.getView().showTipNotification(sb.toString());
            this.getModel().setValue("riskimpactdegree", null);
            return;
        }
        BigDecimal riskimpactdegree = (BigDecimal)this.getModel().getValue("riskimpactdegree");
        BigDecimal riskprobability = (BigDecimal)this.getModel().getValue("riskprobability");
        BigDecimal riskvalue = riskimpactdegree.multiply(riskprobability);
        double result = riskvalue.setScale(2, 4).doubleValue();
        this.getModel().setValue("riskvalue", (Object)result);
    }

    private void riskProbabilityChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        BigDecimal newvalue = (BigDecimal)newObject;
        if (newvalue == null || newvalue.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue("riskvalue", null);
            return;
        }
        DynamicObject riskParaSet = (DynamicObject)this.getModel().getValue("riskparaset");
        if (riskParaSet == null) {
            this.getModel().setValue("riskprobability", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u98ce\u9669\u53c2\u6570\u65b9\u6848\uff0c\u5728\u586b\u5199\u98ce\u9669\u53d1\u751f\u6982\u7387\u3002", (String)"RiskRegisterEditPlugin_15", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        String crossPara = riskParaSet.getString("crosspara");
        Integer maxVal = 0;
        maxVal = "B".equals(crossPara) ? RiskParaSetUtils.getCrossScopeVal((String)riskParaSet.getString("verticalaxisscope")) : RiskParaSetUtils.getCrossScopeVal((String)riskParaSet.getString("crossscope"));
        if (maxVal == 0) {
            this.getModel().setValue("riskprobability", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u98ce\u9669\u53c2\u6570\u65b9\u6848\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u7ef4\u62a4\u597d\u98ce\u9669\u53c2\u6570\u65b9\u6848\uff0c\u5728\u586b\u5199\u98ce\u9669\u53d1\u751f\u6982\u7387\u3002", (String)"RiskRegisterEditPlugin_16", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        if (newvalue.compareTo(BigDecimal.valueOf(maxVal.intValue())) > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"\u98ce\u9669\u53c2\u6570\u65b9\u6848\u4e2d\uff0c\u6700\u5927\u5f71\u54cd\u7a0b\u5ea6\u4e3a%s\u3002", (String)"RiskRegisterEditPlugin_7", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), maxVal));
            this.getView().showTipNotification(sb.toString());
            this.getModel().setValue("riskprobability", null);
            return;
        }
        BigDecimal riskimpactdegree = (BigDecimal)this.getModel().getValue("riskimpactdegree");
        BigDecimal riskprobability = (BigDecimal)this.getModel().getValue("riskprobability");
        BigDecimal riskvalue = riskimpactdegree.multiply(riskprobability);
        double result = riskvalue.setScale(2, 4).doubleValue();
        this.getModel().setValue("riskvalue", (Object)result);
    }

    private void projectChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        DynamicObject d = (DynamicObject)newObject;
        if (newObject != null) {
            DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs");
            if (wbs != null && wbs.getLong("projectnum.id") != d.getLong("id")) {
                this.getModel().setValue("wbs", null);
            }
        } else {
            DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs");
            if (wbs != null) {
                this.getModel().setValue("wbs", null);
            }
        }
        this.getModel().setValue("influencewbs", null);
        this.getModel().setValue("riskpersonliable", null);
    }

    private void wbsChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        DynamicObject d = (DynamicObject)newObject;
        if (newObject != null) {
            DynamicObject pmtsTask;
            Long projectid;
            DynamicObject project = (DynamicObject)this.getModel().getValue("project");
            if (project == null && (projectid = Long.valueOf(d.getLong("projectnum.id"))) != 0L) {
                this.getModel().setValue("project", (Object)projectid);
            }
            if ((pmtsTask = (DynamicObject)this.getModel().getValue("pmtstask")) != null && pmtsTask.getLong("wbs.id") != d.getLong("id")) {
                this.getModel().setValue("pmtstask", null);
            }
        } else {
            DynamicObject pmtsTask = (DynamicObject)this.getModel().getValue("pmtstask");
            if (pmtsTask != null) {
                this.getModel().setValue("pmtstask", null);
            }
        }
    }

    private void pmtsTaskChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        Long wbsid;
        DynamicObject wbs;
        DynamicObject d = (DynamicObject)newObject;
        if (newObject != null && (wbs = (DynamicObject)this.getModel().getValue("wbs")) == null && (wbsid = Long.valueOf(d.getLong("wbs.id"))) != 0L) {
            this.getModel().setValue("wbs", (Object)wbsid);
        }
    }
}

