/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmrp.formplugin.tpl.risk;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmrp.util.CommonUtils;
import kd.pmc.pmrp.util.RiskRegisterUtils;

public class RiskResponseEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit riskpersonliable = (BasedataEdit)this.getControl("riskpersonliable");
        if (riskpersonliable != null) {
            riskpersonliable.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"riskpersonliable")) {
            this.beforeRiskPersonLiableSelect(evt, qfilters);
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map paramsMap = this.getView().getFormShowParameter().getCustomParams();
        if (paramsMap.get("pmrp_riskregister_id") != null) {
            String id = paramsMap.get("pmrp_riskregister_id").toString();
            this.initData(Long.parseLong(id));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"btnok")) {
            this.save(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"riskbudget")) {
            this.riskBudgetChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"currency")) {
            this.currencyChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        }
    }

    private void currencyChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (newObject == null) {
            this.getModel().setValue("riskbudget", null);
        }
    }

    private void riskBudgetChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        DynamicObject currency;
        BigDecimal riskBudget = (BigDecimal)newObject;
        if (riskBudget != null && riskBudget.compareTo(BigDecimal.ZERO) != 0 && (currency = (DynamicObject)this.getModel().getValue("currency")) == null) {
            this.getModel().setValue("riskbudget", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u522b\uff0c\u518d\u586b\u5199\u98ce\u9669\u9884\u7b97\u3002", (String)"RiskResponseEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        }
    }

    private void save(BeforeDoOperationEventArgs e) {
        if (this.getModel().getValue("riskstrategy") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5e94\u5bf9\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RiskResponseEditPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String id = (String)this.getModel().getValue("id");
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id", "project", "riskstrategy", "billno", "name", "riskrelated", "responsibledep", "cooperationdep", "riskpersonliable", "currency", "riskbudget", "riskdesc"});
        QFilter idsFilter = new QFilter("id", "=", (Object)Long.parseLong(id));
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"pmrp_riskregister", (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
        if (dyn != null) {
            dyn.set("id", (Object)id);
            dyn.set("riskstrategy", this.getModel().getValue("riskstrategy"));
            dyn.set("riskrelated", this.getModel().getValue("riskrelated"));
            dyn.set("responsibledep", this.getModel().getValue("responsibledep"));
            dyn.set("cooperationdep", this.getModel().getValue("cooperationdep"));
            dyn.set("riskpersonliable", this.getModel().getValue("riskpersonliable"));
            dyn.set("currency", this.getModel().getValue("currency"));
            dyn.set("riskbudget", this.getModel().getValue("riskbudget"));
            dyn.set("riskdesc", this.getModel().getValue("riskdesc"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("status", "success");
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private void beforeRiskPersonLiableSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u53f7\uff0c\u518d\u9009\u62e9\u98ce\u9669\u8d1f\u8d23\u4eba\u3002", (String)"RiskResponseEditPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long projectId = project.getLong("id");
        Set users = RiskRegisterUtils.getUserForProjectTeam((Long)projectId);
        QFilter qFilter = new QFilter("id", "in", (Object)users);
        qfilters.add(qFilter);
    }

    private void initData(long id) {
        String selectFields = CommonUtils.getSelects((String[])new String[]{"id", "project", "riskstrategy", "billno", "name", "riskrelated", "responsibledep", "cooperationdep", "riskpersonliable", "currency", "riskbudget", "riskdesc"});
        QFilter idsFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"pmrp_riskregister", (String)selectFields, (QFilter[])new QFilter[]{idsFilter});
        if (dyn != null) {
            this.getModel().setValue("id", (Object)id);
            this.getModel().setValue("billno", (Object)dyn.getString("billno"));
            this.getModel().setValue("name", (Object)dyn.getString("name"));
            this.getModel().setValue("project", (Object)dyn.getDynamicObject("project"));
            this.getModel().setValue("riskstrategy", (Object)dyn.getDynamicObject("riskstrategy"));
            this.getModel().setValue("riskrelated", (Object)dyn.getString("riskrelated"));
            this.getModel().setValue("responsibledep", (Object)dyn.getDynamicObject("responsibledep"));
            this.getModel().setValue("cooperationdep", (Object)dyn.getDynamicObjectCollection("cooperationdep"));
            this.getModel().setValue("riskpersonliable", (Object)dyn.getDynamicObject("riskpersonliable"));
            this.getModel().setValue("currency", (Object)dyn.getDynamicObject("currency"));
            this.getModel().setValue("riskbudget", (Object)dyn.getString("riskbudget"));
            this.getModel().setValue("riskdesc", (Object)dyn.getString("riskdesc"));
        }
    }
}

