/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.base;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;

public class TaskProgressFormEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private boolean canClose = false;
    private JobFormInfo jobFormInfo;

    public void initialize() {
        super.initialize();
    }

    private DynamicObject newDynamicObject(DynamicObjectType type) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(type);
    }

    private DynamicObject newDynamicObject(String types) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(types);
    }

    private long genLongId(String type) {
        ORM orm = ORM.create();
        return orm.genLongId(type);
    }

    private long genDBLongId(String type) {
        return DB.genLongId((String)type);
    }

    private JobInfo getJobInfo() {
        if (this.jobFormInfo == null) {
            this.jobFormInfo = this.getJobFormInfo();
        }
        return this.jobFormInfo == null ? null : this.jobFormInfo.getJobInfo();
    }

    private JobFormInfo getJobFormInfo() {
        if (this.getPageCache().get("jobFormInfo") != null) {
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)this.getPageCache().get("jobFormInfo"), JobFormInfo.class);
        } else if (this.jobFormInfo == null) {
            String str = (String)this.getView().getFormShowParameter().getCustomParam("pmts_clientjobinfo");
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            this.jobFormInfo = (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
        }
        return this.jobFormInfo;
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("sch_taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid") : this.getPageCache().get("sch_taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("sch_taskid", taskId);
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        return StringUtils.isBlank((CharSequence)start) ? false : Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        return StringUtils.isBlank((CharSequence)finished) ? false : Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put("isfinished", String.valueOf(finished));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnstop", "btnmin"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (StringUtils.isNotBlank(customParams.get("pmts_clientjobinfo"))) {
            JobFormInfo jobFormInfo = this.getJobFormInfo();
            this.init();
            this.startBar();
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop", "btnmin"});
            String taskId = this.getTaskId();
            if (StringUtils.isBlank((CharSequence)taskId)) {
                this.setProgressDesc(ResManager.loadKDString((String)"\u51c6\u5907\u542f\u52a8\u4efb\u52a1", (String)"TaskProgressFormEdit_1", (String)"bos-schedule-form", (Object[])new Object[0]));
            } else {
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                bar.setPercent(progress);
                this.setProgressDesc(taskInfo.getDesc());
                if (jobFormInfo != null) {
                    this.setButtonVisible(jobFormInfo);
                }
            }
        }
    }

    private void init() {
        ArrayList<DynamicObject> detailobjs = new ArrayList<DynamicObject>(8);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject tslObj = BusinessDataServiceHelper.newDynamicObject((String)"pmts_taskschedule_log");
        MainEntityType mEntity = MetadataServiceHelper.getDataEntityType((String)"pmts_taskschedule_log");
        EntryProp type = (EntryProp)mEntity.getProperties().get((Object)"entryentity");
        DynamicObjectType entrytype = type.getDynamicCollectionItemPropertyType();
        Long id = this.genLongId("pmts_taskschedule_log");
        this.getPageCache().put("logid", String.valueOf(id));
        tslObj.set("id", (Object)id);
        String number = CodeRuleServiceHelper.getNumber((String)"pmts_taskschedule_log", (DynamicObject)tslObj, (String)String.valueOf(customParams.get("orgid")));
        tslObj.set("number", (Object)number);
        tslObj.set("scheme", customParams.get("scmId"));
        tslObj.set("org", customParams.get("orgid"));
        tslObj.set("datatime", (Object)new Date());
        tslObj.set("excutor", (Object)RequestContext.get().getCurrUserId());
        tslObj.set("calstatus", (Object)"1");
        tslObj.set("starttime", (Object)new Date());
        tslObj.set("status", (Object)"A");
        tslObj.set("enable", (Object)"1");
        DynamicObjectCollection tslEntrys = tslObj.getDynamicObjectCollection("entryentity");
        DynamicObject tslEntry = this.newDynamicObject(entrytype);
        tslEntry.set("project", customParams.get("projectid"));
        PmtsTaskScheduleParamter pmtsParam = new PmtsTaskScheduleParamter();
        DynamicObject taskSecheme = BusinessDataServiceHelper.loadSingle(customParams.get("scmId"), (String)"pmts_taskscheme");
        DynamicObject detailObj = this.newDynamicObject("pmts_taskschedule_detail");
        long detailid = this.genLongId("pmts_taskschedule_detail");
        detailObj.set("id", (Object)detailid);
        detailObj.set("project", customParams.get("projectid"));
        detailObj.set("org", customParams.get("orgid"));
        pmtsParam.setDatatime(new Date().getTime());
        pmtsParam.setPlanparam(taskSecheme.getLong("id"));
        if (Objects.nonNull(taskSecheme.get("caltype")) && StringUtils.equals((CharSequence)taskSecheme.getString("caltype"), (CharSequence)"2")) {
            pmtsParam.setCalbyhour(true);
        }
        pmtsParam.setProjectid(((Long)customParams.get("projectid")).longValue());
        pmtsParam.setOrgid(Long.parseLong(customParams.get("orgid").toString()));
        pmtsParam.setDelaytype(taskSecheme.getString("calendargroup"));
        pmtsParam.setLogictype(taskSecheme.getString("logicgroup"));
        pmtsParam.setIsusehopetime(taskSecheme.getBoolean("isexpectdate"));
        pmtsParam.setCrossgroup(taskSecheme.getString("crossgroup"));
        pmtsParam.setStartTime(System.currentTimeMillis());
        pmtsParam.setCallogid(id.longValue());
        pmtsParam.setPlanTypeid(Long.parseLong(customParams.get("plantype").toString()));
        pmtsParam.setWbsid((Set)customParams.get("wbsId"));
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("pmts");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName("PmtsTask Schedule");
        String objid = UUID.randomUUID().toString();
        jobInfo.setId(objid);
        jobInfo.setRunByLang(Lang.get());
        String taskId = String.valueOf(this.genDBLongId("T_SCH_TASK"));
        jobInfo.setTaskId(taskId);
        jobInfo.setTaskClassname("kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleExcutor");
        HashMap<String, PmtsTaskScheduleParamter> params = new HashMap<String, PmtsTaskScheduleParamter>();
        params.put("params", pmtsParam);
        jobInfo.setParams(params);
        StringBuilder numBd = new StringBuilder();
        DecimalFormat df = new DecimalFormat("00");
        numBd.append(number).append("_").append(df.format(1L));
        detailObj.set("number", (Object)numBd.toString());
        detailObj.set("calclog", (Object)id);
        detailObj.set("taskid", (Object)taskId);
        detailObj.set("status", (Object)"A");
        detailObj.set("enable", (Object)"1");
        detailobjs.add(detailObj);
        tslEntry.set("detail", detailObj.getPkValue());
        tslEntry.set("taskid", (Object)taskId);
        tslEntrys.add((Object)tslEntry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tslObj});
        SaveServiceHelper.save((DynamicObject[])detailobjs.toArray(new DynamicObject[detailobjs.size()]));
        this.jobFormInfo.setJobInfo(jobInfo);
        this.getPageCache().put("jobFormInfo", SerializationUtils.toJsonString((Object)this.jobFormInfo));
    }

    private void disTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
                jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
            }
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            Long tasklogid = Long.parseLong(this.getPageCache().get("logid"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)tasklogid, (String)"pmts_taskschedule_log");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                ((DynamicObject)entryentity.get(0)).set("taskid", (Object)taskId);
            }
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.setTaskId(taskId);
            this.setButtonVisible(jobFormInfo);
        }
        this.doTranBackground();
    }

    public void click(EventObject e) {
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnstop")) {
            this.stop();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnmin")) {
            this.tranBackground();
        }
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
        } else if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.complete(taskInfo, e);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                String desc = taskInfo.getDesc();
                e.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)desc)) {
                    this.setProgressDesc(desc);
                }
            }
        }
        e.setProgress(100);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String taskId;
        JobFormInfo jobFormInfo;
        super.beforeClosed(e);
        if (!this.isStart()) {
            e.setCancel(true);
        } else if (!(this.canClose || this.isFinished() || (jobFormInfo = this.getJobFormInfo()) == null || StringUtils.isBlank((CharSequence)(taskId = this.getTaskId())))) {
            if (jobFormInfo.isCanStop()) {
                this.stop();
                e.setCancel(true);
            } else if (jobFormInfo.isCanBackground()) {
                this.tranBackground();
                e.setCancel(true);
            } else {
                e.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            this.startBar();
        } else if (StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"continue_background")) {
            this.doTranBackground();
        } else {
            this.doStop();
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)this.getView().getPageId());
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo != null) {
            if (StringUtils.isBlank((CharSequence)jobFormInfo.getJobInfo().getAppId())) {
                jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
            }
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            Long tasklogid = Long.parseLong(this.getPageCache().get("logid"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)tasklogid, (String)"pmts_taskschedule_log");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
                ((DynamicObject)entryentity.get(0)).set("taskid", (Object)taskId);
            }
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            this.setTaskId(taskId);
            this.setButtonVisible(jobFormInfo);
            this.doTranBackground();
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            if (TaskProgressFormEdit.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7", (String)"TaskProgressFormEdit_2", (String)"bos-schedule-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
            }
            this.stopBar();
        } else if (!isFinished) {
            e.setProgress(99);
            this.setProgressDesc(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5b8c\u6bd5", (String)"TaskProgressFormEdit_3", (String)"bos-schedule-form", (Object[])new Object[0]));
        } else {
            this.returnResult(null);
            if (StringUtils.equalsIgnoreCase((CharSequence)"COMPLETED", (CharSequence)taskInfo.getStatus())) {
                this.returnResult(taskInfo);
            }
            this.stopBar();
            e.setProgress(100);
            this.closeForm();
        }
    }

    private void stop() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_stop", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u6267\u884c", (String)"TaskProgressFormEdit_4", (String)"bos-schedule-form", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62\u6267\u884c", (String)"TaskProgressFormEdit_5", (String)"bos-schedule-form", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u7ec8\u6b62\u6267\u884c\uff1f", (String)"TaskProgressFormEdit_6", (String)"bos-schedule-form", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doStop() {
        this.startBar();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            ScheduleServiceHelper.stopTask((String)taskId);
            TaskClientProxy.suspend((JobFormInfo)this.jobFormInfo, (String)taskId);
        }
        this.getView().close();
    }

    private void tranBackground() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_background", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaskProgressFormEdit_7", (String)"bos-schedule-form", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u540e\u53f0\u6267\u884c", (String)"TaskProgressFormEdit_8", (String)"bos-schedule-form", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u4efb\u52a1\u8fd8\u6ca1\u6709\u6267\u884c\u5b8c\u6bd5\uff0c\u60a8\u662f\u5426\u786e\u8ba4\u8981\u8f6c\u5165\u540e\u53f0\u6267\u884c\uff1f", (String)"TaskProgressFormEdit_9", (String)"bos-schedule-form", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        this.stopBar();
    }

    private void doTranBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            taskInfo.setId(taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
                ThreadExecutorService threadExecutorService = MMCCommonThreadPoolUtil.getThreadExecutorService();
                threadExecutorService.execute((Runnable)subscriber, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
            }
        }
    }

    private void setProgressDesc(String desc) {
        Label lblDesc = (Label)this.getControl("lblprogress");
        lblDesc.setText(desc);
    }

    private void setButtonVisible(JobFormInfo jobFormInfo) {
        if (jobFormInfo.isCanStop()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnstop"});
        }
        if (jobFormInfo.isCanBackground()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmin"});
        }
    }

    private void returnResult(TaskInfo taskInfo) {
        Map<String, String> result = TaskProgressFormEdit.packageReturnResult(taskInfo);
        if (result != null) {
            this.getView().returnDataToParent(result);
        }
    }

    public static Map<String, String> packageReturnResult(TaskInfo taskInfo) {
        if (taskInfo == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (taskInfo != null) {
            String taskInfoStr = SerializationUtils.toJsonString((Object)taskInfo);
            result.put("taskinfo", taskInfoStr);
            result.put("taskend", String.valueOf(taskInfo.isTaskEnd()));
        }
        return result;
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && "true".equals(showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }
}

