/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.pmc.pmts.business.helper.TaskScheduleDetailHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class TaskScheduleLogEditPlugin
extends AbstractFormPlugin
implements ProgresssListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        EntryGrid stGrid = (EntryGrid)this.getControl("entryentity");
        stGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        DynamicObjectCollection tslEntrys = this.getModel().getEntryEntity("entryentity");
        if (tslEntrys.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u8fd0\u7b97\u9879\u76ee", (String)"TaskScheduleLogEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            bar.setPercent(100);
            return;
        }
        BigDecimal totalPS = new BigDecimal(tslEntrys.size());
        long maxEndtime = 0L;
        int mark = 0;
        BigDecimal currPS = BigDecimal.ZERO;
        for (int i = 0; i < tslEntrys.size(); ++i) {
            long temptime = 0L;
            String taskId = ((DynamicObject)tslEntrys.get(i)).getString("taskid");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            this.setEntryStatusAndDetail(taskInfo, i);
            if (taskInfo.isTaskEnd()) {
                currPS = currPS.add(BigDecimal.ONE);
                temptime = taskInfo.getEndTime();
                if (mark == 0) {
                    maxEndtime = temptime;
                }
                if (temptime > maxEndtime) {
                    maxEndtime = temptime;
                }
                ++mark;
            }
            if (!taskInfo.isFailure() && !Objects.isNull(taskInfo.getId())) continue;
            currPS = currPS.add(BigDecimal.ONE);
        }
        int progress = currPS.divide(totalPS, 2, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)).intValue();
        bar.setPercent(progress);
        this.getModel().setValue("calculatepro", (Object)progress);
        if (progress == 100) {
            Date sttime = (Date)this.getModel().getValue("starttime");
            if (maxEndtime > 0L) {
                long callong = maxEndtime - sttime.getTime();
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(maxEndtime);
                this.getModel().setValue("endtime", (Object)c.getTime());
                this.getModel().setValue("totalcost", (Object)callong);
            }
            this.getModel().setValue("calculatepro", (Object)progress);
            this.getModel().setValue("calstatus", (Object)"4");
            OperationResult rs = OperationServiceHelper.executeOperate((String)"save", (String)"pmts_taskschedule_log", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()}, null);
            this.getModel().setDataChanged(false);
        }
    }

    public void onProgress(ProgressEvent e) {
        DynamicObjectCollection tslEntrys = this.getModel().getEntryEntity("entryentity");
        if (tslEntrys.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u8fd0\u7b97\u9879\u76ee", (String)"TaskScheduleLogEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            e.setProgress(100);
        }
        BigDecimal totalPS = new BigDecimal(tslEntrys.size());
        long maxEndtime = 0L;
        int mark = 0;
        BigDecimal currPS = BigDecimal.ZERO;
        for (int i = 0; i < tslEntrys.size(); ++i) {
            long temptime = 0L;
            String taskId = ((DynamicObject)tslEntrys.get(i)).getString("taskid");
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            this.setEntryStatusAndDetail(taskInfo, i);
            if (!taskInfo.isTaskEnd()) continue;
            currPS = currPS.add(BigDecimal.ONE);
            temptime = taskInfo.getEndTime();
            if (mark == 0) {
                maxEndtime = temptime;
            }
            if (temptime > maxEndtime) {
                maxEndtime = temptime;
            }
            ++mark;
        }
        int progress = currPS.divide(totalPS, 2, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)).intValue();
        e.setProgress(progress);
        this.getModel().setValue("calculatepro", (Object)progress);
        if (progress == 100) {
            Date sttime = (Date)this.getModel().getValue("starttime");
            long callong = maxEndtime - sttime.getTime();
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(maxEndtime);
            this.getModel().setValue("endtime", (Object)c.getTime());
            this.getModel().setValue("totalcost", (Object)callong);
            this.getModel().setValue("calculatepro", (Object)progress);
            this.getModel().setValue("calstatus", (Object)"4");
            OperationResult rs = OperationServiceHelper.executeOperate((String)"save", (String)"pmts_taskschedule_log", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
            this.getModel().setDataChanged(false);
        }
        this.getModel().setDataChanged(false);
    }

    private void setEntryStatusAndDetail(TaskInfo taskInfo, int i) {
        String status = taskInfo.getStatus();
        DynamicObject pjObj = (DynamicObject)this.getModel().getValue("project", i);
        DynamicObject logObj = this.getModel().getDataEntity();
        if (taskInfo == null || logObj == null || pjObj == null) {
            this.getModel().setValue("calresult", (Object)"2", i);
        } else {
            PmtsTaskRunTimeInfo rInfo = new PmtsTaskRunTimeInfo(logObj.getLong("id"), pjObj.getLong("id"));
            long dtlId = TaskScheduleDetailHelper.getDetailid((PmtsTaskRunTimeInfo)rInfo);
            this.getModel().setValue("detail", (Object)dtlId, i);
            if (StringUtils.equals((CharSequence)status, (CharSequence)"COMPLETED")) {
                this.getModel().setValue("calresult", (Object)"3", i);
                long cost = taskInfo.getEndTime() - taskInfo.getDispachTime();
                this.getModel().setValue("cost", (Object)cost, i);
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)"FAILED")) {
                this.getModel().setValue("calresult", (Object)"2", i);
                long cost = taskInfo.getEndTime() - taskInfo.getDispachTime();
                this.getModel().setValue("cost", (Object)cost, i);
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)"RUNNING")) {
                this.getModel().setValue("calresult", (Object)"1", i);
                long cost = taskInfo.getRunTime() - taskInfo.getDispachTime();
                this.getModel().setValue("cost", (Object)cost, i);
            } else {
                this.getModel().setValue("calresult", (Object)"2", i);
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void hyperLinkClick(HyperLinkClickEvent he) {
        if (he.getFieldName().equals("detail")) {
            DynamicObject dtlObj = (DynamicObject)this.getModel().getValue("detail", he.getRowIndex());
            this.showDetailLog(dtlObj.getPkValue());
        }
    }

    private void showDetailLog(Object pkValue) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("pmts_taskschedule_detail");
        param.setPkId(pkValue);
        param.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)param);
    }
}

