/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.pmc.pmts.business.helper.TaskScheduleDetailHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskRunTimeInfo;

public class TaskScheduleLogListPlugin
extends AbstractListPlugin {
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("stop")) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRow row = list.getCurrentSelectedRowInfo();
            if (Objects.isNull(row)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"TaskScheduleLogListPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                return;
            }
            Object pk = row.getPrimaryKeyValue();
            DynamicObject logObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pmts_taskschedule_log");
            if (!logObj.getString("calstatus").equals("1")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u6267\u884c\u5b8c\u6bd5\uff0c\u65e0\u6cd5\u7ec8\u6b62\u8fd0\u7b97\u3002", (String)"TaskScheduleLogListPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entrys = logObj.getDynamicObjectCollection("entryentity");
            if (entrys.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u9879\u76ee\u8fd0\u7b97\u3002", (String)"TaskScheduleLogListPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject entry : entrys) {
                String taskid = entry.getString("taskid");
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskid);
                if (taskInfo.isTaskEnd()) continue;
                ScheduleServiceHelper.stopTask((String)taskid);
            }
            logObj.set("calstatus", (Object)"3");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        DynamicObject[] logObjs;
        for (DynamicObject logObj : logObjs = BusinessDataServiceHelper.load((String)"pmts_taskschedule_log", (String)this.getSelects(), (QFilter[])new QFilter("calstatus", "=", (Object)"1").toArray())) {
            DynamicObjectCollection entryentity = logObj.getDynamicObjectCollection("entryentity");
            boolean iscomplete = true;
            long maxEndtime = 0L;
            int mark = 0;
            BigDecimal totalPS = new BigDecimal(entryentity.size());
            BigDecimal currPS = BigDecimal.ZERO;
            for (DynamicObject entry : entryentity) {
                String taskId = entry.getString("taskid");
                TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
                this.setEntryStatusAndDetail(taskInfo, entry, logObj);
                if (!StringUtils.equals((CharSequence)taskInfo.getStatus(), (CharSequence)"COMPLETED")) {
                    iscomplete = false;
                }
                long temptime = 0L;
                if (!taskInfo.isTaskEnd()) continue;
                temptime = taskInfo.getEndTime();
                if (mark == 0) {
                    maxEndtime = temptime;
                }
                if (temptime > maxEndtime) {
                    maxEndtime = temptime;
                }
                ++mark;
            }
            int progress = 0;
            if (iscomplete) {
                progress = 100;
                long callong = maxEndtime - logObj.getDate("starttime").getTime();
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(maxEndtime);
                logObj.set("endtime", (Object)c.getTime());
                logObj.set("totalcost", (Object)callong);
                logObj.set("calstatus", (Object)"4");
            } else {
                progress = currPS.divide(totalPS, 2, RoundingMode.HALF_DOWN).multiply(new BigDecimal(100)).intValue();
            }
            logObj.set("calculatepro", (Object)progress);
        }
        SaveServiceHelper.save((DynamicObject[])logObjs);
    }

    private void setEntryStatusAndDetail(TaskInfo taskInfo, DynamicObject entry, DynamicObject logObj) {
        DynamicObject pjObj = entry.getDynamicObject("project");
        if (taskInfo == null || logObj == null || pjObj == null) {
            entry.set("calresult", (Object)"2");
        } else {
            String status = taskInfo.getStatus();
            PmtsTaskRunTimeInfo rInfo = new PmtsTaskRunTimeInfo(logObj.getLong("id"), pjObj.getLong("id"));
            long dtlId = TaskScheduleDetailHelper.getDetailid((PmtsTaskRunTimeInfo)rInfo);
            entry.set("detail", (Object)dtlId);
            if (StringUtils.equals((CharSequence)status, (CharSequence)"COMPLETED")) {
                entry.set("calresult", (Object)"3");
                long cost = taskInfo.getEndTime() - taskInfo.getDispachTime();
                entry.set("cost", (Object)cost);
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)"FAILED")) {
                entry.set("calresult", (Object)"2");
                long cost = taskInfo.getEndTime() - taskInfo.getDispachTime();
                entry.set("cost", (Object)cost);
            } else if (StringUtils.equals((CharSequence)status, (CharSequence)"RUNNING")) {
                entry.set("calresult", (Object)"1");
                long cost = taskInfo.getRunTime() - taskInfo.getDispachTime();
                entry.set("cost", (Object)cost);
            } else {
                entry.set("calresult", (Object)"2");
            }
        }
    }

    private String getSelects() {
        return "calstatus,starttime,endtime,totalcost,calculatepro,entryentity.cost,entryentity.project,entryentity.calresult,entryentity.taskid,entryentity.detail";
    }
}

