/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.base;

import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmc.pmts.business.task.taskschedule.model.PmtsTaskScheduleParamter;

public class TaskScheduleUiPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String SCHEDULING_ORG = "org";
    public static final String SCHEDULING_DATE = "plandate";
    public static final String PROJECT = "project";
    public static final String SCHEDULING_SCHEME = "scheduling_scheme";
    public static final String SCHEDULING_ENTRY = "entryentity";
    public static final String PROJECT_ORG = "createorg";
    public static final String SCHEME_ORG = "org";
    private static final String START_CAL = "calculate";
    private static final String PMTS_TASKSCHEME = "pmts_taskscheme";
    private static final String MRP_MUTEX_GROUP_ID = "taskscheduling";
    private static final String MRP_CACULATE_lOG = "mrp_caculate_log";
    private static final String MRP_TASK_LOG = "mrp_task_log";
    private static final String CONFIRM_EXEC = "confirm_exec";
    private static final String CACULATELOG_CACHE = "caculateLog_cache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (Objects.nonNull(formShowParameter.getCustomParam("orgId"))) {
            model.setValue("org", formShowParameter.getCustomParam("orgId"));
        } else {
            Set ids = this.getOrgIds();
            long orgId = RequestContext.get().getOrgId();
            if (!ids.isEmpty()) {
                if (ids.contains(orgId)) {
                    model.setValue("org", (Object)orgId);
                } else {
                    model.setValue("org", ids.iterator().next());
                }
            }
        }
        if (Objects.nonNull(formShowParameter.getCustomParam("sechemId"))) {
            model.setValue(SCHEDULING_SCHEME, formShowParameter.getCustomParam("sechemId"));
        }
        if (Objects.nonNull(formShowParameter.getCustomParam("datatime"))) {
            long datatime = (Long)formShowParameter.getCustomParam("datatime");
            Calendar cinst = Calendar.getInstance();
            cinst.setTimeInMillis(datatime);
            model.setValue(SCHEDULING_DATE, (Object)cinst.getTime());
        } else {
            model.setValue(SCHEDULING_DATE, (Object)new Date());
        }
        if (Objects.nonNull(formShowParameter.getCustomParam("projectId"))) {
            model.setValue(PROJECT, formShowParameter.getCustomParam("projectId"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (START_CAL.equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"TaskScheduleUiPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "scheduling_scheme": {
                BasedataEdit planType = (BasedataEdit)this.getControl("plantype");
                if (Objects.isNull(newValue)) {
                    this.getModel().setValue("plantype", (Object)0);
                    planType.setMustInput(false);
                } else {
                    DynamicObject scObj = (DynamicObject)newValue;
                    if (scObj.getBoolean("isbytype")) {
                        planType.setMustInput(true);
                    } else {
                        planType.setMustInput(false);
                    }
                }
                this.getView().updateView("isbytype");
                break;
            }
        }
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
        String schedulingSchemeId = schedulingScheme.getPkValue().toString();
        this.excuteTaskSchedule(schedulingScheme.getPkValue());
    }

    private void excuteTaskSchedule(Object pkId) {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        long orgId = (Long)orgObj.getPkValue();
        DynamicObject scmObj = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
        long scmId = (Long)scmObj.getPkValue();
        Date datatime = (Date)this.getModel().getValue(SCHEDULING_DATE);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(SCHEDULING_ENTRY);
        if (entrys.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskScheduleUiPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject entry : entrys) {
            if (!Objects.isNull(entry.get(PROJECT))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaskScheduleUiPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject tslObj = this.excute(orgId, scmId, datatime, entrys);
        this.showTSLogForm(tslObj.getPkValue());
    }

    private void showTSLogForm(Object pkValue) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("pmts_taskschedule_log");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId(pkValue);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("pmts_taskschedule_log", pkValue);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private DynamicObject excute(long orgId, long scmId, Date datatime, DynamicObjectCollection entrys) {
        long planTypeid = 0L;
        if (Objects.nonNull(this.getModel().getValue("plantype"))) {
            DynamicObject tyObj = (DynamicObject)this.getModel().getValue("plantype");
            planTypeid = tyObj.getLong("id");
        }
        ArrayList<DynamicObject> detailobjs = new ArrayList<DynamicObject>(8);
        ArrayList<JobInfo> jobs = new ArrayList<JobInfo>(8);
        DynamicObject tslObj = BusinessDataServiceHelper.newDynamicObject((String)"pmts_taskschedule_log");
        MainEntityType mEntity = MetadataServiceHelper.getDataEntityType((String)"pmts_taskschedule_log");
        EntryProp type = (EntryProp)mEntity.getProperties().get((Object)SCHEDULING_ENTRY);
        DynamicObjectType entrytype = type.getDynamicCollectionItemPropertyType();
        Long id = this.genLongId("pmts_taskschedule_log");
        tslObj.set("id", (Object)id);
        String number = CodeRuleServiceHelper.getNumber((String)"pmts_taskschedule_log", (DynamicObject)tslObj, (String)String.valueOf(orgId));
        tslObj.set("number", (Object)number);
        tslObj.set("scheme", (Object)scmId);
        tslObj.set("org", (Object)orgId);
        tslObj.set("datatime", (Object)datatime);
        tslObj.set("excutor", (Object)RequestContext.get().getCurrUserId());
        tslObj.set("calstatus", (Object)"1");
        tslObj.set("starttime", (Object)new Date());
        tslObj.set("status", (Object)"A");
        tslObj.set("enable", (Object)"1");
        DynamicObjectCollection tslEntrys = tslObj.getDynamicObjectCollection(SCHEDULING_ENTRY);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject tslEntry = this.newDynamicObject(entrytype);
            if (Objects.isNull(entry.get(PROJECT))) continue;
            DynamicObject pjObj = entry.getDynamicObject(PROJECT);
            long pjId = (Long)pjObj.getPkValue();
            tslEntry.set(PROJECT, (Object)entry.getDynamicObject(PROJECT));
            PmtsTaskScheduleParamter pmtsParam = new PmtsTaskScheduleParamter();
            DynamicObject taskSecheme = BusinessDataServiceHelper.loadSingle((Object)scmId, (String)PMTS_TASKSCHEME);
            if (Objects.isNull(taskSecheme)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u65b9\u6848\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"TaskScheduleUiPlugin_4", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject detailObj = this.newDynamicObject("pmts_taskschedule_detail");
            long detailid = this.genLongId("pmts_taskschedule_detail");
            detailObj.set("id", (Object)detailid);
            detailObj.set(PROJECT, (Object)pjId);
            detailObj.set("org", (Object)orgId);
            pmtsParam.setDatatime(datatime.getTime());
            pmtsParam.setPlanparam(taskSecheme.getLong("id"));
            if (Objects.nonNull(taskSecheme.get("caltype")) && StringUtils.equals((CharSequence)taskSecheme.getString("caltype"), (CharSequence)"2")) {
                pmtsParam.setCalbyhour(true);
            }
            pmtsParam.setProjectid(pjId);
            pmtsParam.setOrgid(orgId);
            pmtsParam.setDelaytype(taskSecheme.getString("calendargroup"));
            pmtsParam.setLogictype(taskSecheme.getString("logicgroup"));
            pmtsParam.setIsusehopetime(taskSecheme.getBoolean("isexpectdate"));
            pmtsParam.setCrossgroup(taskSecheme.getString("crossgroup"));
            pmtsParam.setStartTime(System.currentTimeMillis());
            pmtsParam.setCallogid(id.longValue());
            pmtsParam.setPlanTypeid(planTypeid);
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("pmts");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setName("PmtsTask Schedule");
            jobInfo.setRunByLang(Lang.get());
            String objid = UUID.randomUUID().toString();
            jobInfo.setId(objid);
            String taskId = String.valueOf(this.genDBLongId("T_SCH_TASK"));
            jobInfo.setTaskId(taskId);
            jobInfo.setTaskClassname("kd.pmc.pmts.business.task.taskschedule.schedule.steps.PmtsTaskScheduleExcutor");
            HashMap<String, PmtsTaskScheduleParamter> params = new HashMap<String, PmtsTaskScheduleParamter>();
            params.put("params", pmtsParam);
            jobInfo.setParams(params);
            jobs.add(jobInfo);
            StringBuilder numBd = new StringBuilder();
            DecimalFormat df = new DecimalFormat("00");
            numBd.append(number).append("_").append(df.format(i + 1));
            detailObj.set("number", (Object)numBd.toString());
            detailObj.set("calclog", (Object)id);
            detailObj.set("taskid", (Object)taskId);
            detailObj.set("status", (Object)"A");
            detailObj.set("enable", (Object)"1");
            detailobjs.add(detailObj);
            tslEntry.set("detail", detailObj.getPkValue());
            tslEntry.set("taskid", (Object)taskId);
            tslEntrys.add((Object)tslEntry);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tslObj});
        SaveServiceHelper.save((DynamicObject[])detailobjs.toArray(new DynamicObject[detailobjs.size()]));
        for (JobInfo job : jobs) {
            JobDispatcherProxy jobDispatcherProxy = new JobDispatcherProxy();
            jobDispatcherProxy.dispatch(job);
        }
        return tslObj;
    }

    private DynamicObject newDynamicObject(DynamicObjectType type) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(type);
    }

    private DynamicObject newDynamicObject(String types) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(types);
    }

    private long genLongId(String type) {
        ORM orm = ORM.create();
        return orm.genLongId(type);
    }

    private long genDBLongId(String type) {
        return DB.genLongId((String)type);
    }

    public void beforeF7Select(BeforeF7SelectEvent bfe) {
        if (bfe.getProperty().getName().equals("org")) {
            bfe.addCustomQFilter(new QFilter("id", "in", (Object)this.getOrgIds()));
        }
        if (bfe.getProperty().getName().equals(SCHEDULING_SCHEME)) {
            bfe.addCustomQFilter(new QFilter("enable", "=", (Object)"1"));
        }
    }

    private Set getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            HashSet ids = Sets.newHashSetWithExpectedSize((int)structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            HashSet<Long> orgIds = new HashSet<Long>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)"pmts_taskschedule_ui", (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new HashSet();
    }
}

