/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class WbsDeliveryEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit wbs = (BasedataEdit)this.getView().getControl("wbsnum");
        BasedataEdit unit = (BasedataEdit)this.getView().getControl("unit");
        wbs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.enableSet(i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            int rowIndex = entryEntity.size() - 1;
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"filename", "content"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        String billFormId = showParameter.getBillFormId();
        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmts_wbs")) {
            this.beforeF7SelectWbs(arg0);
        } else if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"bd_measureunits")) {
            this.beforeF7SelectUnit(arg0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"projectnum")) {
            this.getModel().setValue("wbsnum", null);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"deliverytype")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.enableSet(rowIndex);
            this.setNull(rowIndex);
        }
    }

    private void setNull(int rowIndex) {
        this.getModel().setValue("proname", null, rowIndex);
        this.getModel().setValue("pronum", null, rowIndex);
        this.getModel().setValue("materialnum", null, rowIndex);
        this.getModel().setValue("filename", null, rowIndex);
        this.getModel().setValue("content", null, rowIndex);
    }

    private void enableSet(int rowIndex) {
        String deliveryType = (String)this.getModel().getValue("deliverytype", rowIndex);
        if (StringUtils.equals((CharSequence)deliveryType, (CharSequence)"A")) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"filename", "content"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialnum"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"proname"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"pronum"});
        } else if (StringUtils.equals((CharSequence)deliveryType, (CharSequence)"B")) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialnum"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"proname"});
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"pronum"});
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"filename", "content"});
        }
    }

    private void beforeF7SelectWbs(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
        if (project == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u53f7\u3002", (String)"WbsDeliveryEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            Object projectId = project.getPkValue();
            QFilter qFilter = new QFilter("projectnum", "=", projectId);
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("status", "=", (Object)"C");
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(qFilter);
            showParameter.getListFilterParameter().setQFilters(filters);
        }
    }

    private void beforeF7SelectUnit(BeforeF7SelectEvent e) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject materialno = entryRowEntity.getDynamicObject("materialnum");
        if (null == materialno) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"WbsDeliveryEditPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject baseunit = materialno.getDynamicObject("baseunit");
        ArrayList<Long> pkList = new ArrayList<Long>();
        if (baseunit != null) {
            pkList.add(baseunit.getLong("id"));
        }
        DynamicObjectCollection entryentitys = materialno.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryentity : entryentitys) {
            pkList.add(entryentity.getLong("measureunitid_id"));
        }
        QFilter qfilter = new QFilter("id", "in", pkList);
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qfilter);
    }
}

