/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.common.util.CommonFilterConditionUtil;

public class OtpBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        EntryGrid entryGrid;
        super.registerListener(e);
        this.addClickListeners(new String[]{"mworkorderno"});
        BasedataEdit fileEdit = (BasedataEdit)this.getView().getControl("mmresplanno");
        if (fileEdit != null) {
            fileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            fileEdit.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        }
        if ((entryGrid = (EntryGrid)this.getControl("workcardinfo")) != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "mmresplanno": {
                this.clearResourcePlanFields();
                this.resoucePlanValueChanged();
                break;
            }
            case "wktimeremark": {
                this.wkTimeRemarkChange();
                break;
            }
            case "mworkorderno": {
                Boolean bl = this.getModel().getValue("mworkorderno") == "";
                if (bl.booleanValue()) {
                    this.getView().invokeOperation("deleteentry1");
                }
            }
            case "fsontime": {
                this.clearDalayInfo();
            }
        }
    }

    private void clearDalayInfo() {
        this.getModel().setValue("responsparty", (Object)"");
        this.getModel().setValue("delayclass", (Object)"");
        this.getModel().setValue("delaydays", (Object)0);
        this.getModel().setValue("delayres", (Object)"");
    }

    private void wkTimeRemarkChange() {
        String userName = RequestContext.get().getUserName();
        String str = String.format(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", (String)"OtpBillPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), new Object[0]);
        SimpleDateFormat sdf = new SimpleDateFormat(str);
        String changeTime = sdf.format(new Date());
        this.getModel().setValue("wtlastmodiftime", (Object)changeTime);
        this.getModel().setValue("wtlastmodifier", (Object)userName);
    }

    private void resoucePlanValueChanged() {
        DynamicObject mmresplannoObject = (DynamicObject)this.getModel().getValue("mmresplanno");
        if (mmresplannoObject != null) {
            String selectResFields = this.getResoucePlanSelectFields();
            String selectProFields = this.getProjectSelectFields();
            QFilter[] qFilters = new QFilter("id", "=", mmresplannoObject.getPkValue()).toArray();
            DynamicObject queryResultObject = QueryServiceHelper.queryOne((String)"pmpd_resourceplan", (String)selectResFields, (QFilter[])qFilters);
            this.setResoucePlanValue(queryResultObject);
            DynamicObjectCollection queryColl = QueryServiceHelper.query((String)"pmpd_resourceplan", (String)selectProFields, (QFilter[])qFilters);
            this.setProjectValue(queryColl);
        }
    }

    private void setResoucePlanValue(DynamicObject queryResultObject) {
        this.getModel().setValue("workscope", (Object)queryResultObject.getLong("workscope"));
        this.getModel().setValue("device", (Object)queryResultObject.getLong("overdevice"));
        this.getModel().setValue("devicetype", (Object)queryResultObject.getLong("model"));
        this.getModel().setValue("customer", (Object)queryResultObject.getLong("customer"));
    }

    private String getProjectSelectFields() {
        String selectFields = "entry_project.projcet";
        return selectFields;
    }

    private void setProjectValue(DynamicObjectCollection queryColl) {
        for (DynamicObject projectObject : queryColl) {
            int[] workcardinfos = this.getModel().batchCreateNewEntryRow("projectinfo", 1);
            this.getModel().setValue("projectno", (Object)projectObject.getLong("entry_project.projcet"), workcardinfos[0]);
        }
    }

    private String getResoucePlanSelectFields() {
        String selectFields = "workscope,overdevice,model,customer";
        return selectFields;
    }

    private void clearResourcePlanFields() {
        IDataModel model = this.getModel();
        this.deleteBillDate();
        this.deleteEntry(model, "workcardinfo");
        this.deleteEntry(model, "projectinfo");
    }

    private void deleteBillDate() {
        this.getModel().setValue("customer", (Object)0L);
        this.getModel().setValue("device", (Object)0L);
        this.getModel().setValue("devicetype", (Object)0L);
        this.getModel().setValue("workscope", (Object)0L);
    }

    private void deleteEntry(IDataModel model, String entryName) {
        int cnt = model.getEntryRowCount(entryName);
        if (cnt > 0) {
            int[] deleteIndex = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                deleteIndex[i] = i;
            }
            model.deleteEntryRows(entryName, deleteIndex);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"mworkorderno", (CharSequence)key)) {
            this.showWorkCardF7();
        }
    }

    private void showWorkCardF7() {
        Object[] dObjArray;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mroorder", (boolean)true);
        String str = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u5217\u8868", (String)"OtpBillPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), new Object[0]);
        listShowParameter.setCaption(str);
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("projectinfo");
        DynamicObjectCollection dynamicProjectsCollection = new DynamicObjectCollection();
        if (dynamicObjectCollection.size() > 0) {
            for (DynamicObject dObj : dynamicObjectCollection) {
                if (dObj == null || dObj.getDynamicObject("projectno") == null) continue;
                dynamicProjectsCollection.add((Object)dObj.getDynamicObject("projectno"));
            }
        }
        Object[] objectArray = dObjArray = dynamicProjectsCollection == null ? null : this.collToIdObjectArray(dynamicProjectsCollection);
        if (dObjArray != null) {
            qFilters.add(new QFilter("treeentryentity.project.id", "in", (Object)dObjArray));
            qFilters.add(new QFilter("billstatus", "=", (Object)"B").or(new QFilter("billstatus", "=", (Object)"C")));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mworkorderno"));
            listShowParameter.setAppId("pom");
            listShowParameter.setCustomParam("ServiceAppId", (Object)"pom");
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else {
            str = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u4e3a\u7a7a", (String)"OtpBillPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showTipNotification(str);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"mworkorderno", (CharSequence)actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            this.fillDatas(returnData);
        }
    }

    private void fillDatas(ListSelectedRowCollection returnData) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("workcardinfo");
        Object[] primaryKeyValues = returnData.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        String selectFields = "billno,treeentryentity.workcard.id";
        DynamicObjectCollection selectCollect = QueryServiceHelper.query((String)"pom_mroorder", (String)selectFields, (QFilter[])qFilter.toArray());
        Iterator iterator = selectCollect.iterator();
        int num = 0;
        while (iterator.hasNext()) {
            DynamicObject selectRow = (DynamicObject)iterator.next();
            if (++num == 1) {
                this.getModel().setValue("mworkorderno", selectRow.get("billno"), rowIndex);
                this.getModel().setValue("workcardno", this.getWorkCardBillno(selectRow.getLong("treeentryentity.workcard.id")), rowIndex);
                continue;
            }
            int[] workcardinfos = this.getModel().batchCreateNewEntryRow("workcardinfo", 1);
            this.getModel().setValue("mworkorderno", selectRow.get("billno"), workcardinfos[0]);
            this.getModel().setValue("workcardno", this.getWorkCardBillno(selectRow.getLong("treeentryentity.workcard.id")), workcardinfos[0]);
        }
    }

    private Object getWorkCardBillno(long id) {
        String selectFields = "id,number";
        QFilter[] qFilters = new QFilter("id", "=", (Object)id).toArray();
        DynamicObject dobj = QueryServiceHelper.queryOne((String)"mpdm_mrocardroute", (String)selectFields, (QFilter[])qFilters);
        return dobj == null ? null : dobj.get("number");
    }

    private Object[] collToIdObjectArray(DynamicObjectCollection dynamicProjectsCollection) {
        int size = dynamicProjectsCollection.size();
        Object[] objectArray = new Object[size];
        int i = 0;
        for (DynamicObject dobj : dynamicProjectsCollection) {
            objectArray[i++] = dobj.getPkValue();
        }
        return objectArray;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object[] resobjects = this.getReviewedResNo();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "not in", (Object)resobjects));
        QFilter resourcePlanFilterConditon = CommonFilterConditionUtil.getResourcePlanFilterConditon();
        qFilters.add(resourcePlanFilterConditon);
        formShowParameter.getListFilterParameter().setQFilters(qFilters);
    }

    public Object[] getReviewedResNo() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = "mmresplanno";
        DynamicObjectCollection idCollection = QueryServiceHelper.query((String)"pmts_opt", (String)selectFields, (QFilter[])filter.toArray());
        Object[] resobjects = new Object[idCollection.size()];
        for (int i = 0; i < idCollection.size(); ++i) {
            resobjects[i] = ((DynamicObject)idCollection.get(i)).get("mmresplanno");
        }
        return resobjects;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String resourceBillno;
        int rowIndex = event.getRowIndex();
        String key = event.getFieldName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"mworkorderno") && rowIndex >= 0 && (resourceBillno = (String)this.getModel().getValue("mworkorderno", rowIndex)) != null) {
            this.showResourcePlan(resourceBillno, "pom_mroorder");
        }
    }

    private void showResourcePlan(String resourceBillno, String formId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter[] qFilters = new QFilter("billno", "=", (Object)resourceBillno).toArray();
        DynamicObject dObj = QueryServiceHelper.queryOne((String)"pom_mroorder", (String)"id", (QFilter[])qFilters);
        if (dObj != null) {
            long resourceId = dObj.getLong("id");
            showParameter.setPkId((Object)resourceId);
            showParameter.setFormId(formId);
            showParameter.setPageId(Long.toString(RequestContext.get().getCurrUserId()).concat("_").concat(Long.toString(resourceId)));
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        event.setCancel(true);
        this.showMMResplanno();
    }

    private void showMMResplanno() {
        DynamicObject mmresplanno = (DynamicObject)this.getModel().getValue("mmresplanno");
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("pmpd_resourceplan");
        String entityId = this.getView().getEntityId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mmresplanno != null) {
            baseShowParameter.setPkId(mmresplanno.getPkValue());
            baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mmresplanno"));
            baseShowParameter.setAppId("pmpd");
            baseShowParameter.setCustomParam("ServiceAppId", (Object)"pmpd");
            this.getView().showForm((FormShowParameter)baseShowParameter);
        }
    }
}

