/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmts.business.helper.ProjectWbsTaskHelper;

public class ProjectListingEditlPlugin
extends AbstractBillPlugIn {
    private static final String PROJECT = "project";
    private static final String WBS = "wbs";
    private static final String TASK = "task";
    private static final String PROJECTNUM = "projectnum";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl(PROJECT);
        project.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit wbs = (BasedataEdit)this.getControl(WBS);
        wbs.addBeforeF7SelectListener(this::beforeF7Select);
        wbs.addAfterF7SelectListener(this::afterF7Select);
        BasedataEdit task = (BasedataEdit)this.getControl(TASK);
        task.addBeforeF7SelectListener(this::beforeF7Select);
        task.addAfterF7SelectListener(this::afterF7Select);
        BasedataEdit unit = (BasedataEdit)this.getControl("unit");
        unit.addBeforeF7SelectListener(this::unitBeforeF7Select);
    }

    private void unitBeforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materialno");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"ProjectDemandBillPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            Object masterMaterial = material.get("masterid");
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            QFilter qFilter = new QFilter("materialid", "=", masterMaterial);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
            List unitIds = dynamicObjects.stream().map(o -> o.getLong("measureunitid")).collect(Collectors.toList());
            if (baseunit != null) {
                unitIds.add(baseunit.getLong("id"));
            }
            qFilter = new QFilter("id", "in", unitIds);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void afterF7Select(AfterF7SelectEvent evt) {
        ProjectWbsTaskHelper.afterF7Select((AfterF7SelectEvent)evt, (IDataModel)this.getModel());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        ProjectWbsTaskHelper.beforeF7Select((String)evt.getProperty().getName(), (DynamicObject)dataEntity, (ListShowParameter)showParameter, (String)this.getModel().getDataEntityType().getName());
    }
}

