/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmts.business.helper.ProjectWbsTaskHelper;

public class ProjectProductBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit wbs = (BasedataEdit)this.getView().getControl("wbs");
        wbs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        wbs.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getView().getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        project.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit task = (BasedataEdit)this.getView().getControl("task");
        task.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        task.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit unit = (BasedataEdit)this.getView().getControl("unit");
        unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        unit.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceID = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (sourceID.equals("project") || sourceID.equals("wbs") || sourceID.equals("task")) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            ProjectWbsTaskHelper.beforeF7Select((String)sourceID, (DynamicObject)dataEntity, (ListShowParameter)showParameter, (String)"pmts_production_list");
        } else if (sourceID.equals("unit")) {
            DynamicObject material = (DynamicObject)this.getModel().getValue("materialno");
            if (material == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"ProjectProductBillPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                DynamicObject baseunit = material.getDynamicObject("mftunit");
                QFilter qFilter = new QFilter("materialid", "=", masterMaterial.get("id"));
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{qFilter});
                List unitIds = dynamicObjects.stream().map(o -> o.getLong("measureunitid")).collect(Collectors.toList());
                if (baseunit != null) {
                    unitIds.add(baseunit.getLong("id"));
                }
                qFilter = new QFilter("id", "in", unitIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        ProjectWbsTaskHelper.afterF7Select((AfterF7SelectEvent)evt, (IDataModel)this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String oprKey = operate.getOperateKey();
        ArrayList<OperateErrorInfo> errorInfoes = new ArrayList<OperateErrorInfo>();
        OperationResult result = new OperationResult();
        if (StringUtils.equals((CharSequence)oprKey, (CharSequence)"push")) {
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!StringUtils.equals((CharSequence)billStatus, (CharSequence)"C")) {
                this.setErrorInfo(ResManager.loadKDString((String)"\u9879\u76ee\u751f\u4ea7\u6e05\u5355%s\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ProjectProductBillPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), errorInfoes);
            }
        } else if (StringUtils.equals((CharSequence)oprKey, (CharSequence)"delete") || StringUtils.equals((CharSequence)oprKey, (CharSequence)"unaudit")) {
            String billNo = (String)this.getModel().getValue("billno");
            String message = StringUtils.equals((CharSequence)oprKey, (CharSequence)"delete") ? String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u751f\u6210\u751f\u4ea7\u5de5\u5355\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ProjectProductBillPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u751f\u6210\u751f\u4ea7\u5de5\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProjectProductBillPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), billNo);
            Boolean ispush = (Boolean)this.getModel().getValue("ispush");
            if (ispush.booleanValue()) {
                this.setErrorInfo(message, errorInfoes);
            }
        }
        if (errorInfoes.size() > 0) {
            result.setAllErrorInfo(errorInfoes);
            this.getView().showOperationResult(result);
            args.setCancel(true);
        }
    }

    private void setErrorInfo(String msg, List<OperateErrorInfo> errorInfoes) {
        OperateErrorInfo error = new OperateErrorInfo();
        error.setMessage(msg);
        error.setEntityKey("pmts_production_list");
        error.setErrorCode("errorcode_001");
        error.setErrorLevel("Error");
        error.setPkValue(this.getModel().getValue("id"));
        errorInfoes.add(error);
    }
}

