/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Submit;
import kd.bos.form.FieldTip;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DecimalEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaskReportBillPlugin
extends AbstractBillPlugIn {
    private final String MORETHANZERO = ResManager.loadKDString((String)"\u5b9e\u9645\u5de5\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TaskReportBillPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar entrybar = (Toolbar)this.getControl("advcontoolbarap");
        entrybar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
    }

    private void initReportBillData() {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equalsIgnoreCase("bar_save") || evt.getItemKey().equalsIgnoreCase("bar_submit")) {
            String reporttype;
            switch (reporttype = (String)this.getModel().getValue("reporttype")) {
                case "2": {
                    this.checkPeriod(evt);
                    break;
                }
                case "3": {
                    this.checkHour(evt);
                    break;
                }
            }
        }
    }

    private void checkHour(BeforeItemClickEvent evt) {
        BigDecimal achour = Objects.isNull(this.getModel().getValue("actualhour")) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("actualhour");
        FieldTip achptips = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, "actualhour", ResManager.loadKDString((String)"\u5b9e\u9645\u5de5\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TaskReportBillPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        if (achour.compareTo(BigDecimal.ZERO) <= 0) {
            achptips.setSuccess(false);
            this.getView().showFieldTip(achptips);
            evt.setCancel(true);
        } else {
            achptips.setSuccess(true);
            this.getView().showFieldTip(achptips);
        }
    }

    private void checkPeriod(BeforeItemClickEvent evt) {
        BigDecimal acperiod = Objects.isNull(this.getModel().getValue("actualperiod")) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("actualperiod");
        FieldTip acptips = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, "actualperiod", this.MORETHANZERO);
        if (acperiod.compareTo(BigDecimal.ZERO) <= 0) {
            acptips.setSuccess(false);
            this.getView().showFieldTip(acptips);
            evt.setCancel(true);
        } else {
            acptips.setSuccess(true);
            this.getView().showFieldTip(acptips);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "actualhour": {
                this.actualhourChange(e);
                break;
            }
            case "needhour": {
                this.needhourChange(e);
                break;
            }
            case "actualperiod": {
                this.actualperiodChange(e);
                break;
            }
            case "needperiod": {
                this.needperiodChange(e);
                break;
            }
            case "actualpercent": {
                BigDecimal acprecent = Objects.isNull(e.getChangeSet()[0].getNewValue()) ? BigDecimal.ZERO : (BigDecimal)e.getChangeSet()[0].getNewValue();
                this.setActualEndDate(acprecent);
                break;
            }
        }
    }

    private void needperiodChange(PropertyChangedArgs e) {
        BigDecimal ndperiod = Objects.isNull(e.getChangeSet()[0].getNewValue()) ? BigDecimal.ZERO : (BigDecimal)e.getChangeSet()[0].getNewValue();
        BigDecimal atperiod = Objects.isNull(this.getModel().getValue("actualperiod")) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("actualperiod");
        this.getModel().setValue("totalperiod", (Object)ndperiod.add(atperiod));
        BigDecimal planperiod = (BigDecimal)this.getModel().getValue("planperiod");
        if (Objects.isNull(planperiod) || BigDecimal.ZERO.compareTo(planperiod) >= 0) {
            FieldTip plptips = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, "planperiod", this.MORETHANZERO);
            plptips.setSuccess(false);
            this.getView().showFieldTip(plptips);
        } else {
            BigDecimal calperiod = planperiod.subtract(ndperiod);
            BigDecimal periodpc = calperiod.divide(planperiod, 4, RoundingMode.HALF_UP);
            this.getModel().setValue("periodprecent", (Object)periodpc);
            this.setActualEndDate(periodpc);
        }
    }

    private void actualperiodChange(PropertyChangedArgs e) {
        BigDecimal acperiod = Objects.isNull(e.getChangeSet()[0].getNewValue()) ? BigDecimal.ZERO : (BigDecimal)e.getChangeSet()[0].getNewValue();
        FieldTip acptips = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, "actualperiod", this.MORETHANZERO);
        if (acperiod.compareTo(BigDecimal.ZERO) <= 0) {
            acptips.setSuccess(false);
            this.getView().showFieldTip(acptips);
        } else {
            acptips.setSuccess(true);
            this.getView().showFieldTip(acptips);
            BigDecimal ndpr = Objects.isNull(this.getModel().getValue("needperiod")) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("needperiod");
            this.getModel().setValue("totalperiod", (Object)acperiod.add(ndpr));
        }
    }

    private void needhourChange(PropertyChangedArgs e) {
        BigDecimal ndhour = Objects.isNull(e.getChangeSet()[0].getNewValue()) ? BigDecimal.ZERO : (BigDecimal)e.getChangeSet()[0].getNewValue();
        BigDecimal athour = Objects.isNull(this.getModel().getValue("actualhour")) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("actualhour");
        this.getModel().setValue("totalhour", (Object)athour.add(ndhour));
        BigDecimal hourpc = athour.divide(athour.add(ndhour), 4, RoundingMode.HALF_UP);
        this.getModel().setValue("hourprecent", (Object)hourpc);
        this.setActualEndDate(hourpc);
    }

    private void actualhourChange(PropertyChangedArgs e) {
        BigDecimal achour = Objects.isNull(e.getChangeSet()[0].getNewValue()) ? BigDecimal.ZERO : (BigDecimal)e.getChangeSet()[0].getNewValue();
        FieldTip achptips = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.others, "actualhour", ResManager.loadKDString((String)"\u5b9e\u9645\u5de5\u671f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"TaskReportBillPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        if (achour.compareTo(BigDecimal.ZERO) <= 0) {
            achptips.setSuccess(false);
            this.getView().showFieldTip(achptips);
        } else {
            achptips.setSuccess(true);
            this.getView().showFieldTip(achptips);
            BigDecimal ndhour = Objects.isNull(this.getModel().getValue("needhour")) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("needhour");
            this.getModel().setValue("totalhour", (Object)achour.add(ndhour));
            BigDecimal hourpc = achour.divide(achour.add(ndhour), 4, RoundingMode.HALF_UP);
            this.getModel().setValue("hourprecent", (Object)hourpc);
            this.setActualEndDate(hourpc);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (!"entryentity".equals(entryName)) {
            return;
        }
        if (e.getRowDataEntities().length > 0) {
            int rowindex = e.getRowDataEntities()[0].getRowIndex();
            String number = this.getDocNumber(rowindex);
            DynamicObject taskid = (DynamicObject)this.getModel().getValue("task");
            if (taskid == null) {
                return;
            }
            this.getModel().setValue("docnumber", (Object)number, rowindex);
            this.getModel().setItemValueByID("uploadperson", (Object)RequestContext.get().getCurrUserId(), rowindex);
            QFilter qFilter = new QFilter("id", "=", taskid.get("id"));
            qFilter.and(new QFilter("documententry.docnumber", "=", (Object)number));
            taskid = BusinessDataServiceHelper.loadSingle((String)"pmts_task", (String)"documententry.docnumber,documententry.docname,documententry.doctype", (QFilter[])qFilter.toArray());
            if (taskid == null) {
                return;
            }
            DynamicObjectCollection docentrys = taskid.getDynamicObjectCollection("documententry");
            for (DynamicObject entry : docentrys) {
                if (!entry.getString("docnumber").equalsIgnoreCase(number)) continue;
                this.getModel().setValue("docnumber", (Object)number, rowindex);
                this.getModel().setValue("docname", entry.get("docname"), rowindex);
                this.getModel().setValue("doctype", entry.get("doctype"), rowindex);
                this.getModel().setValue("uploaddate", (Object)new Date(), rowindex);
                this.getView().setEnable(Boolean.FALSE, rowindex, new String[]{"docnumber", "docname", "doctype"});
                break;
            }
        }
    }

    private void initData() {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initMustInput();
    }

    public void initMustInput() {
        DynamicObject task = (DynamicObject)this.getModel().getValue("task");
        if (task == null) {
            return;
        }
        switch (task.getString("percenttype")) {
            case "1": {
                DecimalEdit actualpercent = (DecimalEdit)this.getView().getControl("actualpercent");
                actualpercent.setMustInput(true);
                break;
            }
            case "2": {
                DecimalEdit actualperiod = (DecimalEdit)this.getView().getControl("actualperiod");
                actualperiod.setMustInput(true);
                DecimalEdit needperiod = (DecimalEdit)this.getView().getControl("needperiod");
                needperiod.setMustInput(true);
                break;
            }
            case "3": {
                DecimalEdit actualhour = (DecimalEdit)this.getView().getControl("actualhour");
                actualhour.setMustInput(true);
                DecimalEdit needhour = (DecimalEdit)this.getView().getControl("needhour");
                needhour.setMustInput(true);
                break;
            }
        }
    }

    private void setActualEndDate(BigDecimal percent) {
        if (percent.compareTo(new BigDecimal(100)) == 0) {
            this.getModel().setValue("actualenddate", (Object)new Date());
        } else {
            this.getModel().setValue("actualenddate", null);
        }
        this.getView().updateView("actualenddate");
    }

    private DynamicObject getSelectTask() {
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object taskPk = showParameter.getCustomParam("taskids");
        if (taskPk == null) {
            return null;
        }
        String ids = taskPk.toString();
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)ids, Map.class);
        return BusinessDataServiceHelper.loadSingle(dataMap.keySet().iterator().next(), (String)"pmts_task");
    }

    private String getDocNumber(int rowindex) {
        String number = "";
        StringBuilder docnumber = new StringBuilder();
        DynamicObject task = (DynamicObject)this.getModel().getValue("task");
        docnumber.append(StringUtils.upperCase((String)task.getString("number"))).append("-WD-").append(String.format("%06d", rowindex + 1));
        number = docnumber.toString();
        int size = this.getModel().getEntryEntity("entryentity").size();
        ArrayList<String> ls = new ArrayList<String>(10);
        for (int i = 0; i < size; ++i) {
            ls.add(this.getModel().getValue("docnumber", i).toString());
        }
        if (!ls.isEmpty() && ls.contains(docnumber.toString())) {
            number = this.getDocNumber(++rowindex);
        }
        return number;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged() && this.getModel().getChangeDesc().contains(ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"TaskReportBillPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]))) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (e.getEntryProp() == null) {
            return;
        }
        String entryName = e.getEntryProp().getName();
        if (!"entryentity".equals(entryName)) {
            return;
        }
        List deleterows = null;
        deleterows = Objects.isNull(this.getPageCache().get("deleterows")) ? new ArrayList() : SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("deleterows"), Object.class);
        for (int i : e.getRowIndexs()) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", i);
            if (row.getLong("id") <= 0L) continue;
            HashMap<Object, String> param = new HashMap<Object, String>();
            param.put(row.get("id"), row.getString("docnumber"));
            deleterows.add(param);
        }
        this.getPageCache().put("deleterows", SerializationUtils.toJsonString(deleterows));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Submit) {
            Submit submit = (Submit)e.getSource();
            submit.getOption().setVariableValue("deleterows", this.getPageCache().get("deleterows"));
        }
    }
}

