/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.YzjContextMenuClickPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;

public class TaskOfMineListPlugin
extends AbstractListPlugin {
    private static final String REPORTLISTAP = "reportlistap";
    private static final String FILTERCONTAINERAP = "filtercontainerap";
    private final String SELECTONE = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"TaskOfMineListPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);
    private static final String FORMID = "formId";
    private static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar bar = (Toolbar)this.getControl("toolbarap");
        bar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "transferlog": {
                this.showSendUI();
                break;
            }
            case "reporthis": {
                this.showHisReportList();
                break;
            }
            case "start": {
                this.startTask();
                break;
            }
            case "done": {
                this.havedoneTask();
                break;
            }
            case "communicate": {
                this.doCommunicate();
                break;
            }
            case "relationtask": {
                this.showRelationUI();
                break;
            }
        }
    }

    private void showRelationUI() {
        if (this.isSelectedRow()) {
            this.getView().showErrorNotification(this.SELECTONE);
            return;
        }
        if (this.getSelectDatas().size() > 1) {
            this.getView().showErrorNotification(this.SELECTONE);
            return;
        }
        Map dataMap = this.getSelectData();
        Object taskid = dataMap.keySet().iterator().next();
        DynamicObject taskData = BusinessDataServiceHelper.loadSingle((String)"pmts_task", (String)"prepositiontaskentry,prepositiontaskentry.prepositiontask,postpositiontaskentry,postpositiontaskentry.postpositiontask", (QFilter[])new QFilter("id", "=", taskid).toArray());
        DynamicObjectCollection preentrys = taskData.getDynamicObjectCollection("prepositiontaskentry");
        ArrayList preids = new ArrayList(8);
        preentrys.forEach(preentry -> {
            if (Objects.nonNull(preentry.get("prepositiontask.id")) && preentry.getLong("prepositiontask.id") > 0L) {
                preids.add(preentry.getLong("prepositiontask.id"));
            }
        });
        DynamicObjectCollection nxtentrys = taskData.getDynamicObjectCollection("postpositiontaskentry");
        ArrayList nexids = new ArrayList(8);
        nxtentrys.forEach(nxtentry -> {
            if (Objects.nonNull(nxtentry.get("postpositiontask.id")) && nxtentry.getLong("postpositiontask.id") > 0L) {
                nexids.add(nxtentry.getLong("postpositiontask.id"));
            }
        });
        HashMap<String, String> para = new HashMap<String, String>();
        para.put(FORMID, "pmts_relationtask");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("preids", (Object)SerializationUtils.toJsonString(preids));
        showParameter.setCustomParam("nexids", (Object)SerializationUtils.toJsonString(nexids));
        this.getView().showForm(showParameter);
    }

    private void havedoneTask() {
        List<Object> datas = this.getSelectDatas();
        if (datas.isEmpty()) {
            this.getView().showErrorNotification(this.SELECTONE);
        }
    }

    private void doCommunicate() {
        this.YZJCooperation();
    }

    private void YZJCooperation() {
        this.chaYZJ();
    }

    private void chaYZJ() {
        ArrayList<Long> UserIdList = new ArrayList<Long>(1);
        UserIdList.add(RequestContext.get().getCurrUserId());
        String openId = this.getOpenIdString(UserIdList);
        if (StringUtils.isEmpty((CharSequence)openId)) {
            return;
        }
        YzjContextMenuClickPlugin yzj = new YzjContextMenuClickPlugin();
        yzj.setView(this.getView());
        HashMap<String, String> mData = new HashMap<String, String>();
        mData.put("openId", openId);
        mData.put("userName", "");
        mData.put("chattype", "chat_pc");
        yzj.yzjInterface("createAndChat", mData);
    }

    private String getOpenIdString(List<Long> lstUserId) {
        StringBuilder result = new StringBuilder();
        List userOpenIdList = OrgViewServiceHelper.getOpenIdByUserId(lstUserId);
        if (userOpenIdList != null && !userOpenIdList.isEmpty()) {
            boolean hasEmptyOpenId = false;
            for (String openId : userOpenIdList) {
                if (StringUtils.isEmpty((CharSequence)openId)) {
                    hasEmptyOpenId = true;
                    continue;
                }
                if (result.length() == 0) {
                    result.append(openId);
                    continue;
                }
                result.append(',');
                result.append(openId);
            }
            if (hasEmptyOpenId) {
                String SuName = "";
                String phoneNumber = "";
                String Email = "";
                DynamicObject[] adminIdObjects = BusinessDataServiceHelper.load((String)"perm_admin", (String)"user_id", (QFilter[])new QFilter[]{new QFilter("admintype", "=", (Object)1L), new QFilter("type", "=", (Object)"10")});
                Long SuperAdminId = adminIdObjects[0].getLong("user_id");
                String select = TaskOfMineListPlugin.getSelects("name", "phone", "email");
                DynamicObject[] adminObjects = BusinessDataServiceHelper.load((String)"bos_user", (String)select, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)SuperAdminId)});
                if (adminObjects != null && adminObjects.length > 0) {
                    SuName = adminObjects[0].getString("name");
                    phoneNumber = adminObjects[0].getString("phone");
                    Email = adminObjects[0].getString("email");
                }
                StringBuilder notification = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7528\u6237\u4e2d\u5b58\u5728openId\u4e3a\u7a7a\u7684\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406%s", (String)"TaskOfMineListPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), "("));
                if (StringUtils.isNotEmpty((CharSequence)SuName)) {
                    notification.append(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\uff1a", (String)"TaskOfMineListPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                    notification.append(SuName);
                }
                if (StringUtils.isNotEmpty((CharSequence)phoneNumber)) {
                    notification.append(ResManager.loadKDString((String)" \u7535\u8bdd\uff1a", (String)"TaskOfMineListPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                    notification.append(phoneNumber);
                }
                if (StringUtils.isNotEmpty((CharSequence)Email)) {
                    notification.append(ResManager.loadKDString((String)" \u90ae\u7bb1\uff1a", (String)"TaskOfMineListPlugin_4", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
                    notification.append(Email);
                }
                this.getView().showTipNotification(notification + ")", Integer.valueOf(3000));
            }
        }
        return result.toString();
    }

    private List<Object> getSelectDatas() {
        ListView view = (ListView)this.getView();
        ArrayList<Object> datas = new ArrayList<Object>(8);
        ListSelectedRowCollection rows = view.getSelectedRows();
        for (ListSelectedRow row : rows) {
            datas.add(row.getPrimaryKeyValue());
        }
        return datas;
    }

    private Map getSelectData() {
        ListView view = (ListView)this.getView();
        HashMap<Object, Object> dataMap = new HashMap<Object, Object>();
        ListSelectedRow rowData = view.getCurrentSelectedRowInfo();
        DynamicObject taskobj = QueryServiceHelper.queryOne((String)"pmts_task", (String)"percenttype", (QFilter[])new QFilter("id", "=", rowData.getPrimaryKeyValue()).toArray());
        dataMap.put(rowData.getPrimaryKeyValue(), taskobj.get("percenttype"));
        return dataMap;
    }

    private void showReportUI() {
    }

    private void showSendUI() {
        if (this.isSelectedRow()) {
            this.getView().showErrorNotification(this.SELECTONE);
            return;
        }
        List<Object> datas = this.getSelectDatas();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pmts_task", (String)"projectnum", (QFilter[])new QFilter("id", "in", (Object)datas.toArray()).toArray());
        HashSet set = new HashSet(8);
        coll.forEach(co -> set.add(co.get("projectnum")));
        if (set.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\uff0c\u9700\u8981\u9009\u62e9\u76f8\u540c\u9879\u76ee\u7684\u6570\u636e\u3002", (String)"TaskOfMineListPlugin_8", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmts_task_handover", (boolean)false);
        showParameter.setLookUp(false);
        showParameter.getListFilterParameter().setFilter(new QFilter("task", "=", datas.get(0)));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showHisReportList() {
        if (this.isSelectedRow()) {
            this.getView().showErrorNotification(this.SELECTONE);
            return;
        }
        Map dataMap = this.getSelectData();
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmts_taskreportbill", (boolean)false);
        showParameter.setLookUp(false);
        CloseCallBack refresh = new CloseCallBack((IFormPlugin)this, REFRESH);
        showParameter.setCloseCallBack(refresh);
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("task", "=", dataMap.keySet().iterator().next()));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void startTask() {
        if (this.isSelectedRow()) {
            this.getView().showErrorNotification(this.SELECTONE);
            return;
        }
        List<Object> datas = this.getSelectDatas();
        DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])datas.toArray(new Object[datas.size()]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task"));
        OperationResult rst = new OperationResult();
        rst.setBillCount(tasks.length);
        ArrayList<OperateErrorInfo> allErrors = new ArrayList<OperateErrorInfo>(8);
        rst.setShowMessage(true);
        for (DynamicObject task : tasks) {
            if (task.getString("executestatus").equals("1")) {
                rst.addSuccessPkId(task.getPkValue());
                task.set("executestatus", (Object)"2");
                task.set("actualstartdate", (Object)new Date());
                continue;
            }
            OperateErrorInfo error = new OperateErrorInfo();
            error.setMessage(String.format(ResManager.loadKDString((String)"%s:\u4efb\u52a1\u72b6\u6001\u4e0d\u7b49\u4e8e\u672a\u5f00\u59cb\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"TaskOfMineListPlugin_9", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), task.getString("number")));
            error.setEntityKey("pmts_task");
            error.setErrorCode("errorcode_001");
            error.setErrorLevel("Error");
            error.setPkValue(task.getPkValue());
            error.setTitle(ResManager.loadKDString((String)"\u72b6\u6001\u6807\u8bb0\u5931\u8d25", (String)"TaskOfMineListPlugin_10", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            allErrors.add(error);
        }
        rst.setAllErrorInfo(allErrors);
        SaveServiceHelper.update((DynamicObject[])tasks);
        if (rst.getAllErrorInfo().isEmpty()) {
            rst.setSuccess(true);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u72b6\u6001\u6807\u8bb0\u6210\u529f", (String)"TaskOfMineListPlugin_11", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        } else {
            rst.setSuccess(false);
            this.getView().showOperationResult(rst);
        }
        this.getView().invokeOperation(REFRESH);
    }

    public void closedCallBack(ClosedCallBackEvent ce) {
        super.closedCallBack(ce);
        if (ce.getActionId().equalsIgnoreCase(REFRESH)) {
            this.getView().invokeOperation(REFRESH);
        }
        if (ce.getActionId().equalsIgnoreCase("refresh_bysend") && ce.getReturnData() != null) {
            this.getView().invokeOperation(REFRESH);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u79fb\u4ea4\u6210\u529f", (String)"TaskOfMineListPlugin_12", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        DynamicObject hrpr = QueryServiceHelper.queryOne((String)"mpdm_manuperson", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())});
        if (Objects.isNull(hrpr)) {
            e.getQFilters().add(new QFilter("responsperson", "=", null));
        } else {
            e.getQFilters().add(new QFilter("responsperson", "=", hrpr.get(0)));
        }
        e.getQFilters().add(new QFilter("status", "=", (Object)"C"));
        e.getQFilters().add(new QFilter("executestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"1", "2", "3", "4", "5"})));
    }

    private boolean isSelectedRow() {
        ListView view = (ListView)this.getView();
        return Objects.isNull(view.getCurrentSelectedRowInfo());
    }

    public static String getSelects(String ... vals) {
        if (vals != null && vals.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                sb.append(vals[i]);
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"transfer")) {
            this.berfoerTransfer(args);
        }
    }

    public void berfoerTransfer(BeforeDoOperationEventArgs args) {
        List<Object> selectDatas = this.getSelectDatas();
        QFilter qFilter = new QFilter("task", "=", selectDatas.get(0));
        qFilter.and("successstatus", "=", (Object)"A");
        int count = ORM.create().count("TaskOfMineListPlugin.counttransfer", "pmts_task_handover", qFilter.toArray());
        if (count > 0) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u79fb\u4ea4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TaskOfMineListPlugin_15", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        }
    }
}

