/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.release;

import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.RefBillEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class DeptReleaseEditPlugin
extends AbstractBillPlugIn {
    private static final String ENTRYENTITY = "treeentryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit licGroup = (BasedataEdit)this.getControl("licensegroup");
        licGroup.addBeforeF7SelectListener(this::licGroupBeforeF7);
        RefBillEdit mroorder = (RefBillEdit)this.getControl("mroorder");
        mroorder.addBeforeF7SelectListener(this::mroorderBeforeF7);
        mroorder.addAfterF7SelectListener(this::mroorderAfterF7);
        BasedataEdit dept = (BasedataEdit)this.getControl("dept");
        dept.addBeforeF7SelectListener(this::deptBeforeF7);
    }

    private void mroorderAfterF7(AfterF7SelectEvent event) {
        ListSelectedRow listSelectedRow;
        Object selectPk = event.getInputValue();
        String queryField = "id";
        if (selectPk instanceof String) {
            selectPk = Long.valueOf((String)selectPk);
        }
        if ((listSelectedRow = event.getListSelectedRow()) != null) {
            queryField = "treeentryentity.id";
            selectPk = listSelectedRow.getEntryPrimaryKeyValue();
        }
        if (selectPk == null) {
            return;
        }
        QFilter qFilter = new QFilter(queryField, "=", selectPk);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"pom_mroorder", (String)"treeentryentity.project", (QFilter[])qFilter.toArray());
        if (obj != null) {
            this.getModel().beginInit();
            this.getModel().setValue("project", obj.get(0));
            this.getModel().endInit();
            this.getView().updateView("project");
            this.setLicGroup((DynamicObject)this.getModel().getValue("project"));
        }
    }

    private void mroorderBeforeF7(BeforeF7SelectEvent event) {
        ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
        ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
        listFilterParameter.setSelectEntity(ENTRYENTITY);
        listFilterParameter.setFilter(new QFilter("dailyexptype", "=", (Object)0L));
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            listFilterParameter.setFilter(new QFilter("treeentryentity.project", "=", project.getPkValue()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"mroorder", (CharSequence)key)) {
            this.mroorderChange();
        }
        if (StringUtils.equals((CharSequence)"project", (CharSequence)key)) {
            this.projectChange(e.getChangeSet()[0]);
        }
    }

    private void projectChange(ChangeData changeData) {
        this.getModel().beginInit();
        this.getModel().setValue("mroorder", null);
        this.getModel().endInit();
        this.getView().updateView("mroorder");
        DynamicObject project = (DynamicObject)changeData.getNewValue();
        this.setLicGroup(project);
    }

    private void setLicGroup(DynamicObject project) {
        DynamicObjectCollection licGroups;
        if (project != null && (licGroups = project.getDynamicObjectCollection("issuebody")) != null && licGroups.size() == 1) {
            this.getModel().setValue("licensegroup", ((DynamicObject)licGroups.get(0)).get("fbasedataid"));
        }
    }

    protected void mroorderChange() {
    }

    public void click(EventObject evt) {
    }

    private void showMroorderNoForm() {
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
    }

    private void mroorderNoCloseBack(ClosedCallBackEvent event) {
    }

    public void afterCreateNewData(EventObject e) {
        this.initOrgInfo();
        this.initDeptInfo();
    }

    public void afterCopyData(EventObject e) {
        this.initOrgInfo();
    }

    protected void initOrgInfo() {
        DynamicObject corg = (DynamicObject)this.getModel().getValue("org");
        if (corg == null) {
            return;
        }
        DynamicObject org = this.getModel().loadReferenceData((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"), corg.getPkValue());
        if (org != null) {
            this.getModel().setValue("coname", org.get("name"));
            this.getModel().setValue("coaddress", org.get("contactaddress"));
        }
    }

    private void licGroupBeforeF7(BeforeF7SelectEvent event) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project == null) {
            this.getView().showTipNotification(this.getProjectMsg());
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection licGroups = project.getDynamicObjectCollection("issuebody");
        if (CollectionUtils.isEmpty((Collection)licGroups)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9879\u76ee\u7684\u53d1\u8bc1\u673a\u6784\u4fe1\u606f\u3002", (String)"DeptReleaseEditPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Set licGroupPks = licGroups.stream().map(i -> i.get("fbasedataid_id")).collect(Collectors.toSet());
        event.addCustomQFilter(new QFilter("id", "in", licGroupPks));
    }

    public String getProjectMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"DeptReleaseEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);
    }

    private void deptBeforeF7(BeforeF7SelectEvent event) {
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        DynamicObjectCollection depts = creator.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)depts)) {
            Set deptPks = depts.stream().map(i -> i.get("dpt_id")).collect(Collectors.toSet());
            event.getCustomQFilters().add(new QFilter("id", "in", deptPks));
        }
    }

    private void initDeptInfo() {
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        DynamicObjectCollection depts = creator.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)depts)) {
            this.getModel().setValue("dept", ((DynamicObject)depts.get(0)).get("dpt"));
        }
    }
}

