/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.release;

import java.util.Collection;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.common.util.CommonFilterConditionUtil;
import kd.pmc.pmts.business.helper.ReleaseHelper;

public class EquipmentReleaseEditPlugin
extends AbstractBillPlugIn {
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"resplannum"});
        BasedataEdit licGroup = (BasedataEdit)this.getControl("licensegroup");
        licGroup.addBeforeF7SelectListener(this::licGroupBeforeF7);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"device", (CharSequence)key)) {
            this.deviceChanged(e);
        } else if (StringUtils.equals((CharSequence)"resplannum", (CharSequence)key)) {
            this.resourcePlanChanged(e);
        } else if (StringUtils.equals((CharSequence)"project", (CharSequence)key)) {
            this.projectChanged(e);
        }
    }

    protected void deviceChanged(PropertyChangedArgs e) {
        DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.deleteEntryData(ENTRYENTITY);
        if (newValue == null) {
            return;
        }
        DynamicObjectCollection entry = this.queryDeviceDetial(newValue.getPkValue());
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"engineseq", "location", "egcreater", "egcreatedate", "egmodifier", "egmodifydate"});
        for (DynamicObject obj : entry) {
            tableValueSetter.addRow(new Object[]{obj.get(0), obj.get(1), obj.get(2), obj.get(3), obj.get(4), obj.get(5)});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow(ENTRYENTITY, tableValueSetter);
        dataModel.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    protected DynamicObjectCollection queryDeviceDetial(Object pk) {
        QFilter qFilter = new QFilter("id", "=", pk);
        return QueryServiceHelper.query((String)"mpdm_materialmtcinfo", (String)"engineentry.engineseq,engineentry.location,engineentry.egcreater,engineentry.egcreatedate,engineentry.egmodifier ,engineentry.egmodifydate", (QFilter[])qFilter.toArray(), (String)"engineentry.seq");
    }

    public void afterCreateNewData(EventObject e) {
        this.initOrgInfo();
    }

    public void afterCopyData(EventObject e) {
        this.initOrgInfo();
    }

    protected void initOrgInfo() {
        DynamicObject org = this.getModel().loadReferenceData((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"), (Object)RequestContext.get().getOrgId());
        if (org != null) {
            this.getModel().setValue("coname", org.get("name"));
            this.getModel().setValue("coaddress", org.get("contactaddress"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)"resplannum", (CharSequence)key)) {
            this.showResourcePlanForm();
        }
    }

    private void showResourcePlanForm() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"pmpd_resourceplan_pro", (boolean)false);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "resplannum"));
        showParameter.getListFilterParameter().setFilter(CommonFilterConditionUtil.getResourcePlanFilterConditon());
        showParameter.setSelectedEntity("entry_project");
        showParameter.setAppId("pmpd");
        showParameter.setCustomParam("ServiceAppId", (Object)"pmpd");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"resplannum", (CharSequence)actionId)) {
            this.resourcePlanCloseBack(event);
        }
    }

    private void resourcePlanCloseBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        Object pk = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject resPlan = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"pmpd_resourceplan", (String)"id,billno,entry_project.projcet,lisgroup");
        this.setResPlanData(resPlan.get("id"), resPlan.get("billno"), null, null, null, resPlan.getDynamicObjectCollection("lisgroup"), resPlan.getDynamicObjectCollection("entry_project"));
    }

    public void setResPlanData(Object resplaid, Object resplannum, Object overdevice, Object model, Object customer, DynamicObjectCollection licGroups, DynamicObjectCollection projects) {
        IDataModel dataModel = this.getModel();
        if (resplannum != null) {
            dataModel.setValue("resplannum", resplannum);
        }
        dataModel.setValue("resplanid", resplaid);
        if (licGroups != null && licGroups.size() == 1) {
            dataModel.setValue("licensegroup", ((DynamicObject)licGroups.get(0)).get("fbasedataid"));
        }
        if (CollectionUtils.isEmpty((Collection)projects)) {
            dataModel.setValue("projects", null);
            dataModel.setValue("project", null);
            return;
        }
        Object[] projectPks = projects.stream().map(i -> i.get("projcet_id")).toArray();
        dataModel.setValue("projects", (Object)projectPks);
        DynamicObjectCollection pros = (DynamicObjectCollection)dataModel.getValue("projects");
        DynamicObject project = null;
        for (DynamicObject pro : pros) {
            DynamicObject proj = pro.getDynamicObject("fbasedataid");
            if (!proj.getBoolean("ismain")) continue;
            project = proj;
            break;
        }
        if (project == null) {
            project = ((DynamicObject)pros.get(0)).getDynamicObject("fbasedataid");
        }
        dataModel.setValue("project", project);
    }

    private void resourcePlanChanged(PropertyChangedArgs e) {
        String resPlanNum = (String)e.getChangeSet()[0].getNewValue();
        if (StringUtils.isEmpty((CharSequence)resPlanNum)) {
            this.setResPlanData(null, null, null, null, null, null, null);
        }
    }

    private void licGroupBeforeF7(BeforeF7SelectEvent event) {
        Long resplanId = (Long)this.getModel().getValue("resplanid");
        if (resplanId == null || resplanId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u3002", (String)"EquipmentReleaseEditPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObject resPlan = BusinessDataServiceHelper.loadSingle((Object)resplanId, (String)"pmpd_resourceplan", (String)"lisgroup");
        DynamicObjectCollection licGroups = resPlan.getDynamicObjectCollection("lisgroup");
        if (CollectionUtils.isEmpty((Collection)licGroups)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u68c0\u4fee\u4e3b\u8d44\u6e90\u8ba1\u5212\u7684\u53d1\u8bc1\u673a\u6784\u4fe1\u606f\u3002", (String)"EquipmentReleaseEditPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        Set licGroupPks = licGroups.stream().map(i -> i.get("fbasedataid_id")).collect(Collectors.toSet());
        event.addCustomQFilter(new QFilter("id", "in", licGroupPks));
    }

    private void projectChanged(PropertyChangedArgs e) {
        DynamicObject model;
        DynamicObject project = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (project == null) {
            return;
        }
        DynamicObject enginetype = project.getDynamicObject("enginetype");
        if (enginetype != null) {
            this.getModel().setValue("engmodelct", ReleaseHelper.queryEngineManufacturer((Object)enginetype.getPkValue()));
        }
        if ((model = project.getDynamicObject("engineequipmodel")) == null) {
            return;
        }
        this.getModel().setValue("manufactur", ReleaseHelper.queryModelManufacturer((Object)model.getPkValue()));
    }
}

