/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.release;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.pmc.pmts.business.helper.ReleaseHelper;

public class ReleaseCodeRulePlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"version", (CharSequence)key) || StringUtils.equals((CharSequence)"licensegroup", (CharSequence)key)) {
            this.createBillNo();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.cacheNumber();
    }

    public void cacheNumber() {
        Integer version = (Integer)this.getModel().getValue("version");
        String number = (String)this.getModel().getValue("billno");
        this.getPageCache().put("version", String.valueOf(version));
        this.getPageCache().put("number", number);
    }

    public void afterBindData(EventObject e) {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getPageCache().put("operationStatus", "addNew");
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"billno"});
    }

    private void createBillNo() {
        Integer version = (Integer)this.getModel().getValue("version");
        int oldVersion = Integer.parseInt(this.getPageCache().get("version"));
        String number = null;
        if (oldVersion == version) {
            number = this.getPageCache().get("number");
        } else {
            DynamicObject licensegroup = (DynamicObject)this.getModel().getValue("licensegroup");
            number = ReleaseHelper.getCodeNumber((DynamicObject)licensegroup, (Integer)version);
        }
        this.getModel().setValue("billno", (Object)number);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            this.cacheNumber();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (("print".equals(key) || "printpreview".equals(key)) && !this.canPrint()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\uff0c\u65b9\u53ef\u6253\u5370\u3002", (String)"ReleasePrint_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean canPrint() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        String bizStatus = (String)this.getModel().getValue("bizstatus");
        return "C".equals(billStatus) && "B".equals(bizStatus);
    }
}

