/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.utils.ObjectMapperUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.formplugin.gantt.OpenBillFieldUtil;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;
import kd.pmc.pmts.common.model.WorkBenchConfigFieldMappingModel;
import kd.pmc.pmts.formplugin.workbench.WorkBenchConfigPlanEdit;
import org.apache.commons.collections4.CollectionUtils;

public class FieldDispConfigEdit
extends AbstractFormPlugin {
    private static final String SYSTEM_TYPE = "mmc-pmts-formplugin";
    private static final Log logger = LogFactory.getLog(WorkBenchConfigPlanEdit.class);
    private static final String prop = "prop";
    public static final String BTOK = "btok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit filtertext = (TextEdit)this.getView().getControl("entityfield");
        if (filtertext != null) {
            filtertext.addClickListener((ClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("entityfield".equals(name)) {
            this.getModel().setValue("entityfieldprop", null, this.getModel().getEntryCurrentRowIndex("entryentity"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"entityfield", (CharSequence)key)) {
            OpenBillFieldUtil.openBillFieldList((String)"entryentity", (String)"srcbills", (String)"false", (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, "entityfield"), (boolean)Boolean.FALSE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long fieldConfigId = Long.parseLong((String)customParams.get("fieldConfigId"));
        String configModelStr = (String)customParams.get("configModels");
        this.getModel().setValue("srcbills", this.getView().getFormShowParameter().getCustomParam("entityNumber"));
        if (StringUtils.isNotBlank((CharSequence)configModelStr)) {
            try {
                List models = (List)ObjectMapperUtils.getMapper((boolean)false).readValue(configModelStr, (TypeReference)new TypeReference<List<WorkBenchConfigFieldMappingModel>>(){});
                this.updateModels(models, fieldConfigId);
                DynamicObject srcbills = (DynamicObject)this.getModel().getValue("srcbills");
                if (srcbills != null) {
                    MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)srcbills.getString("number"));
                    for (WorkBenchConfigFieldMappingModel model : models) {
                        String fieldConfTag = model.getFieldConfTag();
                        String fieldCaption = "";
                        if (StringUtils.isNotBlank((CharSequence)fieldConfTag)) {
                            if (fieldConfTag.contains(",")) {
                                String[] fileds;
                                StringBuilder fieldCaptionStr = new StringBuilder();
                                for (String filed : fileds = fieldConfTag.split("\\,")) {
                                    fieldCaptionStr.append(BillFieldEntityHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)filed)).append(",");
                                }
                                fieldCaption = fieldCaptionStr.substring(0, fieldCaptionStr.length() - 1);
                            } else {
                                fieldCaption = BillFieldEntityHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldConfTag);
                            }
                        }
                        model.setFieldConf(fieldCaption);
                    }
                }
                this.loaDataFromSaved(models);
            }
            catch (JsonProcessingException jsonProcessingException) {
                logger.info("FieldDispConfigEdit#afterCreateNewData fail:" + jsonProcessingException.getMessage());
            }
        } else {
            this.loadDataFromSearch(fieldConfigId);
        }
    }

    private void updateModels(List<WorkBenchConfigFieldMappingModel> models, Long fieldConfigId) {
        List<WorkBenchConfigFieldMappingModel> configModels = this.loadModelsFromSearch(fieldConfigId);
        HashMap entryToModelMap = new HashMap(models.size());
        configModels.forEach(t -> entryToModelMap.put(t.getFieldConfEntryId(), t));
        Iterator<WorkBenchConfigFieldMappingModel> iter = models.iterator();
        while (iter.hasNext()) {
            WorkBenchConfigFieldMappingModel model = iter.next();
            Long fieldConfEntryId = model.getFieldConfEntryId();
            WorkBenchConfigFieldMappingModel curModel = (WorkBenchConfigFieldMappingModel)entryToModelMap.get(fieldConfEntryId);
            if (curModel == null) {
                iter.remove();
                continue;
            }
            model.setProjStruct(curModel.getProjStruct());
            model.setFieldName(curModel.getFieldName());
            model.setFieldIndentif(curModel.getFieldIndentif());
            model.setColWidth(curModel.getColWidth());
            model.setRowCount(curModel.getRowCount());
            entryToModelMap.remove(fieldConfEntryId);
        }
        if (entryToModelMap.size() > 0) {
            models.addAll(entryToModelMap.values());
        }
        Collections.sort(models, new Comparator<WorkBenchConfigFieldMappingModel>(){

            @Override
            public int compare(WorkBenchConfigFieldMappingModel o1, WorkBenchConfigFieldMappingModel o2) {
                return Integer.compare(o1.getRowCount(), o2.getRowCount());
            }
        });
    }

    private void loaDataFromSaved(List<WorkBenchConfigFieldMappingModel> models) {
        this.getModel().batchCreateNewEntryRow("entryentity", models.size());
        for (int index = 0; index < models.size(); ++index) {
            this.getModel().setValue("fieldindentif", (Object)models.get(index).getFieldIndentif(), index);
            this.getModel().setValue("fieldname", (Object)models.get(index).getFieldName(), index);
            this.getModel().setValue("colwidth", (Object)models.get(index).getColWidth(), index);
            this.getModel().setValue("fieldconfentryid", (Object)models.get(index).getFieldConfEntryId(), index);
            this.getModel().setValue("entityfieldprop", (Object)models.get(index).getFieldConfTag(), index);
            this.getModel().setValue("entityfield", (Object)models.get(index).getFieldConf(), index);
            this.getModel().setValue("isprojstruct", (Object)models.get(index).getProjStruct(), index);
        }
    }

    private List<WorkBenchConfigFieldMappingModel> loadModelsFromSearch(Long fieldConfigId) {
        ArrayList<WorkBenchConfigFieldMappingModel> result = new ArrayList<WorkBenchConfigFieldMappingModel>(2);
        DynamicObjectCollection fieldDefColl = QueryServiceHelper.query((String)"pmts_wkbenchfield_def", (String)"id,fielddefentry,fielddefentry.id as entryid,fielddefentry.fieldindentif as fieldindentif,fielddefentry.fieldname as fieldname,fielddefentry.colwidth as colwidth,fielddefentry.isprojstruct as isprojstruct,fielddefentry.seq as seq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fieldConfigId)});
        if (CollectionUtils.isNotEmpty((Collection)fieldDefColl)) {
            for (int index = 0; index < fieldDefColl.size(); ++index) {
                WorkBenchConfigFieldMappingModel model = new WorkBenchConfigFieldMappingModel();
                model.setFieldIndentif(((DynamicObject)fieldDefColl.get(index)).getString("fieldindentif"));
                model.setFieldName(((DynamicObject)fieldDefColl.get(index)).getString("fieldname"));
                model.setColWidth(Integer.valueOf(((DynamicObject)fieldDefColl.get(index)).getInt("colwidth")));
                model.setFieldConfEntryId(Long.valueOf(((DynamicObject)fieldDefColl.get(index)).getLong("entryid")));
                model.setProjStruct(Boolean.valueOf(((DynamicObject)fieldDefColl.get(index)).getBoolean("isprojstruct")));
                model.setRowCount(Integer.valueOf(((DynamicObject)fieldDefColl.get(index)).getInt("seq")));
                result.add(model);
            }
        }
        return result;
    }

    private void loadDataFromSearch(Long fieldConfigId) {
        List<WorkBenchConfigFieldMappingModel> models = this.loadModelsFromSearch(fieldConfigId);
        if (CollectionUtils.isNotEmpty(models)) {
            this.getModel().batchCreateNewEntryRow("entryentity", models.size());
            for (int index = 0; index < models.size(); ++index) {
                this.getModel().setValue("fieldindentif", (Object)models.get(index).getFieldIndentif(), index);
                this.getModel().setValue("fieldname", (Object)models.get(index).getFieldName(), index);
                this.getModel().setValue("colwidth", (Object)models.get(index).getColWidth(), index);
                this.getModel().setValue("fieldconfentryid", (Object)models.get(index).getFieldConfEntryId(), index);
                this.getModel().setValue("isprojstruct", (Object)models.get(index).getProjStruct(), index);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (BTOK.equals(operateKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Boolean hasprojStruct = Boolean.FALSE;
            if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject rowObj = (DynamicObject)entryEntity.get(i);
                    if (!rowObj.getBoolean("isprojstruct")) continue;
                    hasprojStruct = Boolean.TRUE;
                }
            }
            if (!hasprojStruct.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u9879\u76ee\u7ed3\u6784\u3002", (String)"FieldDispConfigEdit_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (BTOK.equals(opKey)) {
            List<WorkBenchConfigFieldMappingModel> configModels = this.getConfigModels();
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(configModels));
        }
    }

    private List<WorkBenchConfigFieldMappingModel> getConfigModels() {
        ArrayList<Object> models = new ArrayList<WorkBenchConfigFieldMappingModel>(0);
        DynamicObjectCollection subEntryColl = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)subEntryColl)) {
            models = new ArrayList(subEntryColl.size());
            for (DynamicObject subObj : subEntryColl) {
                WorkBenchConfigFieldMappingModel model = new WorkBenchConfigFieldMappingModel(subObj.getString("fieldindentif"), subObj.getString("fieldname"), Integer.valueOf(subObj.getInt("colwidth")), subObj.getString("entityfield"), subObj.getString("entityfieldprop"), Long.valueOf(subObj.getLong("fieldconfentryid")), Boolean.valueOf(subObj.getBoolean("isprojstruct")), Integer.valueOf(subObj.getInt("seq")));
                models.add(model);
            }
        }
        return models;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("entityfield".equals(actionId) && returnData != null) {
            OpenBillFieldUtil.setFieldProp((String)((String)returnData), (String)"entityfield", (String)"entityfieldprop", (String)"entryentity", (IDataModel)this.getModel(), (String)"srcbills");
        }
    }
}

