/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.fmm.common.util.StringDateUtils;
import kd.pmc.pmts.business.helper.MaterialAutoBotpHelper;

public class MaterialRequestListPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit wbs = (BasedataEdit)this.getView().getControl("wbs");
        BasedataEdit task = (BasedataEdit)this.getView().getControl("task");
        BasedataEdit materialPlan = (BasedataEdit)this.getView().getControl("materialplan");
        if (wbs != null) {
            wbs.addBeforeF7SelectListener(this::beforeWbsSelect);
        }
        if (task != null) {
            task.addBeforeF7SelectListener(this::beforeTaskSelect);
        }
        if (materialPlan != null) {
            materialPlan.addBeforeF7SelectListener(this::beforeMaterialPlanSelect);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject requireType = (DynamicObject)this.getModel().getValue("requiretypeid");
        if (requireType != null) {
            this.getModel().setValue("directgenrate", (Object)requireType.getBoolean("directgenerate"));
            this.getModel().setValue("reversalidentif", (Object)requireType.getBoolean("reveridentif"));
            this.getModel().setValue("speciindentif", (Object)requireType.getBoolean("specialidentif"));
        }
        this.setExitWithOutReminder(this.getModel(), "directgenrate", "reversalidentif", "speciindentif");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("generate".equals(operateKey)) {
            this.botpOperation();
        } else if (this.pushButtonList().contains(operateKey)) {
            boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
            if (success) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MaterialRequestListPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            } else {
                String message = afterDoOperationEventArgs.getOperationResult().getMessage();
                this.getView().showErrorNotification(message);
            }
        }
    }

    private List<String> pushButtonList() {
        ArrayList<String> result = new ArrayList<String>(2);
        result.add("pushoutsrcorder");
        result.add("pushprodorder");
        result.add("pushpurchaserequest");
        result.add("pushandsvpurchase");
        result.add("pushandsvoutsrcorder");
        result.add("pushandsvprodorder");
        return result;
    }

    private void botpOperation() {
        String materialattr;
        DynamicObject materialplan = (DynamicObject)this.getModel().getValue("materialplan");
        if (materialplan != null && StringUtils.isNotBlank((CharSequence)(materialattr = materialplan.getString("materialattr")))) {
            MaterialAutoBotpHelper.simulateButtonClick((String)materialattr, (IFormView)this.getView(), (String)"tbmain");
        }
    }

    private void beforeMaterialPlanSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.addCustomQFilter(new QFilter("materialattr", "!=", (Object)"10020"));
    }

    private void beforeTaskSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs");
        if (project != null) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("projectnum", "=", project.getPkValue()));
        }
        if (wbs != null) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("wbs", "=", wbs.getPkValue()));
        }
        beforeF7SelectEvent.addCustomQFilter(new QFilter("version", "is null", null).or("version", "=", (Object)0));
        beforeF7SelectEvent.addCustomQFilter(new QFilter("deletestatus", "!=", (Object)"B"));
        ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setShowApproved(false);
    }

    private void beforeWbsSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            QFilter statusFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)Boolean.TRUE);
            Long projectId = project.getLong("id");
            QFilter projectFilter = new QFilter("projectnum.id", "=", (Object)projectId);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("formTask", (Object)true);
            beforeF7SelectEvent.addCustomQFilter(projectFilter);
            beforeF7SelectEvent.addCustomQFilter(statusFilter);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("display_filter", (Object)statusFilter.and(projectFilter).toSerializedString());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("project", customParams.get("newadd_param_project"));
        this.getModel().setValue("wbs", customParams.get("newadd_param_wbs"));
        Long taskObject = (Long)customParams.get("newadd_param_task");
        this.getModel().setValue("task", (Object)taskObject);
        if (taskObject != null && taskObject != 0L) {
            DynamicObject task = (DynamicObject)this.getModel().getValue("task");
            this.getModel().setValue("reqtimetype", (Object)task.getString("reqtimetype"));
            this.reqTimeTypeChanged();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        HashSet projectFields = new HashSet(){
            {
                this.add("project");
                this.add("wbs");
                this.add("task");
            }
        };
        String name = e.getProperty().getName();
        if (projectFields.contains(name)) {
            this.clearProjectData(name);
        }
        if ("task".equals(name)) {
            this.materialPlanChanged();
        } else if ("reqtimetype".equals(name) || "deviationdays".equals(name)) {
            this.reqTimeTypeChanged();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.setExitWithOutReminder(this.getModel(), "directgenrate", "reversalidentif", "speciindentif");
    }

    private void setExitWithOutReminder(IDataModel model, String ... fields) {
        for (String field : fields) {
            int ordinal = this.getModel().getProperty(field).getOrdinal();
            model.getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    private void reqTimeTypeChanged() {
        String reqtimeType = (String)this.getModel().getValue("reqtimetype");
        DynamicObject task = (DynamicObject)this.getModel().getValue("task");
        Date reqtime = null;
        if (task != null) {
            Date planStartDate = task.getDate("planstartdate");
            Date planEndDate = task.getDate("planenddate");
            Integer deviationDays = (Integer)this.getModel().getValue("deviationdays");
            if (deviationDays != null) {
                if ("A".equals(reqtimeType) && planStartDate != null) {
                    reqtime = StringDateUtils.getAfterXDaysData((Date)planStartDate, (int)deviationDays);
                } else if ("B".equals(reqtimeType) && planEndDate != null) {
                    reqtime = StringDateUtils.getAfterXDaysData((Date)planEndDate, (int)deviationDays);
                }
            }
        }
        this.getModel().setValue("reqtime", reqtime);
    }

    private void materialPlanChanged() {
        DynamicObject wbsObj;
        long wbs;
        Boolean hasOrg = Boolean.FALSE;
        DynamicObject task = (DynamicObject)this.getModel().getValue("task");
        if (task != null && (wbs = task.getLong("wbs_id")) != 0L && (wbsObj = QueryServiceHelper.queryOne((String)"pmts_wbs", (String)"purchaseorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wbs)})) != null && wbsObj.getLong("purchaseorg") != 0L) {
            this.getModel().setValue("purchaseorg", (Object)wbsObj.getLong("purchaseorg"));
            hasOrg = Boolean.TRUE;
        }
        if (!hasOrg.booleanValue()) {
            this.getModel().setValue("purchaseorg", null);
        }
    }

    private void clearProjectData(String name) {
        if ("project".equals(name)) {
            this.getModel().beginInit();
            this.getModel().setValue("wbs", null);
            this.getModel().setValue("task", null);
            this.getModel().endInit();
        } else if ("wbs".equals(name)) {
            this.getModel().beginInit();
            this.getModel().setValue("task", null);
            DynamicObject wbs = (DynamicObject)this.getModel().getValue("wbs");
            if (wbs != null) {
                this.getModel().setValue("project", (Object)wbs.getDynamicObject("projectnum"));
            } else {
                this.getModel().setValue("task", null);
            }
            this.getModel().endInit();
        } else if ("task".equals(name)) {
            this.getModel().beginInit();
            DynamicObject task = (DynamicObject)this.getModel().getValue("task");
            if (task != null) {
                this.getModel().setValue("project", (Object)task.getDynamicObject("projectnum"));
                this.getModel().setValue("wbs", (Object)task.getDynamicObject("wbs"));
            }
            this.getModel().endInit();
        }
        this.getView().updateView("project");
        this.getView().updateView("wbs");
        this.getView().updateView("task");
    }
}

