/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.FilterContainerFilterValues;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.common.util.workbench.ProjectTreeUtil;
import kd.pmc.pmts.common.util.workbench.SingleProjectBenchUtil;

public class SingleProjectBenchPlugin
extends AbstractListPlugin
implements SearchClickListener {
    private static Log logger = LogFactory.getLog(SingleProjectBenchPlugin.class);
    private static final String CACHE_WBS = "cache_wbs";
    private static final String FIRST_INIT = "filterContainerInit_first";
    private static final String USER_FILTER_KEY = "singleProjectBenchFilter";
    private static final String CACHE_WBS_DEFAULT = "cache_wbs_default";
    private static final String CACHE_TASK_DEFAULT = "cache_task_default";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
        filtercontainerap.addSearchClickListener((SearchClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        String orgIdStr = Long.toString(orgId);
        this.getPageCache().put("verifyOrg", orgIdStr);
        this.getPageCache().put("createOrg", orgIdStr);
        this.getPageCache().put("createorg", orgIdStr);
        this.getPageCache().put("useorg", orgIdStr);
        this.getPageCache().put("mainOrgField", "useorg");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().equals("wbs.id")) {
            args.getQfilters().removeIf(x -> StringUtils.equals((CharSequence)x.getProperty(), (CharSequence)"status"));
            String project = SingleProjectBenchUtil.getProjectIdStr((IPageCache)this.getPageCache());
            if (StringUtils.isNotBlank((CharSequence)project)) {
                args.getQfilters().add(new QFilter("projectnum", "=", (Object)Long.parseLong(project)));
                String publishVersion = SingleProjectBenchUtil.getPublishVersion((IPageCache)this.getPageCache());
                args.addCustomParam("versionId", (Object)publishVersion);
                QFilter treeFilter = new QFilter("projectnum", "=", (Object)Long.parseLong(project)).and("status", "=", (Object)"C").and("enable", "=", (Object)Boolean.TRUE).and("version", "=", (Object)(StringUtils.isBlank((CharSequence)publishVersion) ? 0L : Long.parseLong(publishVersion)));
                args.addCustomParam("formTask", (Object)"true");
                args.addCustomParam("display_filter", (Object)treeFilter.toSerializedString());
            }
        } else if (args.getFieldName().equals("task.id")) {
            String wbsStr;
            args.getQfilters().removeIf(x -> StringUtils.equals((CharSequence)x.getProperty(), (CharSequence)"status"));
            String project = SingleProjectBenchUtil.getProjectIdStr((IPageCache)this.getPageCache());
            if (StringUtils.isNotBlank((CharSequence)project)) {
                args.getQfilters().add(new QFilter("projectnum", "=", (Object)Long.parseLong(project)));
                String publishVersion = SingleProjectBenchUtil.getPublishVersion((IPageCache)this.getPageCache());
                args.addCustomParam("versionId", (Object)publishVersion);
            }
            if (StringUtils.isNotBlank((CharSequence)(wbsStr = this.getPageCache().get(CACHE_WBS)))) {
                List wbsList = (List)SerializationUtils.fromJsonString((String)wbsStr, List.class);
                wbsList = wbsList.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
                ArrayList idList = new ArrayList();
                idList.addAll(wbsList);
                ProjectTreeUtil.queryWbsChild(wbsList, idList);
                args.getQfilters().add(new QFilter("wbs", "in", idList.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toSet())));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn commonFilterColumn;
        Long projectId = 0L;
        List<Object> wbsIdList = new ArrayList(10);
        List<Object> taskIdList = new ArrayList(10);
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get(FIRST_INIT))) {
            this.getPageCache().put(FIRST_INIT, "false");
            String filterSetStr = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)USER_FILTER_KEY);
            QFilter projectFilter = new QFilter("status", "=", (Object)"C");
            projectFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection projectDynColl = QueryServiceHelper.query((String)"pmpd_project", (String)"id, name", (QFilter[])new QFilter[]{projectFilter}, (String)"modifytime desc");
            if (!StringUtils.isBlank((CharSequence)filterSetStr)) {
                List qFilters = (List)SerializationUtils.fromJsonString((String)filterSetStr, List.class);
                Set projectIdSet = projectDynColl.stream().map(x -> x.getString("id")).collect(Collectors.toSet());
                Iterator iterator = qFilters.iterator();
                while (iterator.hasNext()) {
                    ArrayList<Long> objects;
                    Map qFilter = (Map)iterator.next();
                    if (qFilter == null) continue;
                    String property = (String)qFilter.get("property");
                    Object value = qFilter.get("value");
                    if (StringUtils.equals((CharSequence)property, (CharSequence)"project.id")) {
                        if (value == null || StringUtils.equals((CharSequence)"0", (CharSequence)value.toString()) || !projectIdSet.contains(value.toString())) break;
                        projectId = (Long)value;
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)property, (CharSequence)"wbs.id")) {
                        if (value instanceof List) {
                            wbsIdList = (List)value;
                            continue;
                        }
                        objects = new ArrayList();
                        objects.add((Long)value);
                        wbsIdList = objects;
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)property, (CharSequence)"task.id")) continue;
                    if (value instanceof List) {
                        taskIdList = (List)value;
                        continue;
                    }
                    objects = new ArrayList<Long>();
                    objects.add((Long)value);
                    taskIdList = objects;
                }
            }
            if (projectId == 0L && CollectionUtils.isNotEmpty((Collection)projectDynColl)) {
                projectId = ((DynamicObject)projectDynColl.get(0)).getLong("id");
            }
        } else {
            FilterContainer filtercontainerap = (FilterContainer)this.getControl("filtercontainerap");
            FilterContainerFilterValues cachedFilterValues = filtercontainerap.getCachedFilterValues();
            List filterValueCollection = cachedFilterValues.getOtherFilterValues().getFilterValueCollection();
            for (FilterKeyValueCollection filterKeyValueCollection : filterValueCollection) {
                List values = new ArrayList();
                boolean isProject = false;
                boolean isWbs = false;
                boolean isTask = false;
                for (FilterKeyValue filterKeyValue : filterKeyValueCollection.getFilterKeyValues()) {
                    String key = filterKeyValue.getKey();
                    if (StringUtils.equals((CharSequence)key, (CharSequence)"FieldName") && StringUtils.equals((CharSequence)filterKeyValue.getValue().get(0).toString(), (CharSequence)"project.id")) {
                        isProject = true;
                    } else if (StringUtils.equals((CharSequence)key, (CharSequence)"FieldName") && StringUtils.equals((CharSequence)filterKeyValue.getValue().get(0).toString(), (CharSequence)"wbs.id")) {
                        isWbs = true;
                    } else if (StringUtils.equals((CharSequence)key, (CharSequence)"FieldName") && StringUtils.equals((CharSequence)filterKeyValue.getValue().get(0).toString(), (CharSequence)"task.id")) {
                        isTask = true;
                    }
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"Value")) continue;
                    values = filterKeyValue.getValue();
                }
                if (isProject) {
                    projectId = Long.parseLong(values.get(0).toString());
                }
                if (isWbs) {
                    wbsIdList = values.stream().filter(x -> StringUtils.isNotBlank((Object)x)).map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
                }
                if (!isTask) continue;
                taskIdList = values.stream().filter(x -> StringUtils.isNotBlank((Object)x)).map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
            }
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!StringUtils.equals((CharSequence)commonFilterColumn.getFieldName(), (CharSequence)"project.name")) continue;
            commonFilterColumn.getComboItems().clear();
            QFilter projectFilter = new QFilter("status", "=", (Object)"C");
            projectFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection projectDynColl = QueryServiceHelper.query((String)"pmpd_project", (String)"id, name", (QFilter[])new QFilter[]{projectFilter});
            ArrayList<Object> combos = new ArrayList<Object>(16);
            for (DynamicObject col : projectDynColl) {
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(col.getLong("id")));
                item.setCaption(new LocaleString(col.getString("name")));
                item.setValue(String.valueOf(col.getLong("id")));
                combos.add(item);
            }
            commonFilterColumn.setComboItems(combos);
            commonFilterColumn.setDefaultValue(projectId.toString());
            SingleProjectBenchUtil.cacheProjectIdStr((IPageCache)this.getPageCache(), (String)projectId.toString());
            break;
        }
        for (FilterColumn filterColumn : commonFilterColumns) {
            List collect;
            String id;
            ComboItem item;
            ArrayList<ComboItem> combos;
            String publishVersion;
            QFilter qFilter;
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (StringUtils.equals((CharSequence)commonFilterColumn.getFieldName(), (CharSequence)"wbs.name")) {
                commonFilterColumn.getComboItems().clear();
                qFilter = new QFilter("projectnum", "=", (Object)projectId);
                qFilter.and(new QFilter("enable", "=", (Object)"1"));
                publishVersion = SingleProjectBenchUtil.getPublishVersion((IPageCache)this.getPageCache());
                qFilter.and(new QFilter("version", "=", (Object)(StringUtils.isBlank((CharSequence)publishVersion) ? 0L : Long.parseLong(publishVersion))));
                DynamicObjectCollection wbsDynColl = QueryServiceHelper.query((String)"pmts_wbs", (String)"id, name", (QFilter[])new QFilter[]{qFilter});
                combos = new ArrayList<ComboItem>(16);
                ArrayList<Long> wbsList = new ArrayList<Long>(wbsDynColl.size());
                for (DynamicObject col : wbsDynColl) {
                    item = new ComboItem();
                    wbsList.add(col.getLong("id"));
                    id = String.valueOf(col.getLong("id"));
                    item.setId(id);
                    item.setCaption(new LocaleString(col.getString("name")));
                    item.setValue(id);
                    combos.add(item);
                }
                commonFilterColumn.setComboItems(combos);
                wbsList.retainAll(wbsIdList);
                if (CollectionUtils.isEmpty(wbsList)) {
                    commonFilterColumn.setDefaultValue(null);
                    this.getPageCache().remove(CACHE_WBS_DEFAULT);
                    continue;
                }
                collect = wbsList.stream().map(x -> x.toString()).collect(Collectors.toList());
                commonFilterColumn.setDefaultValues(collect.toArray());
                this.getPageCache().put(CACHE_WBS_DEFAULT, SerializationUtils.toJsonString(wbsList));
                continue;
            }
            if (!StringUtils.equals((CharSequence)commonFilterColumn.getFieldName(), (CharSequence)"task.name")) continue;
            commonFilterColumn.getComboItems().clear();
            qFilter = new QFilter("projectnum", "=", (Object)projectId);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            publishVersion = SingleProjectBenchUtil.getPublishVersion((IPageCache)this.getPageCache());
            qFilter.and(new QFilter("version", "=", (Object)(StringUtils.isBlank((CharSequence)publishVersion) ? 0L : Long.parseLong(publishVersion))));
            if (CollectionUtils.isNotEmpty(wbsIdList)) {
                ArrayList<Object> idList = new ArrayList<Object>();
                idList.addAll(wbsIdList);
                ProjectTreeUtil.queryWbsChild(Arrays.asList(wbsIdList.toArray()), idList);
                qFilter.and(new QFilter("wbs", "in", idList));
            }
            DynamicObjectCollection taskDynColl = QueryServiceHelper.query((String)"pmts_task", (String)"id, name", (QFilter[])new QFilter[]{qFilter});
            combos = new ArrayList(16);
            ArrayList<Long> taskList = new ArrayList<Long>(taskDynColl.size());
            for (DynamicObject col : taskDynColl) {
                item = new ComboItem();
                taskList.add(col.getLong("id"));
                id = String.valueOf(col.getLong("id"));
                item.setId(id);
                item.setCaption(new LocaleString(col.getString("name")));
                item.setValue(id);
                combos.add(item);
            }
            commonFilterColumn.setComboItems(combos);
            taskList.retainAll(taskIdList);
            if (CollectionUtils.isEmpty(taskList)) {
                commonFilterColumn.setDefaultValue(null);
                this.getPageCache().remove(CACHE_TASK_DEFAULT);
                continue;
            }
            collect = taskList.stream().map(x -> x.toString()).collect(Collectors.toList());
            commonFilterColumn.setDefaultValues(collect.toArray());
            this.getPageCache().put(CACHE_TASK_DEFAULT, SerializationUtils.toJsonString(taskList));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        Map currentCommonFilter = args.getCurrentCommonFilter();
        List objectList = (List)currentCommonFilter.get("FieldName");
        String fieldName = objectList.get(0).toString();
        if (StringUtils.equals((CharSequence)"project.id", (CharSequence)fieldName)) {
            this.getPageCache().remove(CACHE_WBS);
        } else if (StringUtils.equals((CharSequence)"wbs.id", (CharSequence)fieldName)) {
            List valueList = (List)currentCommonFilter.get("Value");
            if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                this.getPageCache().put(CACHE_WBS, SerializationUtils.toJsonString((Object)valueList));
            } else {
                this.getPageCache().remove(CACHE_WBS);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getMergeQFilters();
        UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)USER_FILTER_KEY, (String)SerializationUtils.toJsonString((Object)qFilters));
    }

    public void click(SearchClickEvent searchClickEvent) {
        Map filterValues = searchClickEvent.getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        for (Map stringListMap : customfilter) {
            if (StringUtils.equals((CharSequence)((List)stringListMap.get("FieldName")).get(0).toString(), (CharSequence)"wbs.id")) {
                this.setDefaultValue(stringListMap, CACHE_WBS_DEFAULT);
                continue;
            }
            if (!StringUtils.equals((CharSequence)((List)stringListMap.get("FieldName")).get(0).toString(), (CharSequence)"task.id")) continue;
            this.setDefaultValue(stringListMap, CACHE_TASK_DEFAULT);
        }
    }

    private void setDefaultValue(Map<String, List<Object>> stringListMap, String cacheKey) {
        String s = this.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)s)) {
            stringListMap.put("Value", new ArrayList(1));
        } else {
            List valueList = (List)SerializationUtils.fromJsonString((String)s, List.class);
            stringListMap.put("Value", valueList.stream().map(x -> x.toString()).collect(Collectors.toList()));
        }
    }
}

