/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmts.common.model.workbench.GanttDataSourceModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeActionParam;
import kd.pmc.pmts.common.model.workbench.ProjectTreeBuildContext;
import kd.pmc.pmts.common.model.workbench.ProjectTreeResultModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeRowModel;
import kd.pmc.pmts.common.util.SingleProjectBenchLockUtils;
import kd.pmc.pmts.common.util.workbench.ProjectTreeUtil;
import kd.pmc.pmts.common.util.workbench.SingleProjectBenchUtil;
import kd.pmc.pmts.formplugin.workbench.action.ProjectTreeActionInterface;
import kd.pmc.pmts.formplugin.workbench.helper.ProjectTreeDataBuildHelper;

public class SingleProjectBenchTplPlugin
extends AbstractListPlugin
implements TabSelectListener {
    private static Log logger = LogFactory.getLog(SingleProjectBenchTplPlugin.class);
    private static final String CTRKEY = "custom_projecttree";
    private static final String ISPUBLISH = "ispublish";
    private static final String algokey = SingleProjectBenchTplPlugin.class.getName();

    public void registerListener(EventObject e) {
        Tab tabAp2;
        Tab tabAp1;
        super.registerListener(e);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        if (tabAp != null) {
            tabAp.addTabSelectListener((TabSelectListener)this);
        }
        if ((tabAp1 = (Tab)this.getView().getControl("tabap1")) != null) {
            tabAp1.addTabSelectListener((TabSelectListener)this);
        }
        if ((tabAp2 = (Tab)this.getView().getControl("tabap2")) != null) {
            tabAp2.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.projectTreeSetNullValue();
        this.getPageCache().put("singleClick", "kd.pmc.pmts.formplugin.workbench.action.SingleClickAction");
        this.cacheDataSourceModel();
    }

    private void cacheDataSourceModel() {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("modelentity.number", "in", Arrays.asList("pmts_task_gantt", "pmts_task_release_version"));
        DynamicObjectCollection mapColl = QueryServiceHelper.query((String)"msplan_gemapping", (String)"datasource, modelentity.number modelentity", (QFilter[])new QFilter[]{qFilter});
        Map<Object, String> geMap = mapColl.stream().collect(Collectors.toMap(x -> x.get("datasource"), x1 -> x1.getString("modelentity")));
        if (geMap != null && geMap.size() > 0) {
            QFilter ganttQFilter = new QFilter("id", "in", geMap.keySet());
            ganttQFilter.and(new QFilter("status", "=", (Object)"C"));
            ganttQFilter.and(new QFilter("enable", "=", (Object)"1"));
            Map dataSourceMap = BusinessDataServiceHelper.loadFromCache((String)"msplan_gantt_source", (String)"status, enable, gantttype, centity, cfilter_tag, fieldsortflag, rentity, rentityflag, ruplevelentity", (QFilter[])new QFilter[]{ganttQFilter});
            for (Map.Entry dataSourceEntry : dataSourceMap.entrySet()) {
                DynamicObject dataSourceDyn = (DynamicObject)dataSourceEntry.getValue();
                GanttDataSourceModel ganttDataSourceModel = new GanttDataSourceModel();
                DynamicObjectCollection entityselect = dataSourceDyn.getDynamicObjectCollection("entityselect");
                for (DynamicObject entryDyn : entityselect) {
                    if (!StringUtils.equals((CharSequence)entryDyn.getString("gantttype"), (CharSequence)"B")) continue;
                    DynamicObjectCollection conditionColl = entryDyn.getDynamicObjectCollection("entitycondition");
                    for (DynamicObject conditionDyn : conditionColl) {
                        String entityNumber = conditionDyn.getString("centity.number");
                        String filterStr = conditionDyn.getString("cfilter_tag");
                        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                            FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
                            fb.buildFilter(false);
                            ganttDataSourceModel.getEntityFilterMap().put(entityNumber, fb.getQFilters());
                        }
                        String sortStr = conditionDyn.getString("fieldsortflag");
                        ganttDataSourceModel.getEntitySortMap().put(entityNumber, sortStr);
                    }
                    DynamicObjectCollection relationColl = entryDyn.getDynamicObjectCollection("entityrelation");
                    Map entityUpFieldMap = ganttDataSourceModel.getEntityUpFieldMap();
                    Map upEntityMap = ganttDataSourceModel.getUpEntityMap();
                    for (DynamicObject relationDyn : relationColl) {
                        String entityNumber = relationDyn.getString("rentity.number");
                        String flag = relationDyn.getString("rentityflag");
                        String upEntityNumber = relationDyn.getString("ruplevelentity.number");
                        List fieldList = entityUpFieldMap.computeIfAbsent(entityNumber, k -> new ArrayList());
                        fieldList.add(flag);
                        List upList = upEntityMap.computeIfAbsent(entityNumber, k -> new ArrayList());
                        upList.add(upEntityNumber);
                    }
                }
                GanttBigObjectCache.put((String)this.getView().getPageId(), (String)geMap.get(dataSourceEntry.getKey()), (Object)ganttDataSourceModel);
            }
        }
    }

    private void projectTreeSetNullValue() {
        CustomControl customCtr = (CustomControl)this.getControl(CTRKEY);
        ProjectTreeResultModel resultModel = new ProjectTreeResultModel();
        resultModel.setMethodName("init");
        customCtr.setData((Object)resultModel);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getMergeQFilters();
        this.doQuery(qFilters);
    }

    private void doQuery(List<QFilter> qFilters) {
        boolean projectIsChange;
        List collect = qFilters.stream().filter(x -> x != null && StringUtils.equals((CharSequence)"project.id", (CharSequence)x.getProperty())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        Object projectId = ((QFilter)collect.get(0)).getValue();
        String preProjectIdStr = SingleProjectBenchUtil.getPreProjectIdStr((IPageCache)this.getPageCache());
        boolean bl = projectIsChange = !StringUtils.equals((CharSequence)preProjectIdStr, (CharSequence)projectId.toString());
        if (StringUtils.isNotBlank((CharSequence)preProjectIdStr) && projectIsChange) {
            SingleProjectBenchLockUtils.unLockProject((String)this.getView().getPageId(), (Long)Long.parseLong(preProjectIdStr));
        }
        DynamicObject publishVersionDyn = SingleProjectBenchUtil.queryPublishVersion((Object)projectId);
        ProjectTreeBuildContext context = new ProjectTreeBuildContext();
        GanttDataSourceModel sourceModel = null;
        if (publishVersionDyn != null) {
            if (projectIsChange) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u8ba1\u5212\u5df2\u53d1\u5e03\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002\u5982\u9700\u8981\u4fee\u6539\uff0c\u8bf7\u8fdb\u5165\u3010\u9879\u76ee\u8ba1\u5212\u8fdb\u5ea6\u9884\u6392\u3011\u8fdb\u884c\u53d8\u66f4\u3002", (String)"SingleProjectBenchTplPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("publishVersionId", publishVersionDyn.getString("id"));
            sourceModel = (GanttDataSourceModel)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"pmts_task_release_version");
            context.setIsPublish(Boolean.TRUE);
        } else {
            if (projectIsChange) {
                SingleProjectBenchLockUtils.lockProject((IFormView)this.getView(), (Long)((Long)projectId));
            }
            this.getPageCache().remove("publishVersionId");
            sourceModel = (GanttDataSourceModel)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"pmts_task_gantt");
            context.setIsPublish(Boolean.FALSE);
        }
        if (sourceModel == null) {
            String pageName = context.getIsPublish() != false ? ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u8fdb\u5ea6\u9884\u6392", (String)"SingleProjectBenchTplPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9879\u76ee\u8fdb\u5ea6\u4efb\u52a1\u53d1\u5e03\u7248\u672c", (String)"SingleProjectBenchTplPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4%s\u9875\u9762\u7684\u6570\u636e\u6e90\u3002", (String)"SingleProjectBenchTplPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[]{pageName}));
            return;
        }
        this.setPageEnable(context.getIsPublish());
        DynamicObject configDyn = ProjectTreeUtil.getProjectBenchConfig((Object)projectId);
        if (configDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u5bf9\u5e94\u7684\u5de5\u4f5c\u53f0\u914d\u7f6e\u65b9\u6848\u3002", (String)"SingleProjectBenchTplPlugin_4", (String)"mmc-pmts-formplugin", (Object[])new Object[0]));
            return;
        }
        logger.info(String.format("\u4f7f\u7528\u7684\u914d\u7f6e\uff1a%s", configDyn.getString("number")));
        List patchRelation = ProjectTreeUtil.getPatchRelation((DynamicObject)configDyn, (GanttDataSourceModel)sourceModel);
        context.setPageId(this.getView().getPageId());
        context.setConfigDyn(configDyn);
        context.setGanttSourceModel(sourceModel);
        context.setPatchRelation(patchRelation);
        this.cacheOpenPage(context, configDyn);
        SingleProjectBenchUtil.asynOpenProjectPage((IFormView)this.getView(), (Long)((Long)projectId));
        context.setqFilters(qFilters);
        ProjectTreeDataBuildHelper.sendProjectTreeData(this.getView(), context);
    }

    private void setPageEnable(Boolean isPublish) {
        if (isPublish.booleanValue()) {
            this.getPageCache().put(ISPUBLISH, isPublish.toString());
        } else {
            this.getPageCache().remove(ISPUBLISH);
        }
        this.getView().setEnable(Boolean.valueOf(isPublish == false), new String[]{"addwbs", "addtask"});
    }

    private void cacheOpenPage(ProjectTreeBuildContext context, DynamicObject configDyn) {
        HashMap<String, String> entityOpenPageMap = new HashMap<String, String>(16);
        DynamicObjectCollection entryColl = configDyn.getDynamicObjectCollection("configentry");
        for (DynamicObject dynamicObject : entryColl) {
            DynamicObject tabLayoutDyn = dynamicObject.getDynamicObject("tablelayout");
            if (tabLayoutDyn == null) continue;
            DynamicObject entityDyn = dynamicObject.getDynamicObject("confentity");
            String number = entityDyn.getString("number");
            entityOpenPageMap.put(number, tabLayoutDyn.getString("number"));
        }
        context.setEntityOpenPageMap(entityOpenPageMap);
        GanttBigObjectCache.put((String)this.getView().getPageId(), (String)"openPage", entityOpenPageMap);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String ctlkey = e.getKey();
        if (StringUtils.equals((CharSequence)ctlkey, (CharSequence)CTRKEY)) {
            String eventName = e.getEventName();
            String classPath = this.getPageCache().get(eventName);
            if (StringUtils.isBlank((CharSequence)classPath)) {
                try {
                    ProjectTreeRowModel rowModel = (ProjectTreeRowModel)SerializationUtils.fromJsonString((String)e.getEventArgs(), ProjectTreeRowModel.class);
                    String entityKey = rowModel.getEntityKey();
                    classPath = this.getPageCache().get(entityKey.concat("_").concat(eventName));
                }
                catch (Exception exception) {
                    logger.error("\u83b7\u53d6\u884c\u5bf9\u8c61\u5931\u8d25\uff1a", (Object)e);
                }
                if (StringUtils.isBlank((CharSequence)classPath)) {
                    logger.info(String.format("\u672a\u627e\u5230\u5b9e\u73b0\u7c7b, eventName:%s", eventName));
                    return;
                }
            }
            this.executeOp(classPath, eventName, e.getEventArgs());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("workbench_continue_close".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.continueExitCurPage();
            } else {
                this.returnEditPage();
            }
        }
    }

    private void returnEditPage() {
        String cacheQueue = this.getView().getPageCache().get("cur_nodeid");
        if (StringUtils.isNotBlank((CharSequence)cacheQueue)) {
            HashMap<String, Object> treeResultModel = new HashMap<String, Object>(4);
            HashMap<String, String> resultData = new HashMap<String, String>(1);
            resultData.put("id", cacheQueue);
            treeResultModel.put("data", resultData);
            treeResultModel.put("success", true);
            treeResultModel.put("methodName", "updateDetailId");
            treeResultModel.put("time_tag", System.currentTimeMillis());
            CustomControl control = (CustomControl)this.getControl(CTRKEY);
            control.setData(treeResultModel);
        }
    }

    private void continueExitCurPage() {
        String eventArgs = this.getView().getPageCache().get("CustomEventArgs");
        this.getView().getPageCache().remove("CustomEventArgs");
        if (StringUtils.isNotBlank((CharSequence)eventArgs)) {
            SingleProjectBenchUtil.setNotChangedByPageId((IFormView)this.getView(), (String)"flex_change");
            this.executeOp("kd.pmc.pmts.formplugin.workbench.action.SingleClickAction", "singleClick", eventArgs);
        }
    }

    private void executeOp(String classPath, String eventName, String eventArgs) {
        Object classInstance = TypesContainer.createInstance((String)classPath);
        if (classInstance instanceof ProjectTreeActionInterface) {
            ProjectTreeActionParam param = new ProjectTreeActionParam(this.getView(), (IFormPlugin)this, eventName, eventArgs);
            ProjectTreeActionInterface instance = (ProjectTreeActionInterface)classInstance;
            instance.execute(param);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.doRptTabSelected(tabKey);
    }

    private void doRptTabSelected(String tabKey) {
        switch (tabKey) {
            case "tab_change": {
                SingleProjectBenchUtil.showChangeTabInfo((IFormView)this.getView());
                break;
            }
            case "tab_projproduct": {
                this.handleProjProductTab(tabKey);
                break;
            }
            case "tab_projoutproduct": {
                this.handleProjOutProductTab(tabKey);
                break;
            }
            case "tab_projsale": {
                String projSaleSum = this.getCacheTabPageId("tab_projsalesum");
                Boolean isFirstOpen = this.checkTabFirstOpen("tab_projsale");
                if (!isFirstOpen.booleanValue() && !StringUtils.isEmpty((CharSequence)projSaleSum)) break;
                this.doRptTabSelected("tab_projsalesum");
                break;
            }
            case "tab_projsalesum": {
                this.handleProjSaleSum(tabKey);
                break;
            }
            case "tab_projfulacct": {
                this.handleProjFulAcct(tabKey);
                break;
            }
            case "tab_projorserexec": {
                this.handleProjSerExec(tabKey);
                break;
            }
            case "tab_projsumcontract": {
                String projContSumPageId = this.getCacheTabPageId("tab_projcontractsum");
                Boolean isFirstOpenPur = this.checkTabFirstOpen("tab_projsumcontract");
                if (!isFirstOpenPur.booleanValue() && !StringUtils.isEmpty((CharSequence)projContSumPageId)) break;
                this.doRptTabSelected("tab_projcontractsum");
                break;
            }
            case "tab_projcontractsum": {
                this.handleProjContractSum(tabKey);
                break;
            }
            case "tab_projfuldetail": {
                this.handleProjFulDetail(tabKey);
                break;
            }
            case "tab_projorderexec": {
                this.handleProjOrderExec(tabKey);
                break;
            }
            default: {
                logger.warn("Unknown tab key: " + tabKey);
            }
        }
    }

    private Boolean checkTabFirstOpen(String parentTab) {
        String tabCacheKey = SingleProjectBenchUtil.getFirstOpenTabCacheKey((String)parentTab);
        String firstOpen = this.getView().getPageCache().get(tabCacheKey);
        this.getView().getPageCache().remove(tabCacheKey);
        return "TRUE".equals(firstOpen);
    }

    private void handleProjFulDetail(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("pmts_purexecutedetailed");
        this.showReportView("pmts_purexecutedetailed", tabKey, customParams, null);
    }

    private void handleProjFulAcct(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("pmts_salexecutedetailed");
        this.showReportView("pmts_salexecutedetailed", tabKey, customParams, null);
    }

    private void handleProjOrderExec(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("pmts_purorderbillrpt_new");
        this.showReportView("pmts_purorderbillrpt_new", tabKey, customParams, null);
    }

    private void handleProjContractSum(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("pmts_pursynthesisrpt");
        this.showReportView("pmts_pursynthesisrpt", tabKey, customParams, null);
    }

    private void handleProjSerExec(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("pmts_salorderbillrpt");
        this.showReportView("pmts_salorderbillrpt", tabKey, customParams, null);
    }

    private void handleProjSaleSum(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("pmts_salsynthesisrpt");
        this.showReportView("pmts_salsynthesisrpt", tabKey, customParams, null);
    }

    private void handleProjOutProductTab(String tabKey) {
        Map<String, Object> customParams = this.prepareCommonParams("om_mftorder");
        ArrayList<String> plugins = new ArrayList<String>(){
            {
                this.add("kd.bd.mpdm.report.tpl.OrderExecuteDetailSearchFormPlugin");
            }
        };
        this.showReportView("mpdm_projorderdetail_tpl", tabKey, customParams, (List<String>)plugins);
    }

    private void handleProjProductTab(String tabKey) {
        ArrayList<String> plugins = new ArrayList<String>(){
            {
                this.add("kd.bd.mpdm.report.tpl.OrderExecuteDetailSearchFormPlugin");
            }
        };
        Map<String, Object> customParams = this.prepareCommonParams("pom_mftorder");
        this.showReportView("mpdm_projorderdetail_tpl", tabKey, customParams, (List<String>)plugins);
    }

    private void showReportView(String reportNumber, String tabFlexName, Map<String, Object> customParam, List<String> plugins) {
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setFormId(reportNumber);
        reportShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        reportShowParameter.getOpenStyle().setTargetKey(tabFlexName);
        if (!CollectionUtils.isEmpty(plugins)) {
            for (String string : plugins) {
                reportShowParameter.addCustPlugin(string);
            }
        }
        reportShowParameter.addCustPlugin("kd.bd.mpdm.formplugin.report.ReportAutoQueryCommonPlugin");
        for (Map.Entry entry : customParam.entrySet()) {
            reportShowParameter.setCustomParam((String)entry.getKey(), entry.getValue());
        }
        this.cacheTabPageId(tabFlexName, (FormShowParameter)reportShowParameter);
        this.getView().showForm((FormShowParameter)reportShowParameter);
    }

    private String getPageIdCacheKey(String tabFlexName) {
        return tabFlexName + "_pageId";
    }

    private void cacheTabPageId(String tabFlexName, FormShowParameter showParameter) {
        String pageId = tabFlexName + "_" + this.getView().getPageId();
        this.getPageCache().put(this.getPageIdCacheKey(tabFlexName), pageId);
    }

    private String getCacheTabPageId(String tabFlexName) {
        return this.getPageCache().get(this.getPageIdCacheKey(tabFlexName));
    }

    private Map<String, Object> prepareCommonParams(String order) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        String selectEntity = this.getView().getPageCache().get("selectEntity");
        String selectDataIdStr = this.getView().getPageCache().get("selectDataId");
        String cacheProjectIdStr = this.getView().getPageCache().get("cache_project");
        if (StringUtils.isNotBlank((CharSequence)cacheProjectIdStr)) {
            Long projectId = Long.parseLong(cacheProjectIdStr);
            DynamicObject projectObj = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id,number,expstartdate,expfinshdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)projectId)});
            Date startDate = projectObj.getDate("expstartdate");
            Date endDate = projectObj.getDate("expfinshdate");
            customParams.put("query_startDate", SingleProjectBenchUtil.formatDate((Date)startDate));
            customParams.put("query_endDate", SingleProjectBenchUtil.formatDate((Date)endDate));
            customParams.put("query_projectid", cacheProjectIdStr);
        }
        if ("pmts_wbs".equals(selectEntity)) {
            if (StringUtils.isNotBlank((CharSequence)selectDataIdStr)) {
                Long purchaseorg;
                Long saleorg;
                Long wbsId = Long.parseLong(selectDataIdStr);
                DynamicObject wbsEntity = QueryServiceHelper.queryOne((String)"pmts_wbs", (String)"id,productorg,saleorg,purchaseorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wbsId)});
                Long productorg = wbsEntity.getLong("productorg");
                if (productorg != null && !productorg.equals(0L)) {
                    customParams.put("query_productorg", String.valueOf(productorg));
                }
                if ((saleorg = Long.valueOf(wbsEntity.getLong("saleorg"))) != null && !saleorg.equals(0L)) {
                    customParams.put("query_saleorg", String.valueOf(saleorg));
                }
                if ((purchaseorg = Long.valueOf(wbsEntity.getLong("purchaseorg"))) != null && !purchaseorg.equals(0L)) {
                    customParams.put("query_purchaseorg", String.valueOf(purchaseorg));
                }
                customParams.put("query_wbs", SerializationUtils.toJsonString(Collections.singleton(this.getInitVersionWBSId(wbsId))));
            }
        } else if (StringUtils.isNotBlank((CharSequence)cacheProjectIdStr)) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)algokey, (String)"pmts_wbs", (String)"id,projectnum,productorg,saleorg", (QFilter[])new QFilter[]{new QFilter("projectnum", "=", (Object)Long.parseLong(cacheProjectIdStr))}, null);){
                Long saleOrgId;
                Long productOrgId;
                HashSet<Long> wbsIds = new HashSet<Long>(2);
                HashSet<Long> productOrgs = new HashSet<Long>(2);
                HashSet<Long> saleOrgs = new HashSet<Long>(2);
                for (Row row : ds) {
                    Long saleorg;
                    wbsIds.add(row.getLong("id"));
                    Long productorg = row.getLong("productorg");
                    if (productorg != 0L) {
                        productOrgs.add(productorg);
                    }
                    if ((saleorg = row.getLong("saleorg")) == 0L) continue;
                    saleOrgs.add(saleorg);
                }
                customParams.put("query_wbs", null);
                if (productOrgs.size() > 0 && (productOrgId = (Long)productOrgs.iterator().next()) != null && !productOrgId.equals(0L)) {
                    customParams.put("query_productorg", String.valueOf(productOrgId));
                }
                if (saleOrgs.size() > 0 && (saleOrgId = (Long)saleOrgs.iterator().next()) != null && !saleOrgId.equals(0L)) {
                    customParams.put("query_saleorg", String.valueOf(saleOrgId));
                }
            }
        }
        customParams.put("order", order);
        return customParams;
    }

    private Long getInitVersionWBSId(Long wbsId) {
        Long initId;
        DynamicObject wbsObj = QueryServiceHelper.queryOne((String)"pmts_wbs", (String)"id,initid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wbsId)});
        if (wbsObj != null && (initId = Long.valueOf(wbsObj.getLong("initid"))) != 0L) {
            return initId;
        }
        return wbsId;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().getParentView().close();
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

