/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.utils.ObjectMapperUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mpscmm.msplan.formplugin.gantt.OpenBillFieldUtil;
import kd.pmc.pmts.business.helper.workbench.WorkBenchConfigHelper;
import kd.pmc.pmts.common.model.WorkBenchConfigFieldMappingModel;
import org.apache.commons.collections4.CollectionUtils;

public class WorkBenchConfigPlanEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(WorkBenchConfigPlanEdit.class);
    private static final String SYSTEM_TYPE = "mmc-pmts-formplugin";
    public static final String SUFFIX = "_mmc_formula";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String algokey = WorkBenchConfigPlanEdit.class.getName();
    public static final String PMTS_WKBENCHFIELD_DEF = "pmts_wkbenchfield_def";
    public static final String DELETECONFIGENTRY = "deleteconfigentry";
    public static final String MATERIL_PNODEO_STR = "{\"pmts_task\":\"task\",\"pmts_wbs\":\"wbs\",\"pmpd_project\":\"project\"}";
    public static final String GANTTTYPE_TASK = "B";

    public void registerListener(EventObject e) {
        BasedataEdit tableLayout;
        super.registerListener(e);
        BasedataEdit confEntity = (BasedataEdit)this.getView().getControl("confentity");
        if (confEntity != null) {
            confEntity.addBeforeF7SelectListener(this::beforeConfEntitySelect);
        }
        if ((tableLayout = (BasedataEdit)this.getView().getControl("tablelayout")) != null) {
            tableLayout.addBeforeF7SelectListener(this::beforeTableLayoutSelect);
        }
        this.addClickListeners(new String[]{"filtertext", "fielddispmap", "fieldsort", "applicondition", "headfiltertext"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setConfiguredData();
    }

    private void setConfiguredData() {
        DynamicObjectCollection configEntry = this.getModel().getEntryEntity("configentry");
        if (CollectionUtils.isNotEmpty((Collection)configEntry)) {
            for (int i = 0; i < configEntry.size(); ++i) {
                Boolean configured = (Boolean)this.getModel().getValue("configured", i);
                this.getModel().setValue("fielddispmap", (Object)this.getConfigStr(configured), i);
            }
        }
    }

    private String getConfigStr(Boolean hasConfig) {
        return hasConfig != null && hasConfig != false ? ResManager.loadKDString((String)"\u5df2\u914d\u7f6e", (String)"WorkBenchConfigPlanEdit_5", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u914d\u7f6e", (String)"WorkBenchConfigPlanEdit_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        this.fillConfigEntry();
    }

    private void beforeTableLayoutSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        this.validateEntryEntityEntered();
        DynamicObject curConfEntryRowObj = this.getCurConfEntryRowObj();
        if (curConfEntryRowObj != null) {
            DynamicObject confEntity = curConfEntryRowObj.getDynamicObject("confentity");
            List<Object> billLayoutWithoutExtByFormId = this.getBillLayoutWithoutExtByFormId(confEntity.getString("number"), confEntity.getString("modeltype"));
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", billLayoutWithoutExtByFormId));
        }
    }

    private List<Object> getBillLayoutWithoutExtByFormId(String formId, String domainModelType) {
        ArrayList<Object> layouts = new ArrayList<Object>(10);
        DynamicObject formData = WorkBenchConfigHelper.getOrigFormId((String)formId);
        if (formData != null) {
            DynamicObject[] formDatas;
            String masterid = formData.getString("masterid");
            if (StringUtils.isBlank((CharSequence)masterid)) {
                masterid = formData.getDynamicObject("basedatafield").getString("id");
            }
            QFilter[] filters = new QFilter[]{new QFilter("basedatafield", "=", (Object)masterid).and(new QFilter("modeltype", "=", (Object)domainModelType))};
            for (DynamicObject form : formDatas = BusinessDataServiceHelper.load((String)BOS_FORMMETA, (String)"id, number, name", (QFilter[])filters)) {
                layouts.add(form.getString("id"));
            }
        }
        return layouts;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"filtertext", (CharSequence)key)) {
            this.entryFilterClick("filtertext");
        } else if (StringUtils.equals((CharSequence)"fielddispmap", (CharSequence)key)) {
            this.fieldDispMapTextClick();
        } else if (StringUtils.equals((CharSequence)"fieldsort", (CharSequence)key)) {
            this.fieldSortClick(key);
        }
    }

    private void fieldDispMapTextClick() {
        DynamicObject fieldConfig = (DynamicObject)this.getModel().getValue("fieldconfig");
        if (fieldConfig != null) {
            DynamicObject curConfEntryRowObj = this.getCurConfEntryRowObj();
            if (curConfEntryRowObj != null) {
                DynamicObject confEntity = (DynamicObject)curConfEntryRowObj.get("confentity");
                if (confEntity == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b9a\u4e49\u4e3a\u7a7a,\u8bf7\u5148\u7ed9\u5b9e\u4f53\u5b9a\u4e49\u8d4b\u503c\u3002", (String)"WorkBenchConfigPlanEdit_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                this.showFieldDispConfig(fieldConfig.getLong("id"), confEntity.getString("number"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f5c\u53f0\u5b57\u6bb5\u5b9a\u4e49\u4e3a\u7a7a,\u8bf7\u7ef4\u62a4\u3002", (String)"WorkBenchConfigPlanEdit_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private List<WorkBenchConfigFieldMappingModel> getConfigModels() {
        DynamicObjectCollection subEntryColl;
        ArrayList<Object> models = new ArrayList<WorkBenchConfigFieldMappingModel>(0);
        DynamicObject curConfEntryRowObj = this.getCurConfEntryRowObj();
        if (curConfEntryRowObj != null && CollectionUtils.isNotEmpty((Collection)(subEntryColl = curConfEntryRowObj.getDynamicObjectCollection("fieldmapsubentry")))) {
            models = new ArrayList(subEntryColl.size());
            for (DynamicObject subObj : subEntryColl) {
                WorkBenchConfigFieldMappingModel model = new WorkBenchConfigFieldMappingModel(subObj.getString("fieldindentif"), subObj.getString("fieldname"), Integer.valueOf(subObj.getInt("colwidth")), subObj.getString("fieldconf"), subObj.getString("fieldconftag"), Long.valueOf(subObj.getLong("fieldconfentryid")), Boolean.valueOf(subObj.getBoolean("isprojstruct")), Integer.valueOf(subObj.getInt("seq")));
                models.add(model);
            }
        }
        return models;
    }

    private void showFieldDispConfig(Long fieldConfigId, String entityNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmts_fielddispconfig");
        showParameter.setCustomParam("fieldConfigId", (Object)String.valueOf(fieldConfigId));
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        List<WorkBenchConfigFieldMappingModel> configModels = this.getConfigModels();
        if (CollectionUtils.isNotEmpty(configModels)) {
            showParameter.setCustomParam("configModels", (Object)SerializationUtils.toJsonString(configModels));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fielddispmap"));
        this.getView().showForm(showParameter);
    }

    private DynamicObject getCurConfEntryRowObj() {
        Integer curConfEntryIndex = this.getCurConfEntryIndex();
        if (curConfEntryIndex >= 0) {
            DynamicObjectCollection entrys = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("configentry");
            return (DynamicObject)entrys.get(this.getCurConfEntryIndex().intValue());
        }
        return null;
    }

    private Integer getCurConfEntryIndex() {
        return this.getModel().getEntryCurrentRowIndex("configentry");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        String actionId = evt.getActionId();
        if (returnData != null) {
            if ("filtertext".equals(actionId)) {
                this.getModel().beginInit();
                int index = this.getModel().getEntryCurrentRowIndex("configentry");
                this.getModel().setValue("filter_tag", (Object)this.getFilterTagAndValue(returnData, "filterString"), index);
                this.getModel().setValue("filtertext", (Object)this.translateJsonString(this.getFilterTagAndValue(returnData, "filterString"), this.getFilterTagAndValue(returnData, "number")), index);
                this.getModel().endInit();
                this.getView().updateView("configentry", index);
            } else if ("fielddispmap".equals(actionId)) {
                this.fieldDispMapClosedCallBack(returnData);
            } else if ("fieldsort".equals(actionId)) {
                OpenBillFieldUtil.setFieldProp((String)((String)returnData), (String)"fieldsort", (String)"fieldsortflag", (String)"configentry", (IDataModel)this.getModel(), (String)"confentity");
            }
        }
    }

    private String projectTypeJson() {
        String templateCondition = "{\"filterRow\":[{\"id\":\"42TSKKE=2+GK\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"pjtype.number\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"42TTTTEX=FXI\",\"value\":\"riskparaset_unittest\"},{\"id\":\"42TTTTEX=F89\",\"value\":\"riskmatrixdiagram_unittest\"}],\"baseDataIds\":[{\"id\":\"42TTTTEX=FXJ\",\"value\":\"1365947034376528896\"},{\"id\":\"42TTTTEX=F8=\",\"value\":\"1367225509121073152\"}],\"lock\":false}],\"forList\":false}";
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)templateCondition, FilterCondition.class);
        SimpleFilterRow simpleFilterRow = (SimpleFilterRow)condition.getFilterRow().get(0);
        List filterValues = simpleFilterRow.getValue();
        List baseDataIds = simpleFilterRow.getBaseDataIds();
        filterValues.clear();
        baseDataIds.clear();
        DynamicObjectCollection mulProjTypes = (DynamicObjectCollection)this.getModel().getValue("mulprojtypes");
        if (CollectionUtils.isNotEmpty((Collection)mulProjTypes)) {
            for (DynamicObject mulprojType : mulProjTypes) {
                DynamicObject projType = mulprojType.getDynamicObject("fbasedataid");
                FilterValue filterValue = new FilterValue();
                filterValue.setId(DB.genStringId((String)"t_pmts_confplan_entry"));
                filterValue.setValue((Object)projType.getString("number"));
                filterValues.add(filterValue);
                FilterValue filterValue1 = new FilterValue();
                filterValue1.setId(DB.genStringId((String)"t_pmts_confplan_entry"));
                filterValue1.setValue((Object)projType.getLong("id"));
                baseDataIds.add(filterValue1);
            }
        }
        return SerializationUtils.toJsonString((Object)condition);
    }

    private void fieldDispMapClosedCallBack(Object returnData) {
        try {
            List models = (List)ObjectMapperUtils.getMapper((boolean)false).readValue((String)returnData, (TypeReference)new TypeReference<List<WorkBenchConfigFieldMappingModel>>(){});
            if (CollectionUtils.isNotEmpty((Collection)models)) {
                this.getModel().beginInit();
                this.getModel().deleteEntryData("fieldmapsubentry");
                this.getModel().batchCreateNewEntryRow("fieldmapsubentry", models.size());
                for (int index = 0; index < models.size(); ++index) {
                    this.getModel().setValue("fieldindentif", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getFieldIndentif(), index);
                    this.getModel().setValue("fieldname", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getFieldName(), index);
                    this.getModel().setValue("colwidth", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getColWidth(), index);
                    this.getModel().setValue("fieldconfentryid", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getFieldConfEntryId(), index);
                    this.getModel().setValue("fieldconftag", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getFieldConfTag(), index);
                    this.getModel().setValue("fieldconf", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getFieldConf(), index);
                    this.getModel().setValue("isprojstruct", (Object)((WorkBenchConfigFieldMappingModel)models.get(index)).getProjStruct(), index);
                }
                this.getModel().endInit();
                this.getView().updateView("fieldmapsubentry");
                this.getModel().setValue("configured", (Object)Boolean.TRUE, this.getCurConfEntryIndex().intValue());
            }
        }
        catch (JsonProcessingException e) {
            logger.info("WorkBenchConfigPlanEdit.fieldDispMapClosedCallBack fail:" + e.getMessage());
        }
    }

    private void beforeConfEntitySelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        HashSet entityTypeSet = new HashSet(){
            {
                this.add("pmts_materialreqlist");
            }
        };
        HashSet<String> hasConfEntitys = new HashSet<String>(2);
        DynamicObjectCollection confEntry = this.getModel().getEntryEntity("configentry");
        if (CollectionUtils.isNotEmpty((Collection)confEntry)) {
            for (DynamicObject entryObj : confEntry) {
                String confEntryId = entryObj.getString("confentity.id");
                if (!StringUtils.isNotEmpty((CharSequence)confEntryId)) continue;
                hasConfEntitys.add(confEntryId);
            }
        }
        beforeF7SelectEvent.addCustomQFilter(new QFilter("number", "in", (Object)entityTypeSet.toArray(new String[0])).and("number", "not in", (Object)hasConfEntitys.toArray(new String[0])));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean fromGantt;
        DynamicObject curConfEntryRowObj;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (DELETECONFIGENTRY.equals(operateKey) && (curConfEntryRowObj = this.getCurConfEntryRowObj()) != null && (fromGantt = curConfEntryRowObj.getBoolean("fromgantt"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u8bf7\u5728\u7518\u7279\u56fe\u6570\u636e\u6e90\u4e0a\u7ef4\u62a4\u3002", (String)"WorkBenchConfigPlanEdit_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changedName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("filtertext".equals(changedName)) {
            this.getModel().setValue("filter_tag", null);
        } else if ("confentity".equals(changedName)) {
            DynamicObject newObj = (DynamicObject)newValue;
            this.changeEntryData(newObj);
        } else if ("fielddispmap".equals(changedName)) {
            this.emptyClearFieldMapSubEntryMap(e);
        } else if ("mulprojtypes".equals(changedName)) {
            this.setProjTypeFilterJson(e);
        } else if ("headfiltertext".equals(changedName)) {
            if (StringUtils.isBlank((Object)newValue)) {
                this.getModel().setValue("headfilter_tag", null);
            }
        } else if ("applicondition".equals(changedName)) {
            if (StringUtils.isBlank((Object)newValue)) {
                this.getModel().setValue("applicond_save_tag", null);
            }
        } else if ("fieldconfig".equals(changedName)) {
            this.clearFieldMapping();
        } else if ("configured".equals(changedName)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            this.setConfigured((Boolean)newValue, rowIndex);
        }
    }

    private void setConfigured(Boolean newValue, Integer rowIndex) {
        this.getModel().setValue("fielddispmap", (Object)this.getConfigStr(newValue), rowIndex.intValue());
    }

    private void clearFieldMapping() {
        int index;
        this.getModel().beginInit();
        DynamicObjectCollection entryentityCols = this.getModel().getEntryEntity("configentry");
        if (CollectionUtils.isNotEmpty((Collection)entryentityCols)) {
            for (index = 0; index < entryentityCols.size(); ++index) {
                DynamicObject entryentity = (DynamicObject)entryentityCols.get(index);
                DynamicObjectCollection subentryentryCols = entryentity.getDynamicObjectCollection("fieldmapsubentry");
                if (!CollectionUtils.isNotEmpty((Collection)subentryentryCols)) continue;
                subentryentryCols.clear();
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
        for (index = 0; index < entryentityCols.size(); ++index) {
            this.getModel().setValue("configured", (Object)Boolean.FALSE, index);
        }
    }

    private void setProjTypeFilterJson(PropertyChangedArgs e) {
        DynamicObjectCollection newValue = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
        if (!CollectionUtils.isEmpty((Collection)newValue)) {
            String projTypeFilterJson = this.projectTypeJson();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("number", "pmpd_project");
            map.put("filterString", projTypeFilterJson);
            this.getModel().setValue("headfilter_tag", (Object)projTypeFilterJson);
            this.getModel().setValue("headfiltertext", (Object)this.translateJsonString(this.getFilterTagAndValue(map, "filterString"), this.getFilterTagAndValue(map, "number")));
        } else {
            this.getModel().setValue("headfiltertext", null);
        }
    }

    private void emptyClearFieldMapSubEntryMap(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().deleteEntryData("fieldmapsubentry");
            this.getModel().setValue("configured", (Object)Boolean.TRUE, this.getCurConfEntryIndex().intValue());
            this.getModel().setValue("configured", (Object)Boolean.FALSE, this.getCurConfEntryIndex().intValue());
        }
    }

    private void changeEntryData(DynamicObject newObj) {
        boolean notEmptyNew = newObj != null;
        boolean isMaterial = notEmptyNew && "pmts_materialreqlist".equals(newObj.get("number")) ? Boolean.TRUE : Boolean.FALSE;
        int curConfEntryIndex = this.getCurConfEntryIndex();
        this.getModel().setValue("filtertext", null, curConfEntryIndex);
        this.getModel().setValue("filter", null, curConfEntryIndex);
        this.getModel().setValue("fieldsort", null, curConfEntryIndex);
        this.getModel().setValue("fieldsortflag", null, curConfEntryIndex);
        this.getModel().setValue("tablelayout", null, curConfEntryIndex);
        this.getModel().setValue("configured", (Object)Boolean.FALSE, curConfEntryIndex);
        this.getModel().setValue("pnodestr", null, curConfEntryIndex);
        this.getModel().deleteEntryData("fieldmapsubentry");
        if (notEmptyNew) {
            this.getModel().setValue("tablelayout", (Object)WorkBenchConfigHelper.getOrigFormId((String)newObj.getString("number")), curConfEntryIndex);
        }
        if (isMaterial) {
            this.getModel().setValue("pnodestr", (Object)MATERIL_PNODEO_STR, curConfEntryIndex);
        }
    }

    private void fillConfigEntry() {
        DynamicObject[] ganttDatas;
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("modelentity.number", "in", Arrays.asList("pmts_task_gantt", "pmts_task_release_version"));
        DynamicObjectCollection mapColl = QueryServiceHelper.query((String)"msplan_gemapping", (String)"id,datasource", (QFilter[])new QFilter[]{qFilter});
        HashSet geMappings = new HashSet(2);
        HashSet ganttDataSrcs = new HashSet(2);
        mapColl.forEach(t -> {
            geMappings.add(t.getLong("id"));
            ganttDataSrcs.add(t.getLong("datasource"));
        });
        HashSet<String> entityNumberSet = new HashSet<String>(2);
        int rowIndex = 0;
        for (DynamicObject ganttSourceObj : ganttDatas = BusinessDataServiceHelper.load((String)"msplan_gantt_source", (String)this.getGanttSrcSelectProperties(), (QFilter[])new QFilter[]{new QFilter("id", "in", ganttDataSrcs)})) {
            DynamicObjectCollection entitySelectColl = ganttSourceObj.getDynamicObjectCollection("entityselect");
            for (DynamicObject entityRowObj : entitySelectColl) {
                if (entityRowObj == null || !entityRowObj.getString("gantttype").equals(GANTTTYPE_TASK)) continue;
                List entityPKValues = WorkBenchConfigHelper.getEntityObjs((DynamicObject)entityRowObj);
                Map origFormIdMap = WorkBenchConfigHelper.getOrigFormId(new HashSet(entityPKValues));
                for (String entityPKValue : entityPKValues) {
                    if (!entityNumberSet.add(entityPKValue)) continue;
                    this.getModel().createNewEntryRow("configentry");
                    this.getModel().setValue("confentity", (Object)entityPKValue, rowIndex);
                    this.getModel().setValue("tablelayout", origFormIdMap.get(entityPKValue), rowIndex);
                    this.getModel().setValue("fromgantt", (Object)Boolean.TRUE, rowIndex);
                    ++rowIndex;
                }
            }
        }
    }

    private String getGanttSrcSelectProperties() {
        return "entityselect,entityselect.gantttype,entityselect.entity,entityselect.gantttype,entityselect.upupgroupentity,entityselect.upgroupentity,entityselect.groupentity";
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    private void validateEntryEntityEntered() {
        Object confEntity;
        DynamicObject entity = this.getCurConfEntryRowObj();
        if (entity != null && (confEntity = entity.get("confentity")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b9a\u4e49\u4e3a\u7a7a,\u8bf7\u5148\u7ed9\u5b9e\u4f53\u5b9a\u4e49\u8d4b\u503c\u3002", (String)"WorkBenchConfigPlanEdit_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void entryFilterClick(String actionId) {
        DynamicObject entity = this.getCurConfEntryRowObj();
        this.validateEntryEntityEntered();
        if (entity != null) {
            this.filterTextClick(actionId, entity.getDynamicObject("confentity").getString("number"), entity.getString("filter_tag"));
        }
    }

    private void fieldSortClick(String key) {
        String oldSortStr = ObjectUtils.isEmpty((Object)this.getModel().getValue("fieldsortflag")) ? "" : (String)this.getModel().getValue("fieldsortflag");
        OpenBillFieldUtil.openBillFieldListEntry((String)"confentity", (String)"confentity", (IFormView)this.getView(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, key), (boolean)Boolean.FALSE, (String)oldSortStr);
    }

    private void filterTextClick(String actionId, String entityobj, String billfilterstr) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("msplan_filter_condition");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4", (String)"WorkBenchConfigPlanEdit_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        showParameter.setCustomParam("billfilterstr", (Object)billfilterstr);
        showParameter.setCustomParam("entityobj", (Object)entityobj);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getFilterTagAndValue(Object returnData, String flag) {
        return (String)((Map)returnData).get(flag);
    }

    protected String translateJsonString(String filters, String number) {
        if (StringUtils.isBlank((CharSequence)filters) || StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filters, FilterCondition.class);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)number);
        String filterStr = this.convertFilterCondition(filterCondition, mainType);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition, false);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return filterStr;
    }

    protected String convertFilterCondition(FilterCondition filterCondition, MainEntityType mainType) {
        List simpleFilterRows = filterCondition.getFilterRow();
        Iterator simpleFilterRowIterator = simpleFilterRows.iterator();
        StringBuilder filterStr = new StringBuilder();
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(16);
        FilterCondition fc = new FilterCondition();
        int row = 1;
        int size = simpleFilterRows.size();
        while (simpleFilterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)simpleFilterRowIterator.next();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            simpleFilterRow.setLeftBracket("");
            simpleFilterRow.setRightBracket("");
            String logicDesc = "";
            String logic = simpleFilterRow.getLogic();
            logicDesc = "1".equals(logic) ? ResManager.loadKDString((String)"\u6216\u8005", (String)"DataSoureEdit_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e76\u4e14", (String)"DataSoureEdit_15", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            String fieldName = simpleFilterRow.getFieldName();
            List filterValues = simpleFilterRow.getValue();
            UserService userService = new UserService();
            if (fieldName.endsWith(SUFFIX) && filterValues != null && !filterValues.isEmpty()) {
                simpleFilterRow.setValue(new ArrayList(0));
            } else {
                filterRow.add(simpleFilterRow);
                fc.setFilterRow(filterRow);
                FilterBuilder fb = new FilterBuilder(mainType, fc, false);
                fb.setUserService((IUserService)userService);
                fb.buildFilter(false);
                filterRow.clear();
                if (size == row) {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ');
                } else {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ').append(logicDesc).append(' ');
                }
            }
            simpleFilterRow.setLeftBracket(leftBracket);
            simpleFilterRow.setRightBracket(rightBracket);
            ++row;
        }
        return filterStr.toString();
    }
}

