/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.helper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bd.mpdm.common.utils.MMCCommonThreadPoolUtil;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.util.CollectionUtils;
import kd.pmc.pmts.business.helper.workbench.BuildFilterImpl;
import kd.pmc.pmts.business.helper.workbench.BuildFilterInterface;
import kd.pmc.pmts.common.consts.workbench.SingleProjectWorkBenchConst;
import kd.pmc.pmts.common.model.workbench.ProjectTreeBuildContext;
import kd.pmc.pmts.common.model.workbench.ProjectTreeHeaderModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeMenuModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeResultModel;
import kd.pmc.pmts.common.model.workbench.ProjectTreeRowCompent;
import kd.pmc.pmts.common.model.workbench.ProjectTreeRowModel;
import kd.pmc.pmts.common.util.workbench.ProjectTreeUtil;
import kd.pmc.pmts.common.util.workbench.SingleProjectBenchUtil;

public class ProjectTreeDataBuildHelper {
    private static Log logger = LogFactory.getLog(ProjectTreeDataBuildHelper.class);
    private static final Map<String, String> existTreeEntityMap = new HashMap<String, String>();
    private static final String CTRKEY = "custom_projecttree";

    public static void sendProjectTreeData(IFormView view, ProjectTreeBuildContext context) {
        String requestId = UUID.randomUUID().getMostSignificantBits() + "&";
        context.setRequestId(requestId);
        ProjectTreeResultModel resultModel = ProjectTreeDataBuildHelper.buildProjectTree(context);
        CustomControl customCtr = (CustomControl)view.getControl(CTRKEY);
        customCtr.setData((Object)resultModel);
        ProjectTreeUtil.removeCache((IFormView)view);
    }

    public static ProjectTreeResultModel buildProjectTree(ProjectTreeBuildContext context) {
        ProjectTreeResultModel resultModel = new ProjectTreeResultModel();
        ProjectTreeModel projectTreeModel = new ProjectTreeModel();
        resultModel.setData(projectTreeModel);
        resultModel.setMethodName("init");
        DynamicObject fieldConfigDyn = context.getConfigDyn().getDynamicObject("fieldconfig");
        fieldConfigDyn = BusinessDataServiceHelper.loadSingle((Object)fieldConfigDyn.getPkValue(), (String)"pmts_wkbenchfield_def");
        DynamicObjectCollection fieldColl = fieldConfigDyn.getDynamicObjectCollection("fielddefentry");
        List treeNameList = fieldColl.stream().filter(x -> x.getBoolean("isprojstruct")).collect(Collectors.toList());
        String treeName = ResManager.loadKDString((String)"\u9879\u76ee\u7ed3\u6784", (String)"ProjectTreeDataBuildHelper_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]);
        int treeWidth = 250;
        String treeNameKey = "";
        if (CollectionUtils.isNotEmpty(treeNameList) && treeNameList.size() == 1) {
            treeName = ((DynamicObject)treeNameList.get(0)).getString("fieldname");
            treeWidth = ((DynamicObject)treeNameList.get(0)).getInt("colwidth");
            treeNameKey = ((DynamicObject)treeNameList.get(0)).getString("fieldindentif");
        }
        projectTreeModel.getConfigMap().put("treeName", treeName);
        projectTreeModel.getConfigMap().put("treeWidth", treeWidth);
        context.setTreeNameKey(treeNameKey);
        List colDynList = fieldColl.stream().filter(x -> !x.getBoolean("isprojstruct")).collect(Collectors.toList());
        context.setColDynList(colDynList);
        long l = System.currentTimeMillis();
        context.setConfigInfo();
        logger.info("contextbuild:" + (System.currentTimeMillis() - l));
        projectTreeModel.setIconMap(context.getEntityIconMap());
        ArrayList<ProjectTreeHeaderModel> headers = new ArrayList<ProjectTreeHeaderModel>(colDynList.size());
        for (int i = 0; i < colDynList.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)colDynList.get(i);
            ProjectTreeHeaderModel headerModel = new ProjectTreeHeaderModel();
            headerModel.setColIndex(Integer.valueOf(i));
            headerModel.setId(dynamicObject.getString("id"));
            headerModel.setColWidth(Integer.valueOf(dynamicObject.getInt("colwidth")));
            headerModel.setColName(dynamicObject.getString("fieldindentif"));
            headerModel.setColCaption(dynamicObject.getString("fieldname"));
            headers.add(headerModel);
        }
        projectTreeModel.setHeaders(headers);
        List qFilterList = context.getqFilters();
        Map entityFilterMap = context.getEntityFilterMap();
        BuildFilterImpl buildFilter = new BuildFilterImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)buildFilter, BuildFilterInterface.class, (String)"MMC_PMTS_PROJECTTREE_FILTER_EXT", null);
        pluginProxy.callAfter(p -> {
            p.buildEntityFilterByPageData(entityFilterMap, qFilterList);
            return null;
        });
        List<ProjectTreeRowModel> allModelList = ProjectTreeDataBuildHelper.buildRowModelList(context);
        projectTreeModel.setList(allModelList);
        if (CollectionUtils.isNotEmpty(allModelList)) {
            ProjectTreeRowModel rowModel = allModelList.stream().max((x1, x2) -> x1.getTextWidth().compareTo(x2.getTextWidth())).orElseGet(() -> new ProjectTreeRowModel());
            projectTreeModel.getConfigMap().put("treeWidth", rowModel.getTextWidth());
        }
        ThreadExecutorService threadExecutorService = MMCCommonThreadPoolUtil.getThreadExecutorService();
        threadExecutorService.execute(() -> {
            GanttBigObjectCache.put((String)context.getPageId(), (String)"projectTreeModel", (Object)projectTreeModel);
            GanttBigObjectCache.put((String)context.getPageId(), (String)"context", (Object)context);
        }, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
        return resultModel;
    }

    public static List<ProjectTreeRowModel> buildRowModelList(ProjectTreeBuildContext context) {
        ArrayList<ProjectTreeRowModel> allModelList = new ArrayList<ProjectTreeRowModel>(10);
        List patchRelation = context.getPatchRelation();
        HashMap entityMap = new HashMap(patchRelation.size());
        HashMap<Long, Long> initIdToIdMap = new HashMap<Long, Long>(16);
        HashMap entityToFilterIdMap = new HashMap(16);
        HashMap entityToIdMap = new HashMap(16);
        long l = System.currentTimeMillis();
        for (int i = patchRelation.size() - 1; i >= 0; --i) {
            List idList;
            String entityKey = (String)patchRelation.get(i);
            List filterList = context.getEntityFilterMap().getOrDefault(entityKey, new ArrayList());
            ArrayList realFilterList = new ArrayList();
            realFilterList.addAll(filterList);
            if (StringUtils.equals((CharSequence)"pmts_wbs", (CharSequence)entityKey)) {
                idList = (List)entityToFilterIdMap.get("pmpd_project");
                if (idList != null) {
                    realFilterList.add(new QFilter("projectnum", "in", (Object)idList));
                }
            } else if (StringUtils.equals((CharSequence)"pmts_task", (CharSequence)entityKey)) {
                idList = (List)entityToFilterIdMap.get("pmts_wbs");
                if (idList != null) {
                    idList.add(0L);
                    realFilterList.add(new QFilter("wbs", "in", (Object)idList));
                }
            } else if (StringUtils.equals((CharSequence)"pmts_materialreqlist", (CharSequence)entityKey) && (idList = (List)entityToFilterIdMap.get("pmts_task")) != null) {
                realFilterList.add(new QFilter("task", "in", (Object)idList));
            }
            String sortStr = (String)context.getEntitySortMap().get(entityKey);
            String selectItems = (String)context.getEntityFieldMap().get(entityKey);
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityKey, (String)selectItems, (QFilter[])realFilterList.toArray(new QFilter[realFilterList.size()]), (String)sortStr);
            ArrayList<DynamicObject> collect = new ArrayList<DynamicObject>(query.size());
            HashSet<Long> idList2 = new HashSet<Long>(query.size());
            ArrayList<Long> realIdList = new ArrayList<Long>(query.size());
            for (DynamicObject dynamicObject : query) {
                if (idList2.contains(dynamicObject.getLong("id"))) continue;
                collect.add(dynamicObject);
                idList2.add(dynamicObject.getLong("id"));
                if (context.getIsPublish().booleanValue() && SingleProjectWorkBenchConst.VERSION_ENTITY_LIST.contains(entityKey)) {
                    initIdToIdMap.put(dynamicObject.getLong("initid"), dynamicObject.getLong("id"));
                }
                if (context.getIsPublish().booleanValue() && StringUtils.equals((CharSequence)"pmts_task", (CharSequence)entityKey)) {
                    realIdList.add(dynamicObject.getLong("initid"));
                    continue;
                }
                realIdList.add(dynamicObject.getLong("id"));
            }
            entityMap.put(entityKey, collect);
            entityToFilterIdMap.put(entityKey, realIdList);
            entityToIdMap.put(entityKey, idList2);
        }
        logger.info("querydata:" + (System.currentTimeMillis() - l));
        long menuStart = System.currentTimeMillis();
        Map entityMenuMap = context.getEntityMenuMap();
        for (String entityKey : patchRelation) {
            List menuList = entityMenuMap.getOrDefault(entityKey, new ArrayList());
            for (ProjectTreeMenuModel projectTreeMenuModel : menuList) {
                if (!CollectionUtils.isNotEmpty((Collection)projectTreeMenuModel.getqFilters())) continue;
                projectTreeMenuModel.setIsCondition(Boolean.TRUE);
                ArrayList<QFilter> realFilterList = new ArrayList<QFilter>();
                realFilterList.addAll(projectTreeMenuModel.getqFilters());
                realFilterList.add(new QFilter("id", "in", entityToIdMap.getOrDefault(entityKey, new HashSet())));
                List objectList = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])realFilterList.toArray(new QFilter[realFilterList.size()]), null, (int)-1);
                projectTreeMenuModel.setApplyIdSet(objectList.stream().map(x -> x.toString()).collect(Collectors.toSet()));
            }
        }
        logger.info("querymenudata:" + (System.currentTimeMillis() - menuStart));
        ArrayList<ProjectTreeRowCompent> rootComponent = new ArrayList<ProjectTreeRowCompent>(16);
        String rootEntityName = (String)patchRelation.get(patchRelation.size() - 1);
        List rootDynList = (List)entityMap.get(rootEntityName);
        ThreadExecutorService threadExecutorService = MMCCommonThreadPoolUtil.getThreadExecutorService();
        if (CollectionUtils.isNotEmpty((Collection)rootDynList)) {
            long buildCompentStart = System.currentTimeMillis();
            for (Object dynamicObject : rootDynList) {
                ProjectTreeRowCompent rc = new ProjectTreeRowCompent(context, (DynamicObject)dynamicObject);
                rc.setEntityName(rootEntityName);
                rootComponent.add(rc);
            }
            HashMap<Long, ProjectTreeRowCompent> compMap = new HashMap<Long, ProjectTreeRowCompent>(16);
            for (ProjectTreeRowCompent compent : rootComponent) {
                compMap.put(compent.getDynobj().getLong("id"), compent);
            }
            Map upEntityFieldMap = context.getEntityUpFieldMap();
            for (int i = patchRelation.size() - 2; i >= 0; --i) {
                String entityKey = (String)patchRelation.get(i);
                List<DynamicObject> dynList = (List<DynamicObject>)entityMap.get(entityKey);
                if (CollectionUtils.isEmpty((Collection)dynList)) continue;
                String upLevelSelfFlag = existTreeEntityMap.getOrDefault(entityKey, "");
                if (StringUtils.isNotBlank((CharSequence)upLevelSelfFlag)) {
                    dynList = ProjectTreeDataBuildHelper.sortDynamicObject(upLevelSelfFlag, dynList);
                }
                List upFieldList = upEntityFieldMap.getOrDefault(entityKey, new ArrayList());
                for (DynamicObject dynamicObject : dynList) {
                    ProjectTreeRowCompent parentComponent;
                    long selfParentId2;
                    Long parentId = null;
                    if (StringUtils.isNotBlank((CharSequence)upLevelSelfFlag) && (selfParentId2 = dynamicObject.getLong(upLevelSelfFlag)) != 0L && ProjectTreeDataBuildHelper.hasParentComp(initIdToIdMap, compMap, selfParentId2)) {
                        parentId = selfParentId2;
                    }
                    if (parentId == null) {
                        String upField;
                        Iterator selfParentId2 = upFieldList.iterator();
                        while (selfParentId2.hasNext() && ((parentId = Long.valueOf(dynamicObject.getLong(upField = (String)selfParentId2.next()))) == null || parentId == 0L || !ProjectTreeDataBuildHelper.hasParentComp(initIdToIdMap, compMap, parentId))) {
                        }
                    }
                    if (parentId == null || parentId == 0L || (parentComponent = ProjectTreeDataBuildHelper.getParentComponent(compMap, initIdToIdMap, parentId)) == null) continue;
                    ProjectTreeRowCompent rc = new ProjectTreeRowCompent(context, dynamicObject);
                    rc.setLevel(Integer.valueOf(parentComponent.getLevel() + 1));
                    rc.setParentComponent(parentComponent);
                    rc.setEntityName(entityKey);
                    parentComponent.getChildComps().add(rc);
                    compMap.put(dynamicObject.getLong("id"), rc);
                    parentComponent.setLeaf(Boolean.FALSE);
                }
            }
            logger.info("buildCompent:" + (System.currentTimeMillis() - buildCompentStart));
            long creatCompentStart = System.currentTimeMillis();
            ArrayList<ProjectTreeRowCompent> allCompentList = new ArrayList<ProjectTreeRowCompent>(16);
            ProjectTreeDataBuildHelper.getAllCompentList(rootComponent, allCompentList);
            List collList = GanttUtils.spliceArrays(allCompentList, (int)500);
            CountDownLatch countDownLatch = new CountDownLatch(collList.size());
            for (List rowCompentList : collList) {
                threadExecutorService.execute(() -> {
                    try {
                        rowCompentList.forEach(x -> x.createRowModel());
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContextCreator.createForThreadPool(), OperationContext.get());
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException ex) {
                logger.error("\u83b7\u53d6\u7ebf\u7a0b\u9501" + ex.getMessage());
            }
            for (ProjectTreeRowCompent compent : rootComponent) {
                ProjectTreeDataBuildHelper.getAllRowModel(allModelList, compent);
            }
            logger.info("creatCompent:" + (System.currentTimeMillis() - creatCompentStart));
        }
        threadExecutorService.execute(() -> GanttBigObjectCache.put((String)context.getPageId(), (String)"allModelList", (Object)allModelList), MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
        return allModelList;
    }

    private static void getAllCompentList(List<ProjectTreeRowCompent> rootComponent, List<ProjectTreeRowCompent> allCompentList) {
        allCompentList.addAll(rootComponent);
        for (ProjectTreeRowCompent compent : rootComponent) {
            List childComps = compent.getChildComps();
            if (!CollectionUtils.isNotEmpty((Collection)childComps)) continue;
            ProjectTreeDataBuildHelper.getAllCompentList(childComps, allCompentList);
        }
    }

    private static ProjectTreeRowCompent getParentComponent(Map<Long, ProjectTreeRowCompent> compMap, Map<Long, Long> initIdToIdMap, Long parentId) {
        ProjectTreeRowCompent compent = compMap.get(parentId);
        if (compent == null) {
            compent = compMap.get(initIdToIdMap.getOrDefault(parentId, 0L));
        }
        return compent;
    }

    private static boolean hasParentComp(Map<Long, Long> initIdToIdMap, Map<Long, ProjectTreeRowCompent> compMap, long parentId) {
        return compMap.containsKey(parentId) || compMap.containsKey(initIdToIdMap.getOrDefault(parentId, 0L));
    }

    private static void getAllRowModel(List<ProjectTreeRowModel> allModelList, ProjectTreeRowCompent compent) {
        compent.setPidList();
        ProjectTreeRowModel rowDataModel = compent.getRowDataModel();
        allModelList.add(rowDataModel);
        for (ProjectTreeRowCompent childComp : compent.getChildComps()) {
            ProjectTreeDataBuildHelper.getAllRowModel(allModelList, childComp);
        }
    }

    private static List<DynamicObject> sortDynamicObject(String upLevelSelfFlag, List<DynamicObject> dynList) {
        ArrayList<Object> tmpList = new ArrayList<Object>();
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        List idList = dynList.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        for (DynamicObject resobj : dynList) {
            if (resobj.getLong(upLevelSelfFlag) != 0L && idList.contains(resobj.getLong(upLevelSelfFlag))) continue;
            tmpList.add(resobj);
            resultList.add(resobj);
        }
        dynList.removeAll(tmpList);
        while (tmpList.size() > 0) {
            ArrayList<DynamicObject> _tmpList = new ArrayList<DynamicObject>();
            for (DynamicObject dynamicObject : tmpList) {
                for (DynamicObject resobj : dynList) {
                    long parentId;
                    long id = dynamicObject.getLong("id");
                    if (id != (parentId = resobj.getLong(upLevelSelfFlag))) continue;
                    _tmpList.add(resobj);
                    resultList.add(resobj);
                }
            }
            tmpList.clear();
            tmpList.addAll(_tmpList);
            dynList.removeAll(tmpList);
        }
        return resultList;
    }

    public static void partRefresh(IFormView view, String selectDataId) {
        List oldModelList = (List)GanttBigObjectCache.get((String)view.getPageId(), (String)"allModelList");
        ProjectTreeBuildContext context = SingleProjectBenchUtil.getContextByCache((String)view.getPageId());
        List<ProjectTreeRowModel> projectTreeRowModels = ProjectTreeDataBuildHelper.buildRowModelList(context);
        long l = System.currentTimeMillis();
        List<Map<String, Object>> modifyData = ProjectTreeDataBuildHelper.getModifyData(oldModelList, projectTreeRowModels);
        logger.info("\u83b7\u53d6\u4fee\u6539\u6570\u636e\u7684\u65f6\u95f4:" + (System.currentTimeMillis() - l));
        CustomControl customCtr = (CustomControl)view.getControl(CTRKEY);
        HashMap<String, Object> refreshResult = new HashMap<String, Object>(2);
        refreshResult.put("detailId", StringUtils.isNotBlank((CharSequence)selectDataId) ? context.getRequestId().concat(selectDataId) : "");
        refreshResult.put("rows", modifyData);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("methodName", "updateRows");
        resultMap.put("success", Boolean.TRUE);
        resultMap.put("sendTime", System.currentTimeMillis());
        resultMap.put("data", refreshResult);
        customCtr.setData(resultMap);
        ThreadExecutorService threadExecutorService = MMCCommonThreadPoolUtil.getThreadExecutorService();
        threadExecutorService.execute(() -> {
            GanttBigObjectCache.put((String)view.getPageId(), (String)"context", (Object)context);
            GanttBigObjectCache.put((String)context.getPageId(), (String)"projectTreeModel", (Object)projectTreeRowModels);
        }, MMCCommonThreadPoolUtil.TaskTypeEnum.PMC_TASK.getTaskTypeName(), RequestContext.get(), OperationContext.get());
    }

    private static List<Map<String, Object>> getModifyData(List<ProjectTreeRowModel> orginDataList, List<ProjectTreeRowModel> dataList) {
        if (orginDataList == null) {
            orginDataList = new ArrayList<ProjectTreeRowModel>();
        }
        if (dataList == null) {
            dataList = new ArrayList<ProjectTreeRowModel>();
        }
        ArrayList<Integer> deleteList = new ArrayList<Integer>(10);
        ArrayList<Integer> addList = new ArrayList<Integer>(10);
        ArrayList<Integer> updateList = new ArrayList<Integer>(10);
        ArrayList<ProjectTreeRowModel> addModelList = new ArrayList<ProjectTreeRowModel>(10);
        ArrayList<ProjectTreeRowModel> updateModelList = new ArrayList<ProjectTreeRowModel>(10);
        int dataIndex = 0;
        Iterator<ProjectTreeRowModel> iterator = orginDataList.iterator();
        int deleteIndex = 0;
        while (iterator.hasNext()) {
            ProjectTreeRowModel orginData = iterator.next();
            if (dataIndex >= dataList.size()) {
                deleteList.add(deleteIndex);
                iterator.remove();
            } else {
                ProjectTreeRowModel rowModel = dataList.get(dataIndex);
                if (StringUtils.equals((CharSequence)ProjectTreeDataBuildHelper.getModelId(orginData), (CharSequence)ProjectTreeDataBuildHelper.getModelId(rowModel))) {
                    ++dataIndex;
                } else {
                    deleteList.add(deleteIndex);
                    iterator.remove();
                }
            }
            ++deleteIndex;
        }
        int orginIndex = 0;
        for (int i = 0; i < dataList.size(); ++i) {
            ProjectTreeRowModel orginModel;
            ProjectTreeRowModel dataModel = dataList.get(i);
            ProjectTreeRowModel projectTreeRowModel = orginModel = orginIndex >= orginDataList.size() ? null : orginDataList.get(orginIndex);
            if (StringUtils.equals((CharSequence)ProjectTreeDataBuildHelper.getModelId(dataModel), (CharSequence)ProjectTreeDataBuildHelper.getModelId(orginModel))) {
                if (!dataModel.equals((Object)orginModel)) {
                    updateList.add(i);
                    updateModelList.add(dataModel);
                }
                ++orginIndex;
                continue;
            }
            addList.add(i);
            addModelList.add(dataModel);
        }
        return ProjectTreeDataBuildHelper.getRowChangeList(deleteList, addList, updateList, addModelList, updateModelList);
    }

    private static String getModelId(ProjectTreeRowModel model) {
        return model == null ? "" : model.getId();
    }

    private static List<Map<String, Object>> getRowChangeList(List<Integer> deleteList, List<Integer> addList, List<Integer> updateList, List<ProjectTreeRowModel> addModelList, List<ProjectTreeRowModel> updateModelList) {
        List<List<Integer>> delete = ProjectTreeDataBuildHelper.getSerialNumList(deleteList);
        List<List<Integer>> add = ProjectTreeDataBuildHelper.getSerialNumList(addList);
        List<List<Integer>> update = ProjectTreeDataBuildHelper.getSerialNumList(updateList);
        ArrayList<Map<String, Object>> changeList = new ArrayList<Map<String, Object>>(10);
        for (int i = delete.size() - 1; i >= 0; --i) {
            HashMap<String, Serializable> rowDeleteMap = new HashMap<String, Serializable>(3);
            rowDeleteMap.put("start", delete.get(i).get(0));
            rowDeleteMap.put("deleteLen", Integer.valueOf(delete.get(i).size()));
            rowDeleteMap.put("items", new ArrayList(1));
            changeList.add(rowDeleteMap);
        }
        int addModelIndex = 0;
        for (int i = 0; i < add.size(); ++i) {
            HashMap<String, Object> rowAddMap = new HashMap<String, Object>(3);
            List<Integer> list = add.get(i);
            rowAddMap.put("start", list.get(0));
            rowAddMap.put("deleteLen", 0);
            rowAddMap.put("items", addModelList.subList(addModelIndex, addModelIndex += list.size()));
            changeList.add(rowAddMap);
        }
        int updateModelIndex = 0;
        for (int i = 0; i < update.size(); ++i) {
            HashMap<String, Object> rowUpdateMap = new HashMap<String, Object>(3);
            List<Integer> list = update.get(i);
            rowUpdateMap.put("start", list.get(0));
            rowUpdateMap.put("deleteLen", list.size());
            rowUpdateMap.put("items", updateModelList.subList(updateModelIndex, updateModelIndex += list.size()));
            changeList.add(rowUpdateMap);
        }
        return changeList;
    }

    public static List<List<Integer>> getSerialNumList(List<Integer> list) {
        ArrayList<List<Integer>> resultList = new ArrayList<List<Integer>>();
        if (list.size() == 0) {
            return resultList;
        }
        ArrayList<Integer> arrList = new ArrayList<Integer>();
        resultList.add(arrList);
        if (list.size() == 1) {
            ((List)resultList.get(resultList.size() - 1)).add(list.get(0));
            return resultList;
        }
        for (int i = 0; i < list.size(); ++i) {
            Integer nextNum = list.get(i + 1);
            Integer nowNum = list.get(i);
            if (nextNum - nowNum != 1) {
                ((List)resultList.get(resultList.size() - 1)).add(nowNum);
                arrList = new ArrayList();
                resultList.add(arrList);
            } else {
                arrList.add(nowNum);
            }
            if (i + 1 != list.size() - 1) continue;
            arrList.add(nextNum);
            break;
        }
        return resultList;
    }

    public static void openReturnData(ClosedCallBackEvent event, IFormView view, String entity) {
        ProjectTreeBuildContext context;
        String dataId = (String)event.getReturnData();
        if (StringUtils.isBlank((CharSequence)dataId)) {
            dataId = view.getPageCache().get("fastSaveId");
        }
        if ((context = SingleProjectBenchUtil.getContextByCache((String)view.getPageId())) != null) {
            ProjectTreeDataBuildHelper.partRefresh(view, dataId);
            if (StringUtils.isBlank((CharSequence)dataId)) {
                view.getPageCache().remove("selectEntity");
                view.getPageCache().remove("selectDataId");
            } else {
                view.getPageCache().put("selectEntity", entity);
                view.getPageCache().put("selectDataId", dataId);
            }
            Tab tabAp = (Tab)view.getControl("tabap");
            String currentTab = tabAp.getCurrentTab();
            if (StringUtils.equals((CharSequence)currentTab, (CharSequence)"tab_change")) {
                SingleProjectBenchUtil.showChangeTabInfo((IFormView)view);
            } else {
                tabAp.activeTab("tab_change");
            }
            SingleProjectBenchUtil.changeTabName((IFormView)view, (String)entity);
        }
    }

    static {
        existTreeEntityMap.put("pmts_wbs", "parent");
    }
}

