/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt;

import java.util.ArrayList;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class DataTypeCastFunction
extends GroupReduceFunction {
    private String fieldName;
    private DataType dataType;

    public DataTypeCastFunction(String field, DataType dataType) {
        this.fieldName = field;
        this.dataType = dataType;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta rowMeta = this.getSourceRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        for (RowX rowX : iterable) {
            for (int i = 0; i < fieldNames.length; ++i) {
                String typeName;
                String curFieldName = fieldNames[i];
                Object value = rowX.get(i);
                if (!curFieldName.equals(this.fieldName)) continue;
                switch (typeName = this.dataType.getName()) {
                    case "Integer": {
                        if (value != null) {
                            String v = String.valueOf(value);
                            if (StringUtils.isNotEmpty((String)v)) {
                                value = Integer.valueOf(v);
                                break;
                            }
                            value = null;
                            break;
                        }
                        value = null;
                    }
                }
                rowX.set(i, value);
            }
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta rowMeta = this.getSourceRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<Field> list = new ArrayList<Field>();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            if (this.fieldName.equals(name)) {
                list.add(new Field(name, this.dataType));
                continue;
            }
            list.add(new Field(name, field.getDataType()));
        }
        return new RowMeta(list.toArray(new Field[list.size()]));
    }
}

