/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.purorder;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmts.formplugin.workbench.rpt.RowCloseStatusEnum;
import kd.pmc.pmts.formplugin.workbench.rpt.RowTerminateStatusEnum;
import kd.pmc.pmts.formplugin.workbench.rpt.purorder.DateUtil;
import kd.pmc.pmts.formplugin.workbench.rpt.purorder.PurRptHelper;

public class PurOrderRptHelper {
    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public static List<QFilter> getFilters(Map<String, Object> params) {
        DynamicObject billtype;
        DynamicObjectCollection wbs;
        DynamicObjectCollection projects;
        DynamicObjectCollection bizdepts;
        DynamicObjectCollection bizoperatorgroups;
        DynamicObjectCollection bizoperators;
        DynamicObjectCollection materials;
        DynamicObjectCollection purOrderBillNo;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        Date startDate = (Date)params.get("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate(startDate, false)));
        Date endDate = (Date)params.get("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection org = (DynamicObjectCollection)params.get("orgfield");
        if (org != null && org.size() > 0) {
            Object[] orgs = PurOrderRptHelper.getBaseDataPkIds(org);
            filters.add(new QFilter("org", "in", (Object)orgs));
        }
        if ((supplers = (DynamicObjectCollection)params.get("supplierfield")) != null && supplers.size() > 0) {
            Object[] supplerids = PurRptHelper.getMasterIds(supplers);
            filters.add(new QFilter("supplier.masterid", "in", (Object)supplerids));
        }
        if ((purOrderBillNo = (DynamicObjectCollection)params.get("selectbill")) != null && purOrderBillNo.size() > 0) {
            Object[] billNo = PurOrderRptHelper.getBaseDataPkIds(purOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((materials = (DynamicObjectCollection)params.get("materialfield")) != null && materials.size() > 0) {
            Object[] materialIds = PurOrderRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        if ((bizoperators = (DynamicObjectCollection)params.get("bizoperatorfield")) != null && bizoperators.size() > 0) {
            Object[] bizoperatorIds = PurOrderRptHelper.getBaseDataPkIds(bizoperators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorIds));
        }
        if ((bizoperatorgroups = (DynamicObjectCollection)params.get("bizoperatorgroupfield")) != null && bizoperatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = PurOrderRptHelper.getBaseDataPkIds(bizoperatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((bizdepts = (DynamicObjectCollection)params.get("bizdeptfield")) != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = PurOrderRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((projects = (DynamicObjectCollection)params.get("project")) != null && projects.size() > 0) {
            Object[] projectIds = PurOrderRptHelper.getBaseDataPkIds(projects);
            filters.add(new QFilter("billentry.project.id", "in", (Object)projectIds));
        }
        if ((wbs = (DynamicObjectCollection)params.get("wbs")) != null && wbs.size() > 0) {
            Object[] wbsIds = PurOrderRptHelper.getBaseDataPkIds(wbs);
            filters.add(new QFilter("billentry.wbs.id", "in", (Object)wbsIds));
        }
        if ((billtype = (DynamicObject)params.get("billtypefield")) != null && billtype.getPkValue() != null) {
            filters.add(new QFilter("billtype", "=", billtype.getPkValue()));
        }
        List<QFilter> statusfilters = PurOrderRptHelper.getStatusFilter(params);
        filters.addAll(statusfilters);
        filters.add(new QFilter("billentry.material", "!=", null));
        filters.add(new QFilter("billentry.material.masterid", "!=", null));
        return filters;
    }

    private static List<QFilter> getStatusFilter(Map<String, Object> params) {
        String rowstatus;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String billstatus = (String)params.get("billstatusfield");
        if ("A".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "in", (Object)new String[]{"C", "B"}));
        } else if ("B".equals(billstatus)) {
            filters.add(new QFilter("billstatus", "=", (Object)"B"));
        } else {
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        String closestatus = (String)params.get("closestatusfield");
        if ("B".equals(closestatus) || "A".equals(closestatus)) {
            filters.add(new QFilter("closestatus", "=", (Object)closestatus));
        }
        if ("B".equals(rowstatus = (String)params.get("rowstatusfield"))) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
            qFilter.or(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.ROWTERMINATE.getValue()));
            filters.add(qFilter);
        } else if ("A".equals(rowstatus)) {
            QFilter qFilter = new QFilter("billentry.rowclosestatus", "=", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            qFilter.and(new QFilter("billentry.rowterminatestatus", "=", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
            filters.add(qFilter);
        }
        return filters;
    }
}

