/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.workbench.rpt.salorder;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class JoinFinArBillFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<Integer, Field> indexMap;
    private String[] orderShowCols;

    public JoinFinArBillFunction(RowMeta rowMeta, String[] orderShowCols) {
        this.rowMeta = rowMeta;
        this.orderShowCols = orderShowCols;
        Field[] fields = rowMeta.getFields();
        if (this.indexMap == null) {
            this.indexMap = new HashMap<Integer, Field>(fields.length);
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            this.indexMap.putIfAbsent(i, field);
        }
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> asstactIds = new HashSet<Long>();
        HashSet<Long> settleorgIds = new HashSet<Long>();
        HashSet<Long> billIds = new HashSet<Long>();
        HashSet<Long> entryIds = new HashSet<Long>();
        Date auditdateMin = new Date(System.currentTimeMillis());
        Iterator<RowX> iterator = iterable.iterator();
        int size = this.indexMap.size();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            Object[] objs = new Object[size];
            RowX rowX = iterator.next();
            for (int i = 0; i < size; ++i) {
                Object value = rowX.get(i);
                Field field = this.indexMap.get(i);
                objs[i] = value == null && field.getDataType() instanceof BigDecimalType ? BigDecimal.ZERO : value;
                if (value != null && "settlecustomer".equals(field.getName()) && (Long)value != 0L) {
                    asstactIds.add((Long)value);
                }
                if (value != null && "entrysettleorg".equals(field.getName()) && (Long)value != 0L) {
                    settleorgIds.add((Long)value);
                }
                if (value != null && "id".equals(field.getName()) && (Long)value != 0L) {
                    billIds.add((Long)value);
                }
                if (value != null && "billentryid".equals(field.getName()) && (Long)value != 0L) {
                    entryIds.add((Long)value);
                }
                if (value == null || !"auditdate".equals(field.getName()) || !((Date)value).before(auditdateMin)) continue;
                auditdateMin = (Date)value;
            }
            list.add(objs);
        }
        Algo algo = Algo.create((String)"queryFinArData");
        try (DataSet srcData = algo.createDataSet(list.iterator(), this.rowMeta);){
            DataSet finish = srcData;
            QFilter defaultArQF = QFilter.of((String)"1=1", (Object[])new Object[0]);
            QFilter idsftr = new QFilter("entry.corebillid", "in", billIds);
            QFilter entryIdsftr = new QFilter("entry.corebillentryid", "in", entryIds);
            QFilter statusftr = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
            QFilter settleorgftr = new QFilter("org", "in", settleorgIds);
            QFilter asstactftr = new QFilter("asstact", "in", asstactIds);
            QFilter iswrittenoff = new QFilter("iswrittenoff", "=", (Object)Character.valueOf('0'));
            QFilter hadwrittenoff = new QFilter("hadwrittenoff", "=", (Object)Character.valueOf('0'));
            QFilter auditdate = new QFilter("bizdate", ">=", (Object)JoinFinArBillFunction.getDate(auditdateMin));
            QFilter finArQfilter = defaultArQF.and(settleorgftr).and(auditdate).and(asstactftr).and(statusftr).and(iswrittenoff).and(hadwrittenoff).and(idsftr).and(entryIdsftr);
            DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"queryFinAr", (String)"ar_finarbill", (String)"entry.corebillid as corebillid, entry.corebillentryid as corebillentryid, entry.e_issueinvrecamt as issueinvrecamt, entry.e_settledamt as settledamt", (QFilter[])finArQfilter.toArray(), null);
            if (finArDataSet.hasNext()) {
                DataSet finArDS = finArDataSet.groupBy(new String[]{"corebillid", "corebillentryid"}).sum("issueinvrecamt").sum("settledamt").finish();
                finish = srcData.leftJoin(finArDS).on("billentryid", "corebillentryid").select(this.orderShowCols, new String[]{"issueinvrecamt", "settledamt"}).finish();
            } else {
                if (Arrays.stream(finish.getRowMeta().getFieldNames()).noneMatch(e -> "issueinvrecamt".equals(e))) {
                    finish = finish.addField("cast(0 as Decimal)", "issueinvrecamt");
                }
                if (Arrays.stream(finish.getRowMeta().getFieldNames()).noneMatch(e -> "settledamt".equals(e))) {
                    finish = finish.addField("cast(0 as Decimal)", "settledamt");
                }
            }
            QFilter defaultBusQF = QFilter.of((String)"1=1", (Object[])new Object[0]);
            QFilter busIDftr = new QFilter("entry.e_corebillid", "in", billIds);
            QFilter busEntryIDftr = new QFilter("entry.e_corebillentryid", "in", entryIds);
            QFilter finBusQfilter = defaultBusQF.and(settleorgftr).and(auditdate).and(asstactftr).and(statusftr).and(iswrittenoff).and(hadwrittenoff).and(busIDftr).and(busEntryIDftr);
            DataSet finBusDataSet = QueryServiceHelper.queryDataSet((String)"queryFinBus", (String)"ar_revcfmbill", (String)"entry.e_corebillid as corebillid, entry.e_corebillentryid as corebillentryid, entry.e_cfmpricetax as confirmamountandtax,entry.e_cfmpricetaxbase as curconfirmamountandtax", (QFilter[])finBusQfilter.toArray(), null);
            if (finBusDataSet.hasNext()) {
                DataSet finBusDs = finBusDataSet.groupBy(new String[]{"corebillid", "corebillentryid"}).sum("confirmamountandtax").sum("curconfirmamountandtax").finish();
                ArrayList<String> selList = new ArrayList<String>();
                selList.add("issueinvrecamt");
                selList.add("settledamt");
                selList.addAll(Arrays.asList(this.orderShowCols));
                finish = finish.leftJoin(finBusDs).on("billentryid", "corebillentryid").select(selList.toArray(new String[0]), new String[]{"confirmamountandtax", "curconfirmamountandtax"}).finish();
            } else {
                if (Arrays.stream(finish.getRowMeta().getFieldNames()).noneMatch(e -> "confirmamountandtax".equals(e))) {
                    finish = finish.addField("cast(0 as Decimal)", "confirmamountandtax");
                }
                if (Arrays.stream(finish.getRowMeta().getFieldNames()).noneMatch(e -> "curconfirmamountandtax".equals(e))) {
                    finish = finish.addField("cast(0 as Decimal)", "curconfirmamountandtax");
                }
            }
            while (finish.hasNext()) {
                Row next = finish.next();
                Object[] objs = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Field field = this.indexMap.get(i);
                    Object value = next.get(field.getName());
                    objs[i] = value == null && field.getDataType() instanceof BigDecimalType ? BigDecimal.ZERO : value;
                }
                collector.collect(new RowX(objs));
            }
            list = null;
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private static Date getDate(Date date) {
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = dateFormate.format(date);
        Date targetDate = null;
        try {
            targetDate = dateFormate.parse(dateStr);
        }
        catch (ParseException e) {
            throw new KDBizException(e.getMessage());
        }
        return targetDate;
    }
}

